/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.model;

import java.sql.DriverPropertyInfo;

public class DriverPropertyInfoBuilder {
    private String name;
    private String value;
    private boolean required;
    private String description;
    private String[] choices;

    public static DriverPropertyInfoBuilder from(DriverPropertyInfo info) {
        return new DriverPropertyInfoBuilder().withName(info.name).withValue(info.value).isRequired(info.required).withDescription(info.description).withChoices(info.choices);
    }

    public static DriverPropertyInfoBuilder from(String name, String value) {
        return new DriverPropertyInfoBuilder().withName(name).withValue(value);
    }

    public DriverPropertyInfoBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public DriverPropertyInfoBuilder withValue(String value) {
        this.value = value;
        return this;
    }

    public DriverPropertyInfoBuilder isRequired(boolean required) {
        this.required = required;
        return this;
    }

    public DriverPropertyInfoBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public DriverPropertyInfoBuilder withChoices(String[] choices) {
        this.choices = choices;
        return this;
    }

    public DriverPropertyInfo build() {
        DriverPropertyInfo info = new DriverPropertyInfo(this.name, this.value);
        info.required = this.required;
        info.description = this.description;
        info.choices = this.choices;
        return info;
    }
}

