/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.OutOfDiskSpaceHandler;
import org.zaproxy.zap.utils.Stats;

public final class ErrorUtils {
    private static final Logger LOGGER = LogManager.getLogger(ErrorUtils.class);
    private static OutOfDiskSpaceHandler outOfDiskSpaceHandler = new DefaultOutOfDiskSpaceHandler();

    private ErrorUtils() {
    }

    public static boolean handleDiskSpaceException(Exception e) {
        return outOfDiskSpaceHandler.handleDiskSpaceException(e);
    }

    public static void setOutOfDiskSpaceHandler(OutOfDiskSpaceHandler outOfDiskSpaceHandler) {
        ErrorUtils.outOfDiskSpaceHandler = outOfDiskSpaceHandler != null ? outOfDiskSpaceHandler : new DefaultOutOfDiskSpaceHandler();
    }

    public static OutOfDiskSpaceHandler getOutOfDiskSpaceHandler() {
        return outOfDiskSpaceHandler;
    }

    public static boolean hasCause(Exception e, List<String> wantedMessages) {
        String message = ErrorUtils.getCauseMessage(e);
        if (message == null) {
            return false;
        }
        return wantedMessages.stream().anyMatch(message::contains);
    }

    public static boolean hasCause(Exception e, String wantedMessage) {
        String message = ErrorUtils.getCauseMessage(e);
        return message != null && message.contains(wantedMessage);
    }

    private static String getCauseMessage(Exception e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            return null;
        }
        String message = cause.getMessage();
        if (message == null) {
            return null;
        }
        return message;
    }

    private static class DefaultOutOfDiskSpaceHandler
    implements OutOfDiskSpaceHandler {
        private boolean outOfSpace;
        private boolean exitOnOutOfSpace = true;
        private static final List<String> DB_FULL_MSGS = List.of("Data File size limit is reached");
        private static final List<String> DISK_FULL_MSGS = List.of("No space left on device", "There is not enough space on the disk", "file input/output error");

        private DefaultOutOfDiskSpaceHandler() {
        }

        @Override
        public boolean handleDiskSpaceException(Exception e) {
            boolean dbFull = ErrorUtils.hasCause(e, DB_FULL_MSGS);
            boolean diskFull = ErrorUtils.hasCause(e, DISK_FULL_MSGS);
            if ((dbFull || diskFull) && !this.outOfSpace) {
                String errorMsg;
                if (dbFull) {
                    errorMsg = Constant.messages.getString("db.space.full");
                    Stats.incCounter("stats.error.database.full");
                } else {
                    errorMsg = Constant.messages.getString("disk.space.full");
                    Stats.incCounter("stats.error.diskspace.full");
                }
                this.logAndStderr(errorMsg);
                this.outOfSpace = true;
                if (View.isInitialised()) {
                    View.getSingleton().showWarningDialog(errorMsg);
                } else if (this.exitOnOutOfSpace) {
                    this.logAndStderr("Shutting down ZAP due to space issues...");
                    Control control = Control.getSingleton();
                    control.setExitStatus(2, errorMsg);
                    control.exit(false, null);
                }
            }
            return dbFull || diskFull;
        }

        private void logAndStderr(String msg) {
            System.err.println(msg);
            LOGGER.error(msg);
        }

        @Override
        public boolean isOutOfSpace() {
            return this.outOfSpace;
        }

        @Override
        public boolean isExitOnOutOfSpace() {
            return this.exitOnOutOfSpace;
        }

        @Override
        public void setExitOnOutOfSpace(boolean exitOnOutOfSpace) {
            this.exitOnOutOfSpace = exitOnOutOfSpace;
        }
    }
}

