/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.node;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import org.apache.solr.metrics.prometheus.SolrMetric;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.node.SolrNodeMetric;

public class SolrNodeHandlerMetric
extends SolrNodeMetric {
    public static final String NODE_REQUESTS = "solr_metrics_node_requests";
    public static final String NODE_SECONDS_TOTAL = "solr_metrics_node_requests_time";
    public static final String NODE_CONNECTIONS = "solr_metrics_node_connections";

    public SolrNodeHandlerMetric(Metric dropwizardMetric, String metricName) {
        super(dropwizardMetric, metricName);
    }

    @Override
    public SolrMetric parseLabels() {
        String[] parsedMetric = this.metricName.split("\\.");
        this.labels.put("category", parsedMetric[0]);
        this.labels.put("handler", parsedMetric[1]);
        this.labels.put("type", parsedMetric[2]);
        return this;
    }

    @Override
    public void toPrometheus(SolrPrometheusFormatter formatter) {
        if (this.metricName.endsWith(".totalTime")) {
            this.labels.remove("type");
            formatter.exportCounter(NODE_SECONDS_TOTAL, (Counter)this.dropwizardMetric, this.getLabels());
        } else if (this.metricName.endsWith("Connections")) {
            formatter.exportGauge(NODE_CONNECTIONS, (Gauge)this.dropwizardMetric, this.getLabels());
        } else if (this.dropwizardMetric instanceof Meter) {
            formatter.exportMeter(NODE_REQUESTS, (Meter)this.dropwizardMetric, this.getLabels());
        } else if (this.dropwizardMetric instanceof Counter) {
            formatter.exportCounter(NODE_REQUESTS, (Counter)this.dropwizardMetric, this.getLabels());
        }
    }
}

