/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.DeleteReplicaApi;
import org.apache.solr.client.api.model.ScaleCollectionRequestBody;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class DeleteReplica
extends AdminAPIBase
implements DeleteReplicaApi {
    @Inject
    public DeleteReplica(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse deleteReplicaByName(String collectionName, String shardName, String replicaName, Boolean followAliases, Boolean deleteInstanceDir, Boolean deleteDataDir, Boolean deleteIndex, Boolean onlyIfDown, String async) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("shard", shardName);
        this.ensureRequiredParameterProvided("replica", replicaName);
        this.fetchAndValidateZooKeeperAwareCoreContainer();
        DeleteReplica.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = DeleteReplica.createRemoteMessage(collectionName, shardName, replicaName, null, followAliases, deleteInstanceDir, deleteDataDir, deleteIndex, onlyIfDown, async);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.DELETEREPLICA, remoteMessage, async);
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse deleteReplicasByCount(String collectionName, String shardName, Integer numToDelete, Boolean followAliases, Boolean deleteInstanceDir, Boolean deleteDataDir, Boolean deleteIndex, Boolean onlyIfDown, String asyncId) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("shard", shardName);
        this.ensureRequiredParameterProvided("count", numToDelete);
        this.fetchAndValidateZooKeeperAwareCoreContainer();
        DeleteReplica.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = DeleteReplica.createRemoteMessage(collectionName, shardName, null, numToDelete, followAliases, deleteInstanceDir, deleteDataDir, deleteIndex, onlyIfDown, asyncId);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.DELETEREPLICA, remoteMessage, asyncId);
        return response;
    }

    public static ScaleCollectionRequestBody createScaleRequestBodyFromV1Params(SolrParams v1Params) {
        ScaleCollectionRequestBody requestBody = new ScaleCollectionRequestBody();
        requestBody.numToDelete = v1Params.getInt("count");
        requestBody.followAliases = v1Params.getBool("followAliases");
        requestBody.deleteInstanceDir = v1Params.getBool("deleteInstanceDir");
        requestBody.deleteDataDir = v1Params.getBool("deleteDataDir");
        requestBody.deleteIndex = v1Params.getBool("deleteIndex");
        requestBody.onlyIfDown = v1Params.getBool("onlyIfDown");
        requestBody.async = v1Params.get("async");
        return requestBody;
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse deleteReplicasByCountAllShards(String collectionName, ScaleCollectionRequestBody requestBody) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Request body is required but missing");
        }
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("count", requestBody.numToDelete);
        this.fetchAndValidateZooKeeperAwareCoreContainer();
        DeleteReplica.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = DeleteReplica.createRemoteMessage(collectionName, null, null, requestBody.numToDelete, requestBody.followAliases, requestBody.deleteInstanceDir, requestBody.deleteDataDir, requestBody.deleteIndex, requestBody.onlyIfDown, requestBody.async);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.DELETEREPLICA, remoteMessage, requestBody.async);
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, String shardName, String replicaName, Integer numReplicasToDelete, Boolean followAliases, Boolean deleteInstanceDir, Boolean deleteDataDir, Boolean deleteIndex, Boolean onlyIfDown, String asyncId) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.DELETEREPLICA.toLower());
        remoteMessage.put("collection", collectionName);
        DeleteReplica.insertIfNotNull(remoteMessage, "shard", shardName);
        DeleteReplica.insertIfNotNull(remoteMessage, "replica", replicaName);
        DeleteReplica.insertIfNotNull(remoteMessage, "count", numReplicasToDelete);
        DeleteReplica.insertIfNotNull(remoteMessage, "followAliases", followAliases);
        DeleteReplica.insertIfNotNull(remoteMessage, "deleteInstanceDir", deleteInstanceDir);
        DeleteReplica.insertIfNotNull(remoteMessage, "deleteDataDir", deleteDataDir);
        DeleteReplica.insertIfNotNull(remoteMessage, "deleteIndex", deleteIndex);
        DeleteReplica.insertIfNotNull(remoteMessage, "onlyIfDown", onlyIfDown);
        DeleteReplica.insertIfNotNull(remoteMessage, "async", asyncId);
        return new ZkNodeProps(remoteMessage);
    }

    public static void invokeWithV1Params(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws Exception {
        SolrParams v1Params = solrQueryRequest.getParams();
        v1Params.required().check(new String[]{"collection"});
        DeleteReplica deleteReplicaApi = new DeleteReplica(coreContainer, solrQueryRequest, solrQueryResponse);
        SubResponseAccumulatingJerseyResponse v2Response = DeleteReplica.invokeApiMethod(deleteReplicaApi, v1Params);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(solrQueryResponse, v2Response);
    }

    private static SubResponseAccumulatingJerseyResponse invokeApiMethod(DeleteReplica deleteReplicaApi, SolrParams v1Params) throws Exception {
        if (v1Params.get("replica") != null && v1Params.get("shard") != null) {
            return deleteReplicaApi.deleteReplicaByName(v1Params.get("collection"), v1Params.get("shard"), v1Params.get("replica"), v1Params.getBool("followAliases"), v1Params.getBool("deleteInstanceDir"), v1Params.getBool("deleteDataDir"), v1Params.getBool("deleteIndex"), v1Params.getBool("onlyIfDown"), v1Params.get("async"));
        }
        if (v1Params.get("shard") != null && v1Params.get("count") != null) {
            return deleteReplicaApi.deleteReplicasByCount(v1Params.get("collection"), v1Params.get("shard"), v1Params.getInt("count"), v1Params.getBool("followAliases"), v1Params.getBool("deleteInstanceDir"), v1Params.getBool("deleteDataDir"), v1Params.getBool("deleteIndex"), v1Params.getBool("onlyIfDown"), v1Params.get("async"));
        }
        if (v1Params.get("count") != null) {
            return deleteReplicaApi.deleteReplicasByCountAllShards(v1Params.get("collection"), DeleteReplica.createScaleRequestBodyFromV1Params(v1Params));
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "DELETEREPLICA requires either count or replica parameters");
    }
}

