/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.Compressor;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.ZLibCompressor;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.packagemanager.PackageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkCpTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ZkCpTool(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder().longOpt("solr-home").argName("DIR").hasArg().required(false).desc("Required to look up configuration for compressing state.json.").build(), SolrCLI.OPTION_RECURSE_DEPRECATED, SolrCLI.OPTION_RECURSIVE, SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED);
    }

    @Override
    public String getName() {
        return "cp";
    }

    @Override
    public String getUsage() {
        return "bin/solr zk cp [-r ] [-s <HOST>] [--solr-home <DIR>] [-u <credentials>] [-z <HOST>] source destination";
    }

    @Override
    public String getHeader() {
        StringBuilder sb = new StringBuilder();
        PackageUtils.format(sb, "cp copies files or folders to/from Zookeeper or Zookeeper -> Zookeeper");
        PackageUtils.format(sb, "");
        PackageUtils.format(sb, "<src>, <dest> : [file:][/]path/to/local/file or zk:/path/to/zk/node");
        PackageUtils.format(sb, "                NOTE: <src> and <dest> may both be Zookeeper resources prefixed by 'zk:'");
        PackageUtils.format(sb, "When <src> is a zk resource, <dest> may be '.'");
        PackageUtils.format(sb, "If <dest> ends with '/', then <dest> will be a local folder or parent znode and the last");
        PackageUtils.format(sb, "element of the <src> path will be appended unless <src> also ends in a slash. ");
        PackageUtils.format(sb, "<dest> may be zk:, which may be useful when using the cp -r form to backup/restore ");
        PackageUtils.format(sb, "the entire zk state.");
        PackageUtils.format(sb, "You must enclose local paths that end in a wildcard in quotes or just");
        PackageUtils.format(sb, "end the local path in a slash. That is,");
        PackageUtils.format(sb, "'bin/solr zk cp -r /some/dir/ zk:/ -z localhost:2181' is equivalent to");
        PackageUtils.format(sb, "'bin/solr zk cp -r \"/some/dir/*\" zk:/ -z localhost:2181'");
        PackageUtils.format(sb, "but 'bin/solr zk cp -r /some/dir/* zk:/ -z localhost:2181' will throw an error");
        PackageUtils.format(sb, "");
        PackageUtils.format(sb, "to copy to local: 'bin/solr zk cp -r zk:/ /some/dir -z localhost:2181'");
        PackageUtils.format(sb, "to restore to ZK: 'bin/solr zk cp -r /some/dir/ zk:/ -z localhost:2181'");
        PackageUtils.format(sb, "");
        PackageUtils.format(sb, "The 'file:' prefix is stripped, thus 'file:/wherever' specifies an absolute local path and");
        PackageUtils.format(sb, "'file:somewhere' specifies a relative local path. All paths on Zookeeper are absolute.");
        PackageUtils.format(sb, "");
        PackageUtils.format(sb, "Zookeeper nodes CAN have data, so moving a single file to a parent znode");
        PackageUtils.format(sb, "will overlay the data on the parent Znode so specifying the trailing slash");
        PackageUtils.format(sb, "can be important.");
        PackageUtils.format(sb, "");
        PackageUtils.format(sb, "Wildcards are supported when copying from local, trailing only and must be quoted.");
        PackageUtils.format(sb, "\nList of options:");
        return sb.toString();
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
        String src = cli.getArgs()[0];
        String dst = cli.getArgs()[1];
        boolean recursive = cli.hasOption("recursive") || cli.hasOption("recurse");
        this.echo("Copying from '" + src + "' to '" + dst + "'. ZooKeeper at " + zkHost);
        boolean srcIsZk = src.toLowerCase(Locale.ROOT).startsWith("zk:");
        boolean dstIsZk = dst.toLowerCase(Locale.ROOT).startsWith("zk:");
        String srcName = src;
        if (srcIsZk) {
            srcName = src.substring(3);
        } else if (srcName.toLowerCase(Locale.ROOT).startsWith("file:")) {
            srcName = srcName.substring(5);
        }
        Object dstName = dst;
        if (dstIsZk) {
            dstName = dst.substring(3);
            if (!((String)dstName).startsWith("/")) {
                dstName = "/" + (String)dstName;
            }
        } else if (((String)dstName).toLowerCase(Locale.ROOT).startsWith("file:")) {
            dstName = ((String)dstName).substring(5);
        }
        int minStateByteLenForCompression = -1;
        ZLibCompressor compressor = new ZLibCompressor();
        if (dstIsZk) {
            String solrHome = cli.getOptionValue("solr-home");
            if (StrUtils.isNullOrEmpty((String)solrHome)) {
                solrHome = System.getProperty("solr.home");
            }
            if (solrHome != null) {
                this.echoIfVerbose("Using SolrHome: " + solrHome, cli);
                try {
                    Path solrHomePath = Paths.get(solrHome, new String[0]);
                    Properties props = new Properties();
                    props.put("zkHost", zkHost);
                    NodeConfig nodeConfig = NodeConfig.loadNodeConfig(solrHomePath, props);
                    minStateByteLenForCompression = nodeConfig.getCloudConfig().getMinStateByteLenForCompression();
                    String stateCompressorClass = nodeConfig.getCloudConfig().getStateCompressorClass();
                    if (StrUtils.isNotNullOrEmpty((String)stateCompressorClass)) {
                        Class<Compressor> compressionClass = Class.forName(stateCompressorClass).asSubclass(Compressor.class);
                        compressor = compressionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                catch (SolrException e) {
                    throw new IllegalStateException("Failed to load solr.xml, put/get operations on compressed data will use data as is. If your intention is to read and de-compress data or compress and write data, then solr.xml must be accessible.");
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException("Unable to find or instantiate compression class: " + e.getMessage());
                }
            }
        }
        if (minStateByteLenForCompression > -1) {
            this.echoIfVerbose("Compression of state.json has been enabled", cli);
        }
        try (SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(zkHost).withTimeout(SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT, TimeUnit.MILLISECONDS).withStateFileCompression(minStateByteLenForCompression, (Compressor)compressor).build();){
            zkClient.zkTransfer(srcName, Boolean.valueOf(srcIsZk), (String)dstName, Boolean.valueOf(dstIsZk), Boolean.valueOf(recursive));
        }
        catch (Exception e) {
            log.error("Could not complete the zk operation for reason: ", (Throwable)e);
            throw e;
        }
    }
}

