/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels.store;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.yarn.nodelabels.store.FSStoreOpHandler;
import org.apache.hadoop.yarn.nodelabels.store.op.FSNodeStoreLogOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFSNodeStore<M> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractFSNodeStore.class);
    private FSStoreOpHandler.StoreType storeType;
    private FSDataOutputStream editlogOs;
    private Path editLogPath;
    private int replication;
    private StoreSchema schema;
    protected M manager;
    protected Path fsWorkingPath;
    protected FileSystem fs;

    public AbstractFSNodeStore(FSStoreOpHandler.StoreType storeType) {
        this.storeType = storeType;
    }

    protected void initStore(Configuration conf, Path fsStorePath, StoreSchema schma, M mgr) throws IOException {
        this.schema = schma;
        this.fsWorkingPath = fsStorePath;
        this.manager = mgr;
        this.initFileSystem(conf);
        this.initNodeStoreRootDirectory(conf);
        this.replication = conf.getInt("yarn.fs-store.file.replication", 0);
    }

    private void initNodeStoreRootDirectory(Configuration conf) throws IOException {
        int maxRetries = conf.getInt("yarn.resourcemanager.nodestore-rootdir.num-retries", 1000);
        int retryCount = 0;
        boolean success = false;
        while (!success && retryCount <= maxRetries) {
            try {
                success = this.fs.mkdirs(this.fsWorkingPath);
            }
            catch (IOException e) {
                if (++retryCount > maxRetries) {
                    throw e;
                }
                try {
                    Thread.sleep(conf.getInt("yarn.resourcemanager.nodestore-rootdir.retry-interval-ms", 1000));
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
        }
        LOG.info("Created store directory :" + this.fsWorkingPath);
    }

    public void initFileSystem(Configuration conf) throws IOException {
        Configuration confCopy = new Configuration(conf);
        this.fs = this.fsWorkingPath.getFileSystem(confCopy);
        if (this.fs.getScheme().equals("file")) {
            this.fs = ((LocalFileSystem)this.fs).getRaw();
        }
    }

    protected void writeToLog(FSNodeStoreLogOp op) throws IOException {
        try {
            this.ensureAppendEditLogFile();
            this.editlogOs.writeInt(op.getOpCode());
            op.write(this.editlogOs, this.manager);
        }
        finally {
            this.ensureCloseEditlogFile();
        }
    }

    protected void ensureAppendEditLogFile() throws IOException {
        this.editlogOs = this.fs.append(this.editLogPath);
    }

    protected void ensureCloseEditlogFile() throws IOException {
        this.editlogOs.close();
    }

    protected void loadFromMirror(Path newMirrorPath, Path oldMirrorPath) throws IOException {
        Path mirrorToRead;
        Path path = this.fs.exists(newMirrorPath) ? newMirrorPath : (mirrorToRead = this.fs.exists(oldMirrorPath) ? oldMirrorPath : null);
        if (mirrorToRead != null) {
            try (FSDataInputStream is = this.fs.open(mirrorToRead);){
                FSNodeStoreLogOp op = FSStoreOpHandler.getMirrorOp(this.storeType);
                op.recover(is, this.manager);
            }
        }
    }

    protected FSStoreOpHandler.StoreType getStoreType() {
        return this.storeType;
    }

    public Path getFsWorkingPath() {
        return this.fsWorkingPath;
    }

    protected void recoverFromStore() throws IOException {
        Path mirrorPath = new Path(this.fsWorkingPath, this.schema.mirrorName);
        Path oldMirrorPath = new Path(this.fsWorkingPath, this.schema.mirrorName + ".old");
        this.loadFromMirror(mirrorPath, oldMirrorPath);
        this.editLogPath = new Path(this.fsWorkingPath, this.schema.editLogName);
        this.loadManagerFromEditLog(this.editLogPath);
        Path writingMirrorPath = new Path(this.fsWorkingPath, this.schema.mirrorName + ".writing");
        try (FSDataOutputStream os = this.fs.create(writingMirrorPath, true);){
            FSNodeStoreLogOp op = FSStoreOpHandler.getMirrorOp(this.storeType);
            op.write(os, this.manager);
        }
        this.checkAvailability(writingMirrorPath);
        if (this.fs.exists(mirrorPath)) {
            this.fs.delete(oldMirrorPath, false);
            this.fs.rename(mirrorPath, oldMirrorPath);
        }
        this.fs.rename(writingMirrorPath, mirrorPath);
        this.fs.delete(writingMirrorPath, false);
        this.fs.delete(oldMirrorPath, false);
        this.editlogOs = this.fs.create(this.editLogPath, true);
        this.editlogOs.close();
        this.checkAvailability(this.editLogPath);
        LOG.info("Finished write mirror at:" + mirrorPath.toString());
        LOG.info("Finished create editlog file at:" + this.editLogPath.toString());
    }

    private void checkAvailability(Path file) throws IOException {
        try {
            if (this.replication != 0 && this.fs.getFileStatus(file).getReplication() < this.replication) {
                this.fs.setReplication(file, (short)this.replication);
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.error("Failed set replication for a file : {}", (Object)file);
        }
    }

    protected void loadManagerFromEditLog(Path editPath) throws IOException {
        if (!this.fs.exists(editPath)) {
            return;
        }
        FSDataInputStream is = this.fs.open(editPath);
        Throwable throwable = null;
        try {
            try {
                while (true) {
                    FSNodeStoreLogOp storeOp = FSStoreOpHandler.get(is.readInt(), this.storeType);
                    storeOp.recover(is, this.manager);
                }
            }
            catch (EOFException e) {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        is.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public void setFs(FileSystem fs) {
        this.fs = fs;
    }

    protected void closeFSStore() {
        IOUtils.closeStreams(this.fs, this.editlogOs);
    }

    public static class StoreSchema {
        private String editLogName;
        private String mirrorName;

        public StoreSchema(String editLogName, String mirrorName) {
            this.editLogName = editLogName;
            this.mirrorName = mirrorName;
        }
    }
}

