/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.jdk8;

import java.util.OptionalDouble;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.ext.jdk8.BaseScalarOptionalDeserializer;
import tools.jackson.databind.type.LogicalType;

public class OptionalDoubleDeserializer
extends BaseScalarOptionalDeserializer<OptionalDouble> {
    static final OptionalDoubleDeserializer INSTANCE = new OptionalDoubleDeserializer();

    public OptionalDoubleDeserializer() {
        super(OptionalDouble.class, OptionalDouble.empty());
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Float;
    }

    @Override
    public OptionalDouble deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return OptionalDouble.of(p.getDoubleValue());
        }
        switch (p.currentTokenId()) {
            case 6: {
                String text = p.getString();
                Double specialValue = this._checkDoubleSpecialValue(text);
                if (specialValue != null) {
                    return OptionalDouble.of(specialValue);
                }
                CoercionAction act = this._checkFromStringCoercion(ctxt, text);
                if (act == CoercionAction.AsNull) {
                    return (OptionalDouble)this.getNullValue(ctxt);
                }
                if (act == CoercionAction.AsEmpty) {
                    return (OptionalDouble)this.getEmptyValue(ctxt);
                }
                if (this._checkTextualNull(ctxt, text = text.trim())) {
                    return (OptionalDouble)this._empty;
                }
                return OptionalDouble.of(this._parseDoublePrimitive(p, ctxt, text));
            }
            case 7: {
                return OptionalDouble.of(p.getDoubleValue());
            }
            case 11: {
                return (OptionalDouble)this._empty;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                OptionalDouble parsed = this.deserialize(p, ctxt);
                this._verifyEndArrayForSingle(p, ctxt);
                return parsed;
            }
        }
        return (OptionalDouble)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }
}

