/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.RegExpBuiltinsFactory;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TRegexUtil;

public final class RegExpBuiltins
extends JSBuiltinsContainer.SwitchEnum<RegExpBuiltin> {
    public static final JSBuiltinsContainer BUILTINS = new RegExpBuiltins();

    protected RegExpBuiltins() {
        super(JSRegExp.CLASS_NAME, RegExpBuiltin.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, RegExpBuiltin builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultGetInputNodeGen.create(context, builtin, RegExpBuiltins.args().createArgumentNodes(context));
            }
            case 1: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultSetInputNodeGen.create(context, builtin, RegExpBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultGetGroupNodeGen.create(context, builtin, 0, RegExpBuiltins.args().createArgumentNodes(context));
            }
            case 3: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultLastParenNodeGen.create(context, builtin, RegExpBuiltins.args().createArgumentNodes(context));
            }
            case 4: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultLeftContextNodeGen.create(context, builtin, RegExpBuiltins.args().createArgumentNodes(context));
            }
            case 5: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultRightContextNodeGen.create(context, builtin, RegExpBuiltins.args().createArgumentNodes(context));
            }
            case 6: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultMultilineNodeGen.create(context, builtin, RegExpBuiltins.args().createArgumentNodes(context));
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultGetGroupNodeGen.create(context, builtin, builtinEnum.name().charAt(1) - 48, RegExpBuiltins.args().createArgumentNodes(context));
            }
        }
        return null;
    }

    static void checkStaticRegexResultPropertyGet(JSContext context, JSRealm realm, Object thisValue) {
        CompilerAsserts.partialEvaluationConstant((Object)context);
        if (!context.isOptionV8CompatibilityMode() && (thisValue != realm.getRegExpConstructor() || realm.isRegexResultInvalidated())) {
            throw Errors.createTypeError("Static RegExp result properties cannot be used with subclasses of RegExp.");
        }
    }

    static void checkStaticRegexResultPropertySet(JSContext context, JSRealm realm, Object thisValue) {
        CompilerAsserts.partialEvaluationConstant((Object)context);
        if (!context.isOptionV8CompatibilityMode() && thisValue != realm.getRegExpConstructor()) {
            throw Errors.createTypeError("Static RegExp result properties cannot be used with subclasses of RegExp.");
        }
    }

    public static enum RegExpBuiltin implements BuiltinEnum<RegExpBuiltin>
    {
        input(0),
        set_input(1, Strings.INPUT),
        lastMatch(0),
        lastParen(0),
        leftContext(0),
        rightContext(0),
        multiline(0),
        $1(0),
        $2(0),
        $3(0),
        $4(0),
        $5(0),
        $6(0),
        $7(0),
        $8(0),
        $9(0);

        private final TruffleString key;
        private final int length;

        private RegExpBuiltin(int length) {
            this.key = Strings.fromJavaString(this.name());
            this.length = length;
        }

        private RegExpBuiltin(int length, TruffleString key) {
            this.key = key;
            this.length = length;
        }

        public TruffleString getKey() {
            return this.key;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return this.getLength() == 0;
        }

        @Override
        public boolean isSetter() {
            return this.getLength() == 1;
        }
    }

    static abstract class JSRegExpStaticResultGetInputNode
    extends JSBuiltinNode {
        JSRegExpStaticResultGetInputNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        TruffleString getInputProp(VirtualFrame frame) {
            RegExpBuiltins.checkStaticRegexResultPropertyGet(this.getContext(), this.getRealm(), JSFrameUtil.getThisObj((Frame)frame));
            return this.getRealm().getStaticRegexResultInputString();
        }
    }

    static abstract class JSRegExpStaticResultSetInputNode
    extends JSBuiltinNode {
        @Node.Child
        private JSToStringNode toStringNode = JSToStringNode.create();

        JSRegExpStaticResultSetInputNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        Object setInputProp(VirtualFrame frame, Object val) {
            RegExpBuiltins.checkStaticRegexResultPropertySet(this.getContext(), this.getRealm(), JSFrameUtil.getThisObj((Frame)frame));
            this.getRealm().setStaticRegexResultInputString(this.toStringNode.executeString(val));
            return Undefined.instance;
        }
    }

    static abstract class JSRegExpStaticResultGetGroupNode
    extends JSRegExpStaticResultPropertyNode {
        private final int groupNumber;

        JSRegExpStaticResultGetGroupNode(JSContext context, JSBuiltin builtin, int groupNumber) {
            super(context, builtin);
            assert (groupNumber >= 0);
            this.groupNumber = groupNumber;
        }

        @Specialization
        TruffleString getGroup(VirtualFrame frame, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached TRegexUtil.InteropReadIntMemberNode readGroupCount, @Cached TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached GetStaticRegExpResultNode getResultNode) {
            int start;
            JSRealm realm = this.getRealm();
            RegExpBuiltins.checkStaticRegexResultPropertyGet(this.getContext(), realm, JSFrameUtil.getThisObj((Frame)frame));
            Object result = getResultNode.execute(this);
            if (this.isMatchResult(result, readIsMatch) && this.groupCount(realm.getStaticRegexResultCompiledRegex(), readGroupCount) > this.groupNumber && (start = this.captureGroupStart(result, this.groupNumber, getStart)) >= 0) {
                return Strings.substring(this.getContext(), substringNode, this.getInput(), start, this.captureGroupEnd(result, this.groupNumber, getEnd) - start);
            }
            return Strings.EMPTY_STRING;
        }
    }

    static abstract class JSRegExpStaticResultLastParenNode
    extends JSRegExpStaticResultPropertyNode {
        JSRegExpStaticResultLastParenNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        TruffleString lastParen(VirtualFrame frame, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached TRegexUtil.InteropReadIntMemberNode readGroupCount, @Cached TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached GetStaticRegExpResultNode getResultNode) {
            int start;
            int groupNumber;
            JSRealm realm = this.getRealm();
            RegExpBuiltins.checkStaticRegexResultPropertyGet(this.getContext(), realm, JSFrameUtil.getThisObj((Frame)frame));
            Object result = getResultNode.execute(this);
            if (this.isMatchResult(result, readIsMatch) && (groupNumber = this.groupCount(realm.getStaticRegexResultCompiledRegex(), readGroupCount) - 1) > 0 && (start = this.captureGroupStart(result, groupNumber, getStart)) >= 0) {
                return Strings.substring(this.getContext(), substringNode, this.getInput(), start, this.captureGroupEnd(result, groupNumber, getEnd) - start);
            }
            return Strings.EMPTY_STRING;
        }
    }

    static abstract class JSRegExpStaticResultLeftContextNode
    extends JSRegExpStaticResultPropertyNode {
        JSRegExpStaticResultLeftContextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        TruffleString leftContext(VirtualFrame frame, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached GetStaticRegExpResultNode getResultNode) {
            RegExpBuiltins.checkStaticRegexResultPropertyGet(this.getContext(), this.getRealm(), JSFrameUtil.getThisObj((Frame)frame));
            Object result = getResultNode.execute(this);
            if (this.isMatchResult(result, readIsMatch)) {
                int start = this.captureGroupStart(result, 0, getStart);
                return Strings.substring(this.getContext(), substringNode, this.getInput(), 0, start);
            }
            return Strings.EMPTY_STRING;
        }
    }

    static abstract class JSRegExpStaticResultRightContextNode
    extends JSRegExpStaticResultPropertyNode {
        JSRegExpStaticResultRightContextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        TruffleString rightContext(VirtualFrame frame, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached GetStaticRegExpResultNode getResultNode) {
            RegExpBuiltins.checkStaticRegexResultPropertyGet(this.getContext(), this.getRealm(), JSFrameUtil.getThisObj((Frame)frame));
            Object result = getResultNode.execute(this);
            if (this.isMatchResult(result, readIsMatch)) {
                int end = this.captureGroupEnd(result, 0, getEnd);
                return Strings.substring(this.getContext(), substringNode, this.getInput(), end);
            }
            return Strings.EMPTY_STRING;
        }
    }

    static abstract class JSRegExpStaticResultMultilineNode
    extends JSBuiltinNode {
        JSRegExpStaticResultMultilineNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"getContext().isOptionNashornCompatibilityMode()"})
        static boolean getMultilineNashorn() {
            return false;
        }

        @Specialization(guards={"!getContext().isOptionNashornCompatibilityMode()"}, assumptions={"getContext().getRegExpStaticResultUnusedAssumption()"})
        boolean getMultilineLazy(@Bind Node node, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached @Cached.Shared TRegexUtil.TRegexCompiledRegexSingleFlagAccessorNode getMultilineFlag) {
            Object compiledRegex = this.getRealm().getStaticRegexResultCompiledRegex();
            if (compiledRegex != null) {
                return getMultilineFlag.execute(node, compiledRegex, "multiline");
            }
            return false;
        }

        @Specialization(guards={"!getContext().isOptionNashornCompatibilityMode()"})
        boolean getMultilineEager(@Bind Node node, @Cached GetStaticRegExpResultNode getResultNode, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached @Cached.Shared TRegexUtil.TRegexCompiledRegexSingleFlagAccessorNode getMultilineFlag) {
            Object compiledRegex = this.getRealm().getStaticRegexResultCompiledRegex();
            Object result = getResultNode.execute(node);
            if (TRegexUtil.TRegexResultAccessor.isMatch(result, node, readIsMatch)) {
                return getMultilineFlag.execute(node, compiledRegex, "multiline");
            }
            return false;
        }
    }

    static abstract class JSRegExpStaticResultPropertyNode
    extends JSBuiltinNode {
        JSRegExpStaticResultPropertyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected final TruffleString getInput() {
            return this.getRealm().getStaticRegexResultOriginalInputString();
        }

        protected final boolean isMatchResult(Object result, TRegexUtil.InteropReadBooleanMemberNode readIsMatch) {
            return TRegexUtil.TRegexResultAccessor.isMatch(result, this, readIsMatch);
        }

        protected final int groupCount(Object compiledRegex, TRegexUtil.InteropReadIntMemberNode readGroupCount) {
            return TRegexUtil.TRegexCompiledRegexAccessor.groupCount(compiledRegex, this, readGroupCount);
        }

        protected final int captureGroupStart(Object result, int groupNumber, TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart) {
            return TRegexUtil.TRegexResultAccessor.captureGroupStart(result, groupNumber, this, getStart);
        }

        protected final int captureGroupEnd(Object result, int groupNumber, TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd) {
            return TRegexUtil.TRegexResultAccessor.captureGroupEnd(result, groupNumber, this, getEnd);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetStaticRegExpResultNode
    extends JavaScriptBaseNode {
        GetStaticRegExpResultNode() {
        }

        abstract Object execute(Node var1);

        @Specialization
        static Object get(Node node, @Cached TRegexUtil.InvokeExecMethodNode invokeExec) {
            return JSRealm.get(node).getStaticRegexResult(JavaScriptLanguage.get(node).getJSContext(), node, invokeExec);
        }
    }
}

