/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.db;

import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.XmlFileHelper;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.xml.DOMUtil;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementAttributes;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SqlStatementKey {
    public final String sqlStr_;
    public final int resultSetType_;
    public final int resultSetConcurrency_;
    public final int resultSetHoldability_;
    public final String[] autoGenKeyColNames_;
    public final int[] autoGenKeyColIndexes_;
    public final int autoGenKeyIndicator_;
    public final boolean setMaxRowsFound_;
    private int keyHashCode_;
    public final String referencedQuery_;
    private static final int PRIME = 31;
    private boolean matchingSqlStr_ = false;
    private boolean matchingResultSetType_ = true;
    private boolean matchingResultSetConcurrency_ = true;
    private boolean matchingResultSetHoldability_ = true;
    private boolean matchingAutoGenKeyColNames_ = true;
    private boolean matchingAutoGenKeyColIndexes_ = true;
    private boolean matchingAutoGenKeyIndicator_ = true;
    private boolean matchingSetMaxRowsIndicator_ = true;
    private int ordinalPosition_ = -1;

    private SqlStatementKey(String string, int n2, int n3, int n4, String[] stringArray, int[] nArray, int n5, String string2, boolean bl2) {
        this.sqlStr_ = string.trim().intern();
        this.resultSetType_ = n2;
        this.resultSetConcurrency_ = n3;
        this.resultSetHoldability_ = n4;
        this.autoGenKeyColNames_ = stringArray;
        this.autoGenKeyColIndexes_ = nArray;
        this.autoGenKeyIndicator_ = n5;
        this.referencedQuery_ = string2;
        this.setMaxRowsFound_ = bl2;
    }

    public static SqlStatementKey generateStmtKey(String string, int n2, int n3, int n4, String[] stringArray, int[] nArray, int n5, boolean bl2) {
        return new SqlStatementKey(string, n2, n3, n4, stringArray, nArray, n5, null, bl2);
    }

    public static SqlStatementKey generateStmtKey(Element element) {
        int n2;
        int n3;
        NodeList nodeList;
        String string = null;
        String string2 = null;
        int n4 = 1003;
        int n5 = 1007;
        int n6 = 1;
        String[] stringArray = null;
        int[] nArray = null;
        int n7 = 0;
        boolean bl2 = false;
        String string3 = null;
        Element element2 = DOMUtil.getFirstChildByName(element, "statementDescriptor");
        Element element3 = DOMUtil.getFirstChildByName(element2, "statementAttributes");
        Element element4 = DOMUtil.getFirstChildByName(element2, "autoGeneratedColumnNames");
        Element element5 = DOMUtil.getFirstChildByName(element2, "autoGeneratedColumnIndexes");
        Element element6 = DOMUtil.getFirstChildByName(element2, "autoGeneratedcolumnIndicator");
        string = DOMUtil.getFirstValueByName(element2, "prepareSql");
        if (XmlFileHelper.isAttributeSet(element3, "referencedQuery")) {
            string2 = element3.getAttribute("referencedQuery");
        }
        if (null != element3) {
            if (element3.hasAttribute("resultSetType")) {
                n4 = XmlTags.getCursorTypeNumber(element3.getAttribute("resultSetType"));
            }
            if (element3.hasAttribute("resultSetConcurrency")) {
                n5 = XmlTags.getConcurrencyNumber(element3.getAttribute("resultSetConcurrency"));
            }
            if (element3.hasAttribute("resultSetHoldability")) {
                n6 = XmlTags.getHoldabilityNumber(element3.getAttribute("resultSetHoldability"), 1);
            }
            if (element3.hasAttribute("maxRows") || element3.hasAttribute("incrementalMaxRows")) {
                bl2 = true;
            }
        }
        if (element4 != null && element4.hasChildNodes() && (nodeList = element4.getElementsByTagName("columnName")) != null && 0 < (n3 = nodeList.getLength())) {
            stringArray = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[n2] = nodeList.item(n2).getTextContent();
            }
        }
        if (element5 != null && element5.hasChildNodes() && null != (nodeList = element5.getElementsByTagName("columnIndex")) && 0 < (n3 = nodeList.getLength())) {
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = Integer.parseInt(nodeList.item(n2).getTextContent());
            }
        }
        if (element6 != null && XmlFileHelper.isAttributeSet(string3 = element6.getTextContent())) {
            n7 = StaticProfileCaptureHelper.getAutoGenColIndicator(string3);
        }
        return new SqlStatementKey(string, n4, n5, n6, stringArray, nArray, n7, string2, bl2);
    }

    public SqlStatementKey getSqlStatementKeyWithSQLCursorNameReplacedByReferencedQueryValueReadFromXML() {
        return this.getSqlStatementKeyWithSQLCursorNameReplacedByReferencedQueryValue(this.referencedQuery_);
    }

    public SqlStatementKey getSqlStatementKeyWithSQLCursorNameReplacedByReferencedQueryValue(String string) {
        String[] stringArray;
        if (null != string && StaticProfileConstants.isValueSet(string) && (stringArray = ConnectionExecutionHandler.replacePosUpdateCursorName(this.sqlStr_, string)) != null && null != stringArray[0] && !stringArray[0].equals(this.sqlStr_)) {
            return new SqlStatementKey(stringArray[0], this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, this.referencedQuery_, this.setMaxRowsFound_);
        }
        return this;
    }

    public static SqlStatementKey generateStmtKey(PDQXmlStatementDescriptor pDQXmlStatementDescriptor) {
        PDQXmlStatementAttributes pDQXmlStatementAttributes = pDQXmlStatementDescriptor.getStatementAttributes();
        return new SqlStatementKey(pDQXmlStatementDescriptor.getSql(), pDQXmlStatementAttributes.getType(), pDQXmlStatementAttributes.getConcurrency(), pDQXmlStatementAttributes.getHoldability(), pDQXmlStatementDescriptor.getAutogenColumnNames(), pDQXmlStatementDescriptor.getAutogenColumnIndexes(), pDQXmlStatementDescriptor.getAutogenColumnIndicator(), null, false);
    }

    private static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i10 = 0; i10 < nArray.length; ++i10) {
            n2 = 31 * n2 + nArray[i10];
        }
        return n2;
    }

    private static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i10 = 0; i10 < objectArray.length; ++i10) {
            n2 = 31 * n2 + (objectArray[i10] == null ? 0 : objectArray[i10].hashCode());
        }
        return n2;
    }

    public int hashCode() {
        if (this.keyHashCode_ != 0) {
            return this.keyHashCode_;
        }
        int n2 = 1;
        n2 = 31 * n2 + SqlStatementKey.hashCode(this.autoGenKeyColIndexes_);
        n2 = 31 * n2 + SqlStatementKey.hashCode(this.autoGenKeyColNames_);
        n2 = 31 * n2 + this.autoGenKeyIndicator_;
        n2 = 31 * n2 + this.resultSetConcurrency_;
        n2 = 31 * n2 + this.resultSetHoldability_;
        n2 = 31 * n2 + this.resultSetType_;
        n2 = 31 * n2 + (this.sqlStr_ == null ? 0 : this.sqlStr_.hashCode());
        if (this.setMaxRowsFound_) {
            n2 = 31 * n2 + 1231;
        }
        this.keyHashCode_ = n2;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SqlStatementKey sqlStatementKey = (SqlStatementKey)object;
        if (!Arrays.equals(this.autoGenKeyColIndexes_, sqlStatementKey.autoGenKeyColIndexes_)) {
            return false;
        }
        if (!Arrays.equals(this.autoGenKeyColNames_, sqlStatementKey.autoGenKeyColNames_)) {
            return false;
        }
        if (this.autoGenKeyIndicator_ != sqlStatementKey.autoGenKeyIndicator_) {
            return false;
        }
        if (this.resultSetConcurrency_ != sqlStatementKey.resultSetConcurrency_) {
            return false;
        }
        if (this.resultSetHoldability_ != sqlStatementKey.resultSetHoldability_) {
            return false;
        }
        if (this.resultSetType_ != sqlStatementKey.resultSetType_) {
            return false;
        }
        if (this.setMaxRowsFound_ != sqlStatementKey.setMaxRowsFound_) {
            return false;
        }
        return !(this.sqlStr_ == null ? sqlStatementKey.sqlStr_ != null : this.sqlStr_ != sqlStatementKey.sqlStr_);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.hashCode());
        stringBuilder.append("@");
        stringBuilder.append(this.resultSetType_);
        stringBuilder.append(this.resultSetConcurrency_);
        stringBuilder.append(this.resultSetHoldability_);
        stringBuilder.append(this.autoGenKeyIndicator_);
        if (null != this.autoGenKeyColIndexes_) {
            stringBuilder.append(Arrays.toString(this.autoGenKeyColIndexes_));
        }
        if (null != this.autoGenKeyColNames_) {
            stringBuilder.append(Arrays.toString(this.autoGenKeyColNames_));
        }
        if (this.setMaxRowsFound_) {
            stringBuilder.append("#");
            stringBuilder.append(this.setMaxRowsFound_);
        }
        return stringBuilder.toString().intern();
    }

    public boolean areAutoGenKeysRequested() {
        return StaticProfileConstants.areAutoGeneratedKeysRequested(this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_);
    }

    public boolean isAutoGeneratedKeysJDBCMethodUsed() {
        return StaticProfileConstants.isAutoGeneratedKeysJDBCMethodUsed(this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_);
    }

    public boolean isMatchingSqlStr(Set<SqlStatementKey> set) {
        for (SqlStatementKey sqlStatementKey : set) {
            if (this.sqlStr_ != sqlStatementKey.sqlStr_) continue;
            this.matchingSqlStr_ = true;
            if (this.resultSetType_ != sqlStatementKey.resultSetType_) {
                this.matchingResultSetType_ = false;
            }
            if (this.resultSetConcurrency_ != sqlStatementKey.resultSetConcurrency_) {
                this.matchingResultSetConcurrency_ = false;
            }
            if (this.resultSetHoldability_ != sqlStatementKey.resultSetHoldability_) {
                this.matchingResultSetHoldability_ = false;
            }
            if (this.matchingAutoGenKeyColNames_ && !Arrays.equals(this.autoGenKeyColNames_, sqlStatementKey.autoGenKeyColNames_)) {
                this.matchingAutoGenKeyColNames_ = false;
            }
            if (this.matchingAutoGenKeyColIndexes_ && !Arrays.equals(this.autoGenKeyColIndexes_, sqlStatementKey.autoGenKeyColIndexes_)) {
                this.matchingAutoGenKeyColIndexes_ = false;
            }
            if (this.autoGenKeyIndicator_ != sqlStatementKey.autoGenKeyIndicator_) {
                this.matchingAutoGenKeyIndicator_ = false;
            }
            if (this.setMaxRowsFound_ == sqlStatementKey.setMaxRowsFound_) continue;
            this.matchingSetMaxRowsIndicator_ = false;
        }
        return this.matchingSqlStr_;
    }

    public String reportWhyStatementNotFound() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.matchingResultSetType_) {
            stringBuilder.append(", ResultSet Type");
        }
        if (!this.matchingResultSetConcurrency_) {
            stringBuilder.append(", ResultSet Concurrency");
        }
        if (!this.matchingResultSetHoldability_) {
            stringBuilder.append(", ResutlSet Holdability");
        }
        if (!this.matchingAutoGenKeyColNames_) {
            stringBuilder.append(", AutoGenerated Column Names");
        }
        if (!this.matchingAutoGenKeyColIndexes_) {
            stringBuilder.append(", AutoGenerated Column Indexes");
        }
        if (!this.matchingAutoGenKeyIndicator_) {
            stringBuilder.append(", AutoGenerated Key Indicator");
        }
        if (!this.matchingSetMaxRowsIndicator_) {
            stringBuilder.append(", SetMaxRowsIndicator");
        }
        stringBuilder.delete(0, 2);
        return stringBuilder.toString();
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition_;
    }

    public void setOrdinalPosition(int n2) {
        this.ordinalPosition_ = n2;
    }

    public String getStatementAttributesFormatted(boolean bl2, String string, SqlStatementKey sqlStatementKey) {
        String string2;
        boolean bl3;
        String string3;
        String string4;
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = string4 = bl2 ? XmlTags.CRLF + string : "; ";
        if (null == sqlStatementKey || sqlStatementKey.resultSetType_ != this.resultSetType_) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(string4);
            }
            string3 = XmlTags.getCursorTypeName(this.resultSetType_);
            this.appendStatementAttribute(stringBuilder, "resultSetType", string3);
        }
        if (null == sqlStatementKey || sqlStatementKey.resultSetConcurrency_ != this.resultSetConcurrency_) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(string4);
            }
            string3 = XmlTags.getConcurrencyName(this.resultSetConcurrency_);
            this.appendStatementAttribute(stringBuilder, "resultSetConcurrency", string3);
        }
        if (null == sqlStatementKey || sqlStatementKey.resultSetHoldability_ != this.resultSetHoldability_) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(string4);
            }
            string3 = XmlTags.getHoldabilityName(this.resultSetHoldability_);
            this.appendStatementAttribute(stringBuilder, "resultSetHoldability", string3);
        }
        if (!(bl3 = 0 == this.autoGenKeyIndicator_ || 1 == this.autoGenKeyIndicator_ || 2 == this.autoGenKeyIndicator_ ? null == this.autoGenKeyColIndexes_ && null == this.autoGenKeyColNames_ : (-1 == this.autoGenKeyIndicator_ ? null != this.autoGenKeyColNames_ && null == this.autoGenKeyColNames_ || null == this.autoGenKeyColNames_ && null != this.autoGenKeyColNames_ : false)) || null != this.autoGenKeyColNames_ && (null == sqlStatementKey || !Arrays.equals(sqlStatementKey.autoGenKeyColNames_, this.autoGenKeyColNames_))) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(string4);
            }
            string2 = "columnNames";
            this.appendStatementAttribute(stringBuilder, string2, Arrays.toString(this.autoGenKeyColNames_));
        }
        if (!bl3 || null != this.autoGenKeyColIndexes_ && (null == sqlStatementKey || !Arrays.equals(sqlStatementKey.autoGenKeyColIndexes_, this.autoGenKeyColIndexes_))) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(string4);
            }
            string2 = "columnIndexes";
            this.appendStatementAttribute(stringBuilder, string2, Arrays.toString(this.autoGenKeyColIndexes_));
        }
        if (!bl3 || -1 != this.autoGenKeyIndicator_ && (null == sqlStatementKey || sqlStatementKey.autoGenKeyIndicator_ != this.autoGenKeyIndicator_)) {
            String string6;
            if (0 < stringBuilder.length()) {
                stringBuilder.append(string4);
            }
            if (0 == this.autoGenKeyIndicator_) {
                string2 = Messages.getText("MSG_STATEMENT_ATTRIBUTE_NO_AGKS", new Object[0]);
                string6 = null;
            } else {
                string2 = "autoGeneratedKeys";
                string6 = 1 == this.autoGenKeyIndicator_ ? Statement.class.getCanonicalName() + ".RETURN_GENERATED_KEYS" : (2 == this.autoGenKeyIndicator_ ? Statement.class.getCanonicalName() + ".NO_GENERATED_KEYS" : Integer.toString(this.autoGenKeyIndicator_));
            }
            this.appendStatementAttribute(stringBuilder, string2, string6);
        }
        if (0 < stringBuilder.length()) {
            if (bl2) {
                stringBuilder.insert(0, string);
            } else {
                stringBuilder.insert(0, '[');
                stringBuilder.append(']');
            }
        }
        return stringBuilder.toString();
    }

    private void appendStatementAttribute(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string);
        if (null != string2) {
            stringBuilder.append('=').append(string2);
        }
    }
}

