/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.lib.PyLongFromDoubleNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;

@GeneratedBy(value=PyLongFromDoubleNode.class)
public final class PyLongFromDoubleNodeGen {
    private static final Uncached UNCACHED = new Uncached();

    @CompilerDirectives.TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException2LD(Node thisNode_, Object arg0Value, double arg1Value) {
        return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value});
    }

    @NeverDefault
    public static PyLongFromDoubleNode getUncached() {
        return UNCACHED;
    }

    @NeverDefault
    public static PyLongFromDoubleNode inline(@InlineSupport.RequiredField(bits=5, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
        return new Inlined(target);
    }

    @GeneratedBy(value=PyLongFromDoubleNode.class)
    @DenyReplace
    private static final class Uncached
    extends PyLongFromDoubleNode
    implements UnadoptableNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(Node arg0Value, double arg1Value) {
            if (MathGuards.fitInt(arg1Value)) {
                return PyLongFromDoubleNode.doInt(arg1Value);
            }
            if (MathGuards.fitLong(arg1Value)) {
                return PyLongFromDoubleNode.doLong(arg1Value);
            }
            if (!MathGuards.fitLong(arg1Value) && PyLongFromDoubleNode.isFinite(arg1Value)) {
                return PyLongFromDoubleNode.doFinite(arg1Value, PythonLanguage.get(this));
            }
            if (!PyLongFromDoubleNode.isFinite(arg1Value)) {
                return PyLongFromDoubleNode.doInfinite(arg0Value, arg1Value, PRaiseNode.getUncached());
            }
            throw PyLongFromDoubleNodeGen.newUnsupportedSpecializationException2LD(this, arg0Value, arg1Value);
        }
    }

    @GeneratedBy(value=PyLongFromDoubleNode.class)
    @DenyReplace
    private static final class Inlined
    extends PyLongFromDoubleNode
    implements UnadoptableNode {
        private final InlineSupport.StateField state_0_;
        private final PRaiseNode infinite_raiseNode_;

        private Inlined(InlineSupport.InlineTarget target) {
            assert (target.getTargetClass().isAssignableFrom(PyLongFromDoubleNode.class));
            this.state_0_ = target.getState(0, 5);
            this.infinite_raiseNode_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(4, 1)}));
        }

        @Override
        public Object execute(Node arg0Value, double arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0xF) != 0) {
                if ((state_0 & 1) != 0 && MathGuards.fitInt(arg1Value)) {
                    return PyLongFromDoubleNode.doInt(arg1Value);
                }
                if ((state_0 & 2) != 0 && MathGuards.fitLong(arg1Value)) {
                    return PyLongFromDoubleNode.doLong(arg1Value);
                }
                if ((state_0 & 4) != 0 && !MathGuards.fitLong(arg1Value) && PyLongFromDoubleNode.isFinite(arg1Value)) {
                    PythonLanguage language__ = PythonLanguage.get(arg0Value);
                    return PyLongFromDoubleNode.doFinite(arg1Value, language__);
                }
                if ((state_0 & 8) != 0 && !PyLongFromDoubleNode.isFinite(arg1Value)) {
                    assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_));
                    return PyLongFromDoubleNode.doInfinite(arg0Value, arg1Value, this.infinite_raiseNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Node arg0Value, double arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (MathGuards.fitInt(arg1Value)) {
                this.state_0_.set(arg0Value, state_0 |= 1);
                return PyLongFromDoubleNode.doInt(arg1Value);
            }
            if (MathGuards.fitLong(arg1Value)) {
                this.state_0_.set(arg0Value, state_0 |= 2);
                return PyLongFromDoubleNode.doLong(arg1Value);
            }
            PythonLanguage language__ = null;
            if (!MathGuards.fitLong(arg1Value) && PyLongFromDoubleNode.isFinite(arg1Value)) {
                language__ = PythonLanguage.get(arg0Value);
                this.state_0_.set(arg0Value, state_0 |= 4);
                return PyLongFromDoubleNode.doFinite(arg1Value, language__);
            }
            if (!PyLongFromDoubleNode.isFinite(arg1Value)) {
                this.state_0_.set(arg0Value, state_0 |= 8);
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_));
                return PyLongFromDoubleNode.doInfinite(arg0Value, arg1Value, this.infinite_raiseNode_);
            }
            throw PyLongFromDoubleNodeGen.newUnsupportedSpecializationException2LD(this, arg0Value, arg1Value);
        }
    }
}

