/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.pickle;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.pickle.MemoTable;
import com.oracle.graal.python.builtins.modules.pickle.PPickler;
import com.oracle.graal.python.builtins.modules.pickle.PPicklerMemoProxy;
import com.oracle.graal.python.builtins.modules.pickle.PicklerMemoProxyBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.pickle.PicklerMemoProxyBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.LinkedHashMap;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PicklerMemoProxy})
public class PicklerMemoProxyBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = PicklerMemoProxyBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PicklerMemoProxyBuiltinsFactory.getFactories();
    }

    @CompilerDirectives.TruffleBoundary
    public static PDict picklerMemoCopyImpl(MemoTable memoTable) {
        PythonLanguage language = PythonLanguage.get(null);
        LinkedHashMap<Object, Object> copy = new LinkedHashMap<Object, Object>();
        MemoTable.MemoIterator iterator = memoTable.iterator();
        while (iterator.advance()) {
            copy.put(System.identityHashCode(iterator.key()), PFactory.createTuple(language, new Object[]{iterator.value(), iterator.key()}));
        }
        return PFactory.createDictFromMapGeneric(language, copy);
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PicklerMemoProxyReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PPicklerMemoProxy self, @Bind PythonLanguage language) {
            MemoTable memoTable = self.getPickler().getMemo();
            PDict dictMemoCopy = PicklerMemoProxyBuiltins.picklerMemoCopyImpl(memoTable);
            PTuple dictArgs = PFactory.createTuple(language, new Object[]{dictMemoCopy});
            return PFactory.createTuple(language, new Object[]{PythonBuiltinClassType.PDict, dictArgs});
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PicklerMemoProxyCopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object copy(PPicklerMemoProxy self) {
            MemoTable memoTable = self.getPickler().getMemo();
            return PicklerMemoProxyBuiltins.picklerMemoCopyImpl(memoTable);
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PicklerMemoProxyClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object clear(PPicklerMemoProxy self) {
            MemoTable memoTable = self.getPickler().getMemo();
            memoTable.clear();
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="PicklerMemoProxy", minNumOfPositionalArgs=2, parameterNames={"$cls", "pickler"})
    @GenerateNodeFactory
    static abstract class ConstructPicklerMemoProxyNode
    extends PythonBinaryBuiltinNode {
        ConstructPicklerMemoProxyNode() {
        }

        @Specialization
        PPicklerMemoProxy construct(Object cls, PPickler pickler, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createPicklerMemoProxy(language, pickler, cls, getInstanceShape.execute(cls));
        }
    }
}

