/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import us.fatehi.utility.DriverManagerLogWriter;

public final class LoggingConfig {
    public LoggingConfig() {
        this(null);
    }

    public LoggingConfig(Level level) {
        this.applyApplicationLogLevel(level);
    }

    private void applyApplicationLogLevel(Level applicationLogLevel) {
        Level logLevel = applicationLogLevel == null ? Level.OFF : applicationLogLevel;
        LogManager logManager = LogManager.getLogManager();
        ArrayList<String> loggerNames = Collections.list(logManager.getLoggerNames());
        for (String loggerName : loggerNames) {
            Logger logger = logManager.getLogger(loggerName);
            if (logger == null) continue;
            logger.setLevel(null);
            for (Handler handler : logger.getHandlers()) {
                try {
                    handler.setEncoding("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                try {
                    handler.setLevel(logLevel);
                    if (logLevel != Level.OFF) continue;
                    logger.removeHandler(handler);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(logLevel);
        this.applySlf4jLogLevel(logLevel);
        this.applyPicocliLogLevel(logLevel);
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
        System.setProperty("polyglotimpl.AttachLibraryFailureAction", "ignore");
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        DriverManager.setLogWriter(new PrintWriter(new DriverManagerLogWriter()));
    }

    private void applyPicocliLogLevel(Level logLevel) {
        String logLevelName;
        if (logLevel == null || System.getProperty("picocli.trace") == null) {
            return;
        }
        System.setProperty("picocli.trace", switch (logLevelName = logLevel.getName()) {
            case "OFF" -> "OFF";
            case "SEVERE", "WARNING" -> "WARN";
            case "CONFIG", "INFO" -> "INFO";
            default -> "DEBUG";
        });
    }

    private void applySlf4jLogLevel(Level logLevel) {
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", switch (logLevel.getName()) {
            case "OFF" -> "off";
            case "SEVERE" -> "error";
            case "WARNING" -> "warn";
            case "CONFIG" -> "debug";
            case "INFO" -> "info";
            default -> "trace";
        });
    }
}

