/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.DictionaryLayer;
import com.intellij.spellchecker.statistics.SpellcheckerRateTracker;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u001a\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0007J \u0010\"\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020!2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u001a\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/spellchecker/statistics/SpellcheckerActionStatistics;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "DOMAIN_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "DICTIONARY_LAYER_FIELD", "SUGGESTION_INDEX_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "TOTAL_SUGGESTIONS_FIELD", "removeFromAcceptedWords", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "addToAcceptedWords", "suggestionShownEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "changeToInvokedEvent", "renameToInvokedEvent", "saveToInvokedEvent", "removeWordFromAcceptedWords", "", "project", "Lcom/intellij/openapi/project/Project;", "addWordToAcceptedWords", "saveToPerformed", "tracker", "Lcom/intellij/spellchecker/statistics/SpellcheckerRateTracker;", "dictionaryLayer", "Lcom/intellij/spellchecker/DictionaryLayer;", "renameToPerformed", "total", "", "changeToPerformed", "index", "suggestionShown", "buildCommonEvents", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nSpellcheckerActionStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellcheckerActionStatistics.kt\ncom/intellij/spellchecker/statistics/SpellcheckerActionStatistics\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class SpellcheckerActionStatistics
extends CounterUsagesCollector {
    @NotNull
    public static final SpellcheckerActionStatistics INSTANCE = new SpellcheckerActionStatistics();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("spellchecker.events", 4, null, 4, null);
    @NotNull
    private static final StringEventField DOMAIN_FIELD;
    @NotNull
    private static final StringEventField DICTIONARY_LAYER_FIELD;
    @NotNull
    private static final IntEventField SUGGESTION_INDEX_FIELD;
    @NotNull
    private static final IntEventField TOTAL_SUGGESTIONS_FIELD;
    @NotNull
    private static final EventId removeFromAcceptedWords;
    @NotNull
    private static final EventId addToAcceptedWords;
    @NotNull
    private static final VarargEventId suggestionShownEvent;
    @NotNull
    private static final VarargEventId changeToInvokedEvent;
    @NotNull
    private static final VarargEventId renameToInvokedEvent;
    @NotNull
    private static final VarargEventId saveToInvokedEvent;

    private SpellcheckerActionStatistics() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    public static final void removeWordFromAcceptedWords(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        removeFromAcceptedWords.log(project);
    }

    @JvmStatic
    public static final void addWordToAcceptedWords(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        addToAcceptedWords.log(project);
    }

    @JvmStatic
    public static final void saveToPerformed(@NotNull SpellcheckerRateTracker tracker, @Nullable DictionaryLayer dictionaryLayer) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        List<EventPair<?>> events = INSTANCE.buildCommonEvents(tracker);
        DictionaryLayer dictionaryLayer2 = dictionaryLayer;
        if (dictionaryLayer2 != null) {
            DictionaryLayer it = dictionaryLayer2;
            boolean bl = false;
            events.add(DICTIONARY_LAYER_FIELD.with((Object)it.getName()));
        }
        saveToInvokedEvent.log(tracker.getProject(), events);
    }

    @JvmStatic
    public static final void renameToPerformed(@NotNull SpellcheckerRateTracker tracker, int total) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        List<EventPair<?>> events = INSTANCE.buildCommonEvents(tracker);
        events.add(TOTAL_SUGGESTIONS_FIELD.with((Object)total));
        renameToInvokedEvent.log(tracker.getProject(), INSTANCE.buildCommonEvents(tracker));
    }

    @JvmStatic
    public static final void changeToPerformed(@NotNull SpellcheckerRateTracker tracker, int index, int total) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        List<EventPair<?>> events = INSTANCE.buildCommonEvents(tracker);
        events.add(SUGGESTION_INDEX_FIELD.with((Object)index));
        events.add(TOTAL_SUGGESTIONS_FIELD.with((Object)total));
        changeToInvokedEvent.log(tracker.getProject(), events);
    }

    @JvmStatic
    public static final void suggestionShown(@NotNull SpellcheckerRateTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        suggestionShownEvent.log(tracker.getProject(), INSTANCE.buildCommonEvents(tracker));
    }

    private final List<EventPair<?>> buildCommonEvents(SpellcheckerRateTracker tracker) {
        List events = new ArrayList();
        events.add(DOMAIN_FIELD.with((Object)tracker.getDomain()));
        events.add(EventFields.Language.with((Object)tracker.getLanguage()));
        events.add(EventFields.PluginInfo.with((Object)PluginInfoDetectorKt.getPluginInfo(tracker.getLanguage().getClass())));
        return events;
    }

    static {
        Object[] objectArray = new String[]{"code", "comment", "literal", "commit"};
        DOMAIN_FIELD = EventFields.String((String)"domain", (List)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{SpellCheckerBundle.message("dictionary.name.project.level", new Object[0]), SpellCheckerBundle.message("dictionary.name.application.level", new Object[0])};
        DICTIONARY_LAYER_FIELD = EventFields.String((String)"dictionary_layer", (List)CollectionsKt.listOf((Object[])objectArray));
        SUGGESTION_INDEX_FIELD = EventFields.Int((String)"suggestion_index");
        TOTAL_SUGGESTIONS_FIELD = EventFields.Int((String)"total_suggestions");
        removeFromAcceptedWords = GROUP.registerEvent("remove.from.accepted.words.ui");
        addToAcceptedWords = GROUP.registerEvent("add.to.accepted.words.ui");
        objectArray = new EventField[]{DOMAIN_FIELD, EventFields.Language, EventFields.PluginInfo};
        suggestionShownEvent = GROUP.registerVarargEvent("suggestion.shown", (EventField[])objectArray);
        objectArray = new EventField[]{DOMAIN_FIELD, SUGGESTION_INDEX_FIELD, TOTAL_SUGGESTIONS_FIELD, EventFields.Language, EventFields.PluginInfo};
        changeToInvokedEvent = GROUP.registerVarargEvent("change.to.invoked", (EventField[])objectArray);
        objectArray = new EventField[]{DOMAIN_FIELD, TOTAL_SUGGESTIONS_FIELD, EventFields.Language, EventFields.PluginInfo};
        renameToInvokedEvent = GROUP.registerVarargEvent("rename.to.invoked", (EventField[])objectArray);
        objectArray = new EventField[]{DOMAIN_FIELD, DICTIONARY_LAYER_FIELD, EventFields.Language, EventFields.PluginInfo};
        saveToInvokedEvent = GROUP.registerVarargEvent("save.to.invoked", (EventField[])objectArray);
    }
}

