/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.config;

import com.intellij.DynamicBundle;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositorySubtype;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.config.RecentTaskRepositories;
import com.intellij.tasks.config.TaskRepositoryEditor;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskRepositoriesConfigurable
implements Configurable.NoScroll,
SearchableConfigurable,
Configurable.WithEpDependencies {
    public static final String ID = "tasks.servers";
    private static final String EMPTY_PANEL = "empty.panel";
    private JPanel myPanel;
    private JPanel myServersPanel;
    private final JBList<TaskRepository> myRepositoriesList;
    private JPanel myToolbarPanel;
    private JPanel myRepositoryEditor;
    private JBLabel myServersLabel;
    private Splitter mySplitter;
    private JPanel myEmptyPanel;
    private final List<TaskRepository> myRepositories;
    private final List<TaskRepositoryEditor> myEditors;
    private final Project myProject;
    private final Consumer<TaskRepository> myChangeListener;
    private int count;
    private final Map<TaskRepository, String> myRepoNames;
    private final TaskManagerImpl myManager;

    public TaskRepositoriesConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myRepositories = new ArrayList<TaskRepository>();
        this.myEditors = new ArrayList<TaskRepositoryEditor>();
        this.myRepoNames = ConcurrentFactoryMap.createMap(repository -> Integer.toString(this.count++));
        this.myProject = project;
        this.myManager = (TaskManagerImpl)TaskManager.getManager((Project)project);
        this.myRepositoriesList = new JBList();
        this.myRepositoriesList.getEmptyText().setText(TaskBundle.message((String)"settings.no.servers", (Object[])new Object[0]));
        this.myServersLabel.setLabelFor(this.myRepositoriesList);
        this.myServersPanel.setMinimumSize(new Dimension(-1, 100));
        ArrayList groups = new ArrayList(TaskRepositoryType.getRepositoryTypes());
        groups.sort(null);
        final ArrayList<1> createActions = new ArrayList<1>();
        for (final TaskRepositoryType taskRepositoryType : groups) {
            for (final TaskRepositorySubtype subtype : taskRepositoryType.getAvailableSubtypes()) {
                createActions.add(new AddServerAction(this, subtype){

                    @Override
                    protected TaskRepository getRepository() {
                        return taskRepositoryType.createRepository(subtype);
                    }
                });
            }
        }
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myRepositoriesList).disableUpDownActions().setAddIcon(LayeredIcon.ADD_WITH_DROPDOWN);
        toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                DefaultActionGroup group = new DefaultActionGroup();
                for (AnAction aMyAdditional : createActions) {
                    group.add(aMyAdditional);
                }
                Set<TaskRepository> repositories = RecentTaskRepositories.getInstance().getRepositories();
                TaskRepositoriesConfigurable.this.myRepositories.forEach(repositories::remove);
                if (!repositories.isEmpty()) {
                    group.add((AnAction)Separator.getInstance());
                    for (final TaskRepository repository : repositories) {
                        group.add((AnAction)new AddServerAction(this, repository){

                            @Override
                            protected TaskRepository getRepository() {
                                return repository;
                            }
                        });
                    }
                }
                JBPopupFactory.getInstance().createActionGroupPopup(TaskBundle.message((String)"popup.title.add.server", (Object[])new Object[0]), (ActionGroup)group, DataManager.getInstance().getDataContext((Component)anActionButton.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(anActionButton.getPreferredPopupPoint());
            }
        });
        toolbarDecorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TaskRepository repository = TaskRepositoriesConfigurable.this.getSelectedRepository();
                if (repository != null) {
                    CollectionListModel<TaskRepository> model = TaskRepositoriesConfigurable.this.getListModel();
                    model.remove((Object)repository);
                    TaskRepositoriesConfigurable.this.myRepositories.remove(repository);
                    if (model.getSize() > 0) {
                        TaskRepositoriesConfigurable.this.myRepositoriesList.setSelectedValue(model.getElementAt(0), true);
                    } else {
                        TaskRepositoriesConfigurable.this.myRepositoryEditor.removeAll();
                        TaskRepositoriesConfigurable.this.myRepositoryEditor.repaint();
                    }
                }
            }
        });
        this.myServersPanel.add((Component)toolbarDecorator.createPanel(), "Center");
        this.myRepositoriesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                TaskRepository repository;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((repository = TaskRepositoriesConfigurable.this.getSelectedRepository()) != null) {
                    String name = TaskRepositoriesConfigurable.this.myRepoNames.get(repository);
                    assert (name != null);
                    ((CardLayout)TaskRepositoriesConfigurable.this.myRepositoryEditor.getLayout()).show(TaskRepositoriesConfigurable.this.myRepositoryEditor, name);
                    TaskRepositoriesConfigurable.this.mySplitter.doLayout();
                    TaskRepositoriesConfigurable.this.mySplitter.repaint();
                    TaskRepositoriesConfigurable.this.myRepositoryEditor.updateUI();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/config/TaskRepositoriesConfigurable$4", "valueChanged"));
            }
        });
        this.myRepositoriesList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            label.setIcon(value.getIcon());
            label.setText(value.getPresentableName());
        }));
        this.myChangeListener = repository -> this.getListModel().contentsChanged(repository);
    }

    private CollectionListModel<TaskRepository> getListModel() {
        return (CollectionListModel)this.myRepositoriesList.getModel();
    }

    private void addRepository(TaskRepository repository) {
        this.myRepositories.add(repository);
        this.getListModel().add((Object)repository);
        this.addRepositoryEditor(repository);
        this.myRepositoriesList.setSelectedIndex(this.myRepositoriesList.getModel().getSize() - 1);
    }

    private void addRepositoryEditor(TaskRepository repository) {
        TaskRepositoryEditor editor = repository.getRepositoryType().createEditor(repository, this.myProject, this.myChangeListener);
        this.myEditors.add(editor);
        JComponent component = editor.createComponent();
        String name = this.myRepoNames.get(repository);
        this.myRepositoryEditor.add((Component)component, name);
        this.myRepositoryEditor.doLayout();
    }

    @Nullable
    private TaskRepository getSelectedRepository() {
        return (TaskRepository)this.myRepositoriesList.getSelectedValue();
    }

    public String getDisplayName() {
        return TaskBundle.message((String)"configurable.TaskRepositoriesConfigurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.project.tasks.servers";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myRepositoriesList;
    }

    public boolean isModified() {
        return !this.myRepositories.equals(Arrays.asList(this.myManager.getAllRepositories()));
    }

    public void apply() {
        List newRepositories = ContainerUtil.map(this.myRepositories, TaskRepository::clone);
        this.myManager.setRepositories(newRepositories);
        this.myManager.updateIssues(null);
        RecentTaskRepositories.getInstance().addRepositories(this.myRepositories);
    }

    public void reset() {
        this.myRepoNames.clear();
        this.myRepositoryEditor.removeAll();
        this.myRepositoryEditor.add((Component)this.myEmptyPanel, EMPTY_PANEL);
        this.myRepositories.clear();
        CollectionListModel listModel = new CollectionListModel(new ArrayList());
        for (TaskRepository repository : this.myManager.getAllRepositories()) {
            TaskRepository clone = repository.clone();
            assert (clone.equals((Object)repository)) : repository.getClass().getName();
            this.myRepositories.add(clone);
            listModel.add((Object)clone);
        }
        this.myRepositoriesList.setModel((ListModel)listModel);
        for (TaskRepository clone : this.myRepositories) {
            this.addRepositoryEditor(clone);
        }
        if (!this.myRepositories.isEmpty()) {
            this.myRepositoriesList.setSelectedValue((Object)this.myRepositories.get(0), true);
        }
    }

    public void disposeUIResources() {
        for (TaskRepositoryEditor editor : this.myEditors) {
            Disposer.dispose((Disposable)editor);
        }
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        TaskRepository matched = (TaskRepository)ContainerUtil.find(this.myRepositories, repository -> repository.getRepositoryType().getName().contains(option));
        return matched == null ? null : () -> this.myRepositoriesList.setSelectedValue((Object)matched, true);
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        List<ExtensionPointName> list = Collections.singletonList(TaskRepositoryType.EP_NAME);
        if (list == null) {
            TaskRepositoriesConfigurable.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/config/TaskRepositoriesConfigurable", "getDependencies"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        Splitter splitter;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JBLabel jBLabel;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myServersLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/TaskBundle", TaskRepositoriesConfigurable.class).getString("settings.configured.servers"));
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServersPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, new Dimension(0, 50), null));
        this.myRepositoryEditor = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myEmptyPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "Card1");
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(100, 220, 100, 220), null, 0, 0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalAlignment(0);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/TaskBundle", TaskRepositoriesConfigurable.class).getString("settings.no.server.selected"));
        jPanel.add((Component)jBLabel2, "Center");
        this.mySplitter = splitter = new Splitter();
        splitter.setOrientation(true);
        jPanel4.add((Component)splitter, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        splitter.setFirstComponent((JComponent)jPanel3);
        splitter.setSecondComponent((JComponent)jPanel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private abstract class AddServerAction
    extends IconWithTextAction
    implements DumbAware {
        AddServerAction(TaskRepositorySubtype subtype) {
            super(() -> ((TaskRepositorySubtype)subtype).getName(), TaskBundle.messagePointer((String)"settings.new.server", (Object[])new Object[]{subtype.getName()}), subtype.getIcon());
        }

        AddServerAction(TaskRepository repository) {
            super(repository.getUrl(), repository.getUrl(), repository.getIcon());
        }

        protected abstract TaskRepository getRepository();

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddServerAction.$$$reportNull$$$0(0);
            }
            TaskRepositoriesConfigurable.this.addRepository(this.getRepository());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/config/TaskRepositoriesConfigurable$AddServerAction", "actionPerformed"));
        }
    }
}

