/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicateKt;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000f\u001a0\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0017\u0012\u000e\b\u0001\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010\u00a2\u0006\u0002\b\u00130\u0010\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/vcs/configurable/VcsUpdateInfoScopeFilter;", "", "project", "Lcom/intellij/openapi/project/Project;", "myVcsConfiguration", "Lcom/intellij/openapi/vcs/VcsConfiguration;", "parenDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/VcsConfiguration;Lcom/intellij/openapi/Disposable;)V", "myCheckbox", "Ljavax/swing/JCheckBox;", "myComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "", "myNamedScopeHolders", "", "Lcom/intellij/psi/search/scope/packageSet/NamedScopesHolder;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "[Lcom/intellij/psi/search/scope/packageSet/NamedScopesHolder;", "createContent", "", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "manageScopesAction", "Ljava/lang/Runnable;", "reset", "scopeFilterName", "getScopeFilterName", "()Ljava/lang/String;", "intellij.platform.vcs.impl"})
public final class VcsUpdateInfoScopeFilter {
    @NotNull
    private final VcsConfiguration myVcsConfiguration;
    @NotNull
    private final JCheckBox myCheckbox;
    @NotNull
    private final ComboBox<String> myComboBox;
    @NotNull
    private final NamedScopesHolder[] myNamedScopeHolders;

    public VcsUpdateInfoScopeFilter(@NotNull Project project, @NotNull VcsConfiguration myVcsConfiguration, @NotNull Disposable parenDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myVcsConfiguration, (String)"myVcsConfiguration");
        Intrinsics.checkNotNullParameter((Object)parenDisposable, (String)"parenDisposable");
        this.myVcsConfiguration = myVcsConfiguration;
        this.myCheckbox = new JCheckBox(VcsBundle.message((String)"settings.filter.update.project.info.by.scope", (Object[])new Object[0]));
        this.myComboBox = new ComboBox();
        NamedScopesHolder[] namedScopesHolderArray = NamedScopesHolder.getAllNamedScopeHolders((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)namedScopesHolderArray, (String)"getAllNamedScopeHolders(...)");
        this.myNamedScopeHolders = namedScopesHolderArray;
        for (NamedScopesHolder holder : this.myNamedScopeHolders) {
            holder.addScopeListener(this::reset, parenDisposable);
        }
    }

    public final void createContent(@NotNull Panel panel, @NotNull Runnable manageScopesAction) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)manageScopesAction, (String)"manageScopesAction");
        Panel $this$createContent_u24lambda_u240 = panel;
        boolean bl = false;
        Panel.row$default((Panel)$this$createContent_u24lambda_u240, null, arg_0 -> VcsUpdateInfoScopeFilter.createContent$lambda$0$0(this, manageScopesAction, arg_0), (int)1, null);
        $this$createContent_u24lambda_u240.onIsModified(() -> VcsUpdateInfoScopeFilter.createContent$lambda$0$1(this));
        $this$createContent_u24lambda_u240.onApply(() -> VcsUpdateInfoScopeFilter.createContent$lambda$0$2(this));
        $this$createContent_u24lambda_u240.onReset((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                VcsUpdateInfoScopeFilter.access$reset((VcsUpdateInfoScopeFilter)this.receiver);
            }
        });
    }

    private final void reset() {
        this.myComboBox.removeAllItems();
        boolean selection = false;
        for (NamedScopesHolder holder : this.myNamedScopeHolders) {
            NamedScope[] namedScopeArray;
            Intrinsics.checkNotNullExpressionValue((Object)holder.getEditableScopes(), (String)"getEditableScopes(...)");
            for (NamedScope scope : namedScopeArray) {
                String name = scope.getScopeId();
                this.myComboBox.addItem((Object)name);
                if (selection || !Intrinsics.areEqual((Object)name, (Object)this.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME)) continue;
                selection = true;
            }
        }
        if (selection) {
            this.myComboBox.setItem((Object)this.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME);
        }
        this.myCheckbox.setSelected(selection);
    }

    private final String getScopeFilterName() {
        return this.myCheckbox.isSelected() ? (String)this.myComboBox.getItem() : null;
    }

    private static final Unit createContent$lambda$0$0(VcsUpdateInfoScopeFilter this$0, Runnable $manageScopesAction, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.myCheckbox).gap(RightGap.SMALL);
        $this$row.cell((JComponent)this$0.myComboBox).enabledIf(ComponentPredicateKt.getSelected((AbstractButton)this$0.myCheckbox));
        String string = VcsBundle.message((String)"configurable.vcs.manage.scopes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.link(string, arg_0 -> VcsUpdateInfoScopeFilter.createContent$lambda$0$0$0($manageScopesAction, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createContent$lambda$0$0$0(Runnable $manageScopesAction, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $manageScopesAction.run();
        return Unit.INSTANCE;
    }

    private static final boolean createContent$lambda$0$1(VcsUpdateInfoScopeFilter this$0) {
        return !Intrinsics.areEqual((Object)this$0.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME, (Object)this$0.getScopeFilterName());
    }

    private static final Unit createContent$lambda$0$2(VcsUpdateInfoScopeFilter this$0) {
        this$0.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME = this$0.getScopeFilterName();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$reset(VcsUpdateInfoScopeFilter $this) {
        $this.reset();
    }
}

