/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.StrongBox;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.java.ast.AnonymousObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentOperatorType;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.ConditionalExpression;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.DefiniteAssignmentAnalysis;
import com.strobel.decompiler.languages.java.ast.DepthFirstAstVisitor;
import com.strobel.decompiler.languages.java.ast.DoWhileStatement;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.ForEachStatement;
import com.strobel.decompiler.languages.java.ast.ForStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LabelStatement;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.languages.java.ast.WhileStatement;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeclareVariablesTransform
implements IAstTransform {
    protected final List<VariableToDeclare> variablesToDeclare = new ArrayList<VariableToDeclare>();
    protected final DecompilerContext context;

    public DeclareVariablesTransform(DecompilerContext context) {
        this.context = VerifyArgument.notNull(context, "context");
    }

    @Override
    public void run(AstNode node) {
        AssignmentExpression replacedAssignment;
        Variable variable;
        this.run(node, null);
        for (VariableToDeclare v : this.variablesToDeclare) {
            variable = v.getVariable();
            replacedAssignment = v.getReplacedAssignment();
            if (replacedAssignment != null) continue;
            BlockStatement block = v.isCatchVariable() ? v.getCatchClause().getBody() : (BlockStatement)v.getInsertionPoint().getParent();
            AnalysisResult analysisResult = this.analyze(v, block);
            if (v.isCatchVariable()) {
                if (analysisResult.isAssigned) continue;
                v.getCatchClause().addVariableModifier(Flags.Flag.FINAL);
                continue;
            }
            VariableDeclarationStatement declaration = new VariableDeclarationStatement(v.getType().clone(), v.getName());
            if (variable != null) {
                declaration.getVariables().firstOrNullObject().putUserData(Keys.VARIABLE, variable);
            }
            if (analysisResult.isSingleAssignment) {
                declaration.addModifier(Flags.Flag.FINAL);
            } else if (analysisResult.needsInitializer && variable != null) {
                declaration.getVariables().firstOrNullObject().setInitializer(AstBuilder.makeDefaultValue(variable.getType()));
            }
            Statement insertionPoint = v.getInsertionPoint();
            while (insertionPoint.getPreviousSibling() instanceof LabelStatement) {
                insertionPoint = (Statement)insertionPoint.getPreviousSibling();
            }
            block.getStatements().insertBefore(insertionPoint, declaration);
        }
        for (VariableToDeclare v : this.variablesToDeclare) {
            variable = v.getVariable();
            replacedAssignment = v.getReplacedAssignment();
            if (replacedAssignment == null) continue;
            VariableInitializer initializer = new VariableInitializer(v.getName());
            Expression right = replacedAssignment.getRight();
            AstNode parent = replacedAssignment.getParent();
            if (parent.isNull() || parent.getParent() == null) continue;
            AnalysisResult analysisResult = this.analyze(v, parent.getParent());
            right.remove();
            right.putUserDataIfAbsent(Keys.MEMBER_REFERENCE, replacedAssignment.getUserData(Keys.MEMBER_REFERENCE));
            right.putUserDataIfAbsent(Keys.VARIABLE, variable);
            initializer.setInitializer(right);
            initializer.putUserData(Keys.VARIABLE, variable);
            VariableDeclarationStatement declaration = new VariableDeclarationStatement();
            declaration.setType(v.getType().clone());
            declaration.getVariables().add(initializer);
            if (parent instanceof ExpressionStatement) {
                if (analysisResult.isSingleAssignment) {
                    declaration.addModifier(Flags.Flag.FINAL);
                }
                declaration.putUserDataIfAbsent(Keys.MEMBER_REFERENCE, parent.getUserData(Keys.MEMBER_REFERENCE));
                declaration.putUserData(Keys.VARIABLE, variable);
                parent.replaceWith(declaration);
                continue;
            }
            if (analysisResult.isSingleAssignment) {
                declaration.addModifier(Flags.Flag.FINAL);
            }
            replacedAssignment.replaceWith(declaration);
        }
        this.variablesToDeclare.clear();
    }

    private AnalysisResult analyze(VariableToDeclare v, AstNode scope) {
        Statement parentStatement;
        BlockStatement block = v.getBlock();
        DefiniteAssignmentAnalysis analysis = new DefiniteAssignmentAnalysis(this.context, block);
        if (v.getInsertionPoint() != null) {
            parentStatement = v.getInsertionPoint();
            analysis.setAnalyzedRange(parentStatement, block);
        } else if (v.isCatchVariable()) {
            analysis.setAnalyzedRange(block, block);
        } else {
            parentStatement = (ExpressionStatement)v.getReplacedAssignment().getParent();
            analysis.setAnalyzedRange(parentStatement, block);
        }
        analysis.analyze(v.getName());
        boolean needsInitializer = !analysis.getUnassignedVariableUses().isEmpty();
        IsSingleAssignmentVisitor isSingleAssignmentVisitor = new IsSingleAssignmentVisitor(v.getName(), v.getReplacedAssignment());
        scope.acceptVisitor(isSingleAssignmentVisitor, null);
        return new AnalysisResult(isSingleAssignmentVisitor.isAssigned(), isSingleAssignmentVisitor.isSingleAssignment(), needsInitializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(AstNode node, DefiniteAssignmentAnalysis daa) {
        AstBuilder builder;
        Variable v;
        DefiniteAssignmentAnalysis analysis = daa;
        if (node instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)node;
            ArrayList<VariableDeclarationStatement> variables = new ArrayList<VariableDeclarationStatement>();
            for (Statement statement : block.getStatements()) {
                if (!(statement instanceof VariableDeclarationStatement)) continue;
                variables.add((VariableDeclarationStatement)statement);
            }
            if (!variables.isEmpty()) {
                for (VariableDeclarationStatement declaration : variables) {
                    assert (declaration.getVariables().size() == 1 && declaration.getVariables().firstOrNullObject().getInitializer().isNull());
                    declaration.remove();
                }
            }
            if (analysis == null) {
                analysis = new DefiniteAssignmentAnalysis(block, new JavaResolver(this.context));
            }
            for (VariableDeclarationStatement declaration : variables) {
                VariableInitializer initializer = declaration.getVariables().firstOrNullObject();
                String variableName = initializer.getName();
                Variable variable = declaration.getUserData(Keys.VARIABLE);
                this.declareVariableInBlock(analysis, block, declaration.getType(), variableName, variable, true);
            }
        }
        if (node instanceof MethodDeclaration || node instanceof ConstructorDeclaration) {
            HashSet<ParameterDefinition> unassignedParameters = new HashSet<ParameterDefinition>();
            AstNodeCollection<ParameterDeclaration> parameters = node.getChildrenByRole(Roles.PARAMETER);
            HashMap<ParameterDefinition, ParameterDeclaration> declarationMap = new HashMap<ParameterDefinition, ParameterDeclaration>();
            HashMap<String, ParameterDefinition> parametersByName = new HashMap<String, ParameterDefinition>();
            for (ParameterDeclaration parameter : parameters) {
                ParameterDefinition definition = parameter.getUserData(Keys.PARAMETER_DEFINITION);
                if (definition == null) continue;
                unassignedParameters.add(definition);
                declarationMap.put(definition, parameter);
                parametersByName.put(parameter.getName(), definition);
            }
            node.acceptVisitor(new ParameterAssignmentVisitor(unassignedParameters, parametersByName), null);
            for (ParameterDefinition definition : unassignedParameters) {
                ParameterDeclaration declaration = (ParameterDeclaration)declarationMap.get(definition);
                if (declaration == null || declaration.hasModifier(Flags.Flag.FINAL)) continue;
                declaration.addChild(new JavaModifierToken(Flags.Flag.FINAL), EntityDeclaration.MODIFIER_ROLE);
            }
        }
        if (node instanceof CatchClause && (v = node.getUserData(Keys.VARIABLE)) != null && (builder = this.context.getUserData(Keys.AST_BUILDER)) != null) {
            this.variablesToDeclare.add(new VariableToDeclare(builder.convertType(v.getType()), v.getName(), v, (CatchClause)node));
        }
        for (AstNode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof TypeDeclaration) {
                TypeDefinition currentType = this.context.getCurrentType();
                MethodDefinition currentMethod = this.context.getCurrentMethod();
                this.context.setCurrentType(null);
                this.context.setCurrentMethod(null);
                try {
                    new DeclareVariablesTransform(this.context).run(child);
                    continue;
                }
                finally {
                    this.context.setCurrentType(currentType);
                    this.context.setCurrentMethod(currentMethod);
                }
            }
            this.run(child, analysis);
        }
    }

    private void declareVariableInBlock(DefiniteAssignmentAnalysis analysis, BlockStatement block, AstType type, String variableName, Variable variable, boolean allowPassIntoLoops) {
        StrongBox<Statement> declarationPoint = new StrongBox<Statement>();
        boolean canMoveVariableIntoSubBlocks = DeclareVariablesTransform.findDeclarationPoint(analysis, variableName, allowPassIntoLoops, block, declarationPoint, null);
        if (declarationPoint.get() == null) {
            return;
        }
        if (canMoveVariableIntoSubBlocks) {
            for (Statement statement : block.getStatements()) {
                boolean canStillMoveIntoSubBlocks;
                if (!DeclareVariablesTransform.usesVariable(statement, variableName)) continue;
                boolean processChildren = true;
                if (statement instanceof ForStatement && statement == declarationPoint.get()) {
                    ForStatement forStatement = (ForStatement)statement;
                    AstNodeCollection<Statement> initializers = forStatement.getInitializers();
                    for (Statement initializer : initializers) {
                        if (!this.tryConvertAssignmentExpressionIntoVariableDeclaration(block, initializer, type, variableName)) continue;
                        processChildren = false;
                        break;
                    }
                }
                if (processChildren) {
                    for (AstNode child : statement.getChildren()) {
                        if (child instanceof BlockStatement) {
                            this.declareVariableInBlock(analysis, (BlockStatement)child, type, variableName, variable, allowPassIntoLoops);
                            continue;
                        }
                        if (!DeclareVariablesTransform.hasNestedBlocks(child)) continue;
                        for (AstNode nestedChild : child.getChildren()) {
                            if (!(nestedChild instanceof BlockStatement)) continue;
                            this.declareVariableInBlock(analysis, (BlockStatement)nestedChild, type, variableName, variable, allowPassIntoLoops);
                        }
                    }
                }
                if ((canStillMoveIntoSubBlocks = DeclareVariablesTransform.findDeclarationPoint(analysis, variableName, allowPassIntoLoops, block, declarationPoint, statement)) || declarationPoint.get() == null) continue;
                if (!this.tryConvertAssignmentExpressionIntoVariableDeclaration(block, declarationPoint.get(), type, variableName)) {
                    VariableToDeclare vtd = new VariableToDeclare(type, variableName, variable, declarationPoint.get(), block);
                    this.variablesToDeclare.add(vtd);
                }
                return;
            }
        } else if (!this.tryConvertAssignmentExpressionIntoVariableDeclaration(block, declarationPoint.get(), type, variableName)) {
            VariableToDeclare vtd = new VariableToDeclare(type, variableName, variable, declarationPoint.get(), block);
            this.variablesToDeclare.add(vtd);
        }
    }

    public static boolean findDeclarationPoint(DefiniteAssignmentAnalysis analysis, VariableDeclarationStatement declaration, BlockStatement block, StrongBox<Statement> declarationPoint, Statement skipUpThrough) {
        String variableName = declaration.getVariables().firstOrNullObject().getName();
        return DeclareVariablesTransform.findDeclarationPoint(analysis, variableName, true, block, declarationPoint, skipUpThrough);
    }

    static boolean findDeclarationPoint(DefiniteAssignmentAnalysis analysis, String variableName, boolean allowPassIntoLoops, BlockStatement block, StrongBox<Statement> declarationPoint, Statement skipUpThrough) {
        CatchClause catchClause;
        declarationPoint.set(null);
        Statement waitFor = skipUpThrough;
        if (block.getParent() instanceof CatchClause && StringUtilities.equals((catchClause = (CatchClause)block.getParent()).getVariableName(), variableName)) {
            return false;
        }
        for (Statement statement : block.getStatements()) {
            if (waitFor != null) {
                if (statement != waitFor) continue;
                waitFor = null;
                continue;
            }
            if (!DeclareVariablesTransform.usesVariable(statement, variableName)) continue;
            if (declarationPoint.get() != null) {
                return DeclareVariablesTransform.canRedeclareVariable(analysis, block, statement, variableName);
            }
            declarationPoint.set(statement);
            if (!DeclareVariablesTransform.canMoveVariableIntoSubBlock(analysis, block, statement, variableName, allowPassIntoLoops)) {
                return false;
            }
            Statement nextStatement = statement.getNextStatement();
            if (nextStatement == null) continue;
            analysis.setAnalyzedRange(nextStatement, block);
            analysis.analyze(variableName);
            if (analysis.getUnassignedVariableUses().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean canMoveVariableIntoSubBlock(DefiniteAssignmentAnalysis analysis, BlockStatement block, Statement statement, String variableName, boolean allowPassIntoLoops) {
        TryCatchStatement tryCatch;
        ForStatement forStatement;
        if (!allowPassIntoLoops && AstNode.isLoop(statement)) {
            return false;
        }
        if (statement instanceof ForStatement && !(forStatement = (ForStatement)statement).getInitializers().isEmpty()) {
            boolean result = false;
            TypeReference lastInitializerType = null;
            StrongBox<Statement> declarationPoint = null;
            HashSet<String> variableNames = new HashSet<String>();
            for (Statement initializer : forStatement.getInitializers()) {
                Expression e;
                if (!(initializer instanceof ExpressionStatement) || !(((ExpressionStatement)initializer).getExpression() instanceof AssignmentExpression) || !((e = ((ExpressionStatement)initializer).getExpression()) instanceof AssignmentExpression) || ((AssignmentExpression)e).getOperator() != AssignmentOperatorType.ASSIGN || !(((AssignmentExpression)e).getLeft() instanceof IdentifierExpression)) continue;
                IdentifierExpression identifier = (IdentifierExpression)((AssignmentExpression)e).getLeft();
                boolean usedByInitializer = DeclareVariablesTransform.usesVariable(((AssignmentExpression)e).getRight(), variableName);
                if (usedByInitializer) {
                    return false;
                }
                Variable variable = identifier.getUserData(Keys.VARIABLE);
                if (variable == null || variable.isParameter()) {
                    return false;
                }
                TypeReference variableType = variable.getType();
                if (lastInitializerType == null) {
                    lastInitializerType = variableType;
                } else if (!MetadataHelper.isSameType(lastInitializerType, variableType)) {
                    return false;
                }
                if (!variableNames.add(identifier.getIdentifier())) {
                    return false;
                }
                if (result) {
                    if (declarationPoint == null) {
                        declarationPoint = new StrongBox<Statement>();
                    }
                    if (DeclareVariablesTransform.findDeclarationPoint(analysis, identifier.getIdentifier(), allowPassIntoLoops, block, declarationPoint, null) && declarationPoint.get() == statement) continue;
                    return false;
                }
                if (!StringUtilities.equals(identifier.getIdentifier(), variableName)) continue;
                result = true;
            }
            if (result) {
                return true;
            }
        }
        if (statement instanceof TryCatchStatement && !(tryCatch = (TryCatchStatement)statement).getDeclaredResources().isEmpty()) {
            for (VariableDeclarationStatement resource : tryCatch.getDeclaredResources()) {
                if (!StringUtilities.equals(CollectionUtilities.first(resource.getVariables()).getName(), variableName)) continue;
                return true;
            }
        }
        for (AstNode child = statement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof BlockStatement || !DeclareVariablesTransform.usesVariable(child, variableName)) continue;
            if (DeclareVariablesTransform.hasNestedBlocks(child)) {
                for (AstNode grandChild = child.getFirstChild(); grandChild != null; grandChild = grandChild.getNextSibling()) {
                    if (grandChild instanceof BlockStatement || !DeclareVariablesTransform.usesVariable(grandChild, variableName)) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean usesVariable(AstNode node, String variableName) {
        if (node instanceof AnonymousObjectCreationExpression) {
            for (Expression argument : ((AnonymousObjectCreationExpression)node).getArguments()) {
                if (!DeclareVariablesTransform.usesVariable(argument, variableName)) continue;
                return true;
            }
            return false;
        }
        if (node instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)node;
            for (FieldDeclaration field : CollectionUtilities.ofType(type.getMembers(), FieldDeclaration.class)) {
                if (field.getVariables().isEmpty() || !DeclareVariablesTransform.usesVariable(CollectionUtilities.first(field.getVariables()), variableName)) continue;
                return true;
            }
            for (MethodDeclaration method : CollectionUtilities.ofType(type.getMembers(), MethodDeclaration.class)) {
                if (!DeclareVariablesTransform.usesVariable(method.getBody(), variableName)) continue;
                return true;
            }
            return false;
        }
        if (node instanceof IdentifierExpression && StringUtilities.equals(((IdentifierExpression)node).getIdentifier(), variableName)) {
            return true;
        }
        if (node instanceof ForStatement) {
            ForStatement forLoop = (ForStatement)node;
            for (Statement statement : forLoop.getInitializers()) {
                if (!(statement instanceof VariableDeclarationStatement)) continue;
                AstNodeCollection<VariableInitializer> variables = ((VariableDeclarationStatement)statement).getVariables();
                for (VariableInitializer variable : variables) {
                    if (!StringUtilities.equals(variable.getName(), variableName)) continue;
                    return false;
                }
            }
        }
        if (node instanceof TryCatchStatement) {
            TryCatchStatement tryCatch = (TryCatchStatement)node;
            for (VariableDeclarationStatement resource : tryCatch.getDeclaredResources()) {
                if (!StringUtilities.equals(CollectionUtilities.first(resource.getVariables()).getName(), variableName)) continue;
                return false;
            }
        }
        if (node instanceof ForEachStatement && StringUtilities.equals(((ForEachStatement)node).getVariableName(), variableName)) {
            return false;
        }
        if (node instanceof CatchClause && StringUtilities.equals(((CatchClause)node).getVariableName(), variableName)) {
            return false;
        }
        for (AstNode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!DeclareVariablesTransform.usesVariable(child, variableName)) continue;
            return true;
        }
        return false;
    }

    private static boolean canRedeclareVariable(DefiniteAssignmentAnalysis analysis, BlockStatement block, AstNode node, String variableName) {
        if (node instanceof ForStatement) {
            ForStatement forLoop = (ForStatement)node;
            for (Statement statement : forLoop.getInitializers()) {
                if (statement instanceof VariableDeclarationStatement) {
                    AstNodeCollection<VariableInitializer> variables = ((VariableDeclarationStatement)statement).getVariables();
                    for (VariableInitializer variable : variables) {
                        if (!StringUtilities.equals(variable.getName(), variableName)) continue;
                        return true;
                    }
                    continue;
                }
                if (!(statement instanceof ExpressionStatement) || !(((ExpressionStatement)statement).getExpression() instanceof AssignmentExpression)) continue;
                AssignmentExpression assignment = (AssignmentExpression)((ExpressionStatement)statement).getExpression();
                Expression left = assignment.getLeft();
                Expression right = assignment.getRight();
                if (!(left instanceof IdentifierExpression) || !StringUtilities.equals(((IdentifierExpression)left).getIdentifier(), variableName) || DeclareVariablesTransform.usesVariable(right, variableName)) continue;
                return true;
            }
        }
        if (node instanceof ForEachStatement && StringUtilities.equals(((ForEachStatement)node).getVariableName(), variableName)) {
            return true;
        }
        if (node instanceof TryCatchStatement) {
            TryCatchStatement tryCatch = (TryCatchStatement)node;
            for (VariableDeclarationStatement resource : tryCatch.getDeclaredResources()) {
                if (!StringUtilities.equals(CollectionUtilities.first(resource.getVariables()).getName(), variableName)) continue;
                return true;
            }
        }
        for (AstNode prev = node.getPreviousSibling(); prev != null && !prev.isNull(); prev = prev.getPreviousSibling()) {
            if (!DeclareVariablesTransform.usesVariable(prev, variableName)) continue;
            Statement statement = CollectionUtilities.firstOrDefault(CollectionUtilities.ofType(prev.getAncestorsAndSelf(), Statement.class));
            if (statement == null) {
                return false;
            }
            if (DeclareVariablesTransform.canMoveVariableIntoSubBlock(analysis, block, statement, variableName, true)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasNestedBlocks(AstNode node) {
        return node.getChildByRole(Roles.EMBEDDED_STATEMENT) instanceof BlockStatement || node instanceof TryCatchStatement || node instanceof CatchClause || node instanceof SwitchSection;
    }

    private boolean tryConvertAssignmentExpressionIntoVariableDeclaration(BlockStatement block, Statement declarationPoint, AstType type, String variableName) {
        return declarationPoint instanceof ExpressionStatement && this.tryConvertAssignmentExpressionIntoVariableDeclaration(block, ((ExpressionStatement)declarationPoint).getExpression(), type, variableName);
    }

    private boolean tryConvertAssignmentExpressionIntoVariableDeclaration(BlockStatement block, Expression expression, AstType type, String variableName) {
        IdentifierExpression identifier;
        AssignmentExpression assignment;
        if (expression instanceof AssignmentExpression && (assignment = (AssignmentExpression)expression).getOperator() == AssignmentOperatorType.ASSIGN && assignment.getLeft() instanceof IdentifierExpression && StringUtilities.equals((identifier = (IdentifierExpression)assignment.getLeft()).getIdentifier(), variableName)) {
            this.variablesToDeclare.add(new VariableToDeclare(type, variableName, identifier.getUserData(Keys.VARIABLE), assignment, block));
            return true;
        }
        return false;
    }

    private static final class ParameterAssignmentVisitor
    extends DepthFirstAstVisitor<Void, Boolean> {
        private final Set<ParameterDefinition> _unassignedParameters;
        private final Map<String, ParameterDefinition> _parametersByName;

        ParameterAssignmentVisitor(Set<ParameterDefinition> unassignedParameters, Map<String, ParameterDefinition> parametersByName) {
            this._unassignedParameters = unassignedParameters;
            this._parametersByName = parametersByName;
            for (ParameterDefinition p : unassignedParameters) {
                this._parametersByName.put(p.getName(), p);
            }
        }

        @Override
        protected Boolean visitChildren(AstNode node, Void data) {
            return (Boolean)super.visitChildren(node, data);
        }

        @Override
        public Boolean visitAssignmentExpression(AssignmentExpression node, Void p) {
            Expression left = node.getLeft();
            Variable variable = left.getUserData(Keys.VARIABLE);
            if (variable != null && variable.isParameter()) {
                this._unassignedParameters.remove(variable.getOriginalParameter());
                return (Boolean)super.visitAssignmentExpression(node, p);
            }
            ParameterDefinition parameter = left.getUserData(Keys.PARAMETER_DEFINITION);
            if (parameter == null && left instanceof IdentifierExpression) {
                parameter = this._parametersByName.get(((IdentifierExpression)left).getIdentifier());
            }
            if (parameter != null) {
                this._unassignedParameters.remove(parameter);
            }
            return (Boolean)super.visitAssignmentExpression(node, p);
        }

        @Override
        public Boolean visitTypeDeclaration(TypeDeclaration node, Void data) {
            return null;
        }

        @Override
        public Boolean visitUnaryOperatorExpression(UnaryOperatorExpression node, Void p) {
            Expression operand = node.getExpression();
            switch (node.getOperator()) {
                case INCREMENT: 
                case DECREMENT: 
                case POST_INCREMENT: 
                case POST_DECREMENT: {
                    ParameterDefinition parameter = operand.getUserData(Keys.PARAMETER_DEFINITION);
                    if (parameter == null && operand instanceof IdentifierExpression) {
                        parameter = this._parametersByName.get(((IdentifierExpression)operand).getIdentifier());
                    }
                    if (parameter == null) break;
                    this._unassignedParameters.remove(parameter);
                    break;
                }
            }
            return (Boolean)super.visitUnaryOperatorExpression(node, p);
        }
    }

    private static final class IsSingleAssignmentVisitor
    extends DepthFirstAstVisitor<Void, Boolean> {
        private final String _variableName;
        private final AssignmentExpression _replacedAssignment;
        private boolean _abort;
        private int _loopOrTryDepth;
        private int _assignmentCount;

        IsSingleAssignmentVisitor(String variableName, AssignmentExpression replacedAssignment) {
            this._variableName = VerifyArgument.notNull(variableName, "variableName");
            this._replacedAssignment = replacedAssignment;
        }

        final boolean isAssigned() {
            return this._assignmentCount > 0 && !this._abort;
        }

        final boolean isSingleAssignment() {
            return this._assignmentCount < 2 && !this._abort;
        }

        @Override
        protected Boolean visitChildren(AstNode node, Void data) {
            if (this._abort) {
                return Boolean.FALSE;
            }
            return (Boolean)super.visitChildren(node, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitForStatement(ForStatement node, Void p) {
            if (this._abort) {
                return Boolean.FALSE;
            }
            ++this._loopOrTryDepth;
            try {
                Boolean bl = (Boolean)super.visitForStatement(node, p);
                return bl;
            }
            finally {
                --this._loopOrTryDepth;
            }
        }

        @Override
        public Boolean visitIfElseStatement(IfElseStatement node, Void data) {
            return this.visitCondition(node.getCondition(), node.getTrueStatement(), node.getFalseStatement());
        }

        @Override
        public Boolean visitConditionalExpression(ConditionalExpression node, Void data) {
            return this.visitCondition(node.getCondition(), node.getTrueExpression(), node.getFalseExpression());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Boolean visitCondition(AstNode condition, AstNode ifTrue, AstNode ifFalse) {
            if (this._abort) {
                return Boolean.FALSE;
            }
            condition.acceptVisitor(this, null);
            int originalAssignmentCount = this._assignmentCount;
            this._assignmentCount = 0;
            try {
                ifTrue.acceptVisitor(this, null);
                if (this._assignmentCount > 0) {
                    this._abort = true;
                } else {
                    ifFalse.acceptVisitor(this, null);
                    this._abort |= this._assignmentCount > 0;
                }
            }
            finally {
                this._assignmentCount += originalAssignmentCount;
            }
            this._abort |= this._assignmentCount > 1;
            return !this._abort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitForEachStatement(ForEachStatement node, Void p) {
            if (this._abort) {
                return Boolean.FALSE;
            }
            ++this._loopOrTryDepth;
            try {
                if (StringUtilities.equals(node.getVariableName(), this._variableName)) {
                    ++this._assignmentCount;
                }
                Boolean bl = (Boolean)super.visitForEachStatement(node, p);
                return bl;
            }
            finally {
                --this._loopOrTryDepth;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitDoWhileStatement(DoWhileStatement node, Void p) {
            if (this._abort) {
                return Boolean.FALSE;
            }
            ++this._loopOrTryDepth;
            try {
                Boolean bl = (Boolean)super.visitDoWhileStatement(node, p);
                return bl;
            }
            finally {
                --this._loopOrTryDepth;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitWhileStatement(WhileStatement node, Void p) {
            if (this._abort) {
                return Boolean.FALSE;
            }
            ++this._loopOrTryDepth;
            try {
                Boolean bl = (Boolean)super.visitWhileStatement(node, p);
                return bl;
            }
            finally {
                --this._loopOrTryDepth;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean visitTryCatchStatement(TryCatchStatement node, Void data) {
            if (this._abort) {
                return Boolean.FALSE;
            }
            ++this._loopOrTryDepth;
            try {
                Boolean bl = (Boolean)super.visitTryCatchStatement(node, data);
                return bl;
            }
            finally {
                --this._loopOrTryDepth;
            }
        }

        @Override
        public Boolean visitAssignmentExpression(AssignmentExpression node, Void p) {
            if (this._abort) {
                return Boolean.FALSE;
            }
            Expression left = node.getLeft();
            if (left instanceof IdentifierExpression && StringUtilities.equals(((IdentifierExpression)left).getIdentifier(), this._variableName)) {
                if (this._loopOrTryDepth != 0 && this._replacedAssignment != node) {
                    this._abort = true;
                    return Boolean.FALSE;
                }
                ++this._assignmentCount;
            }
            return (Boolean)super.visitAssignmentExpression(node, p);
        }

        @Override
        public Boolean visitTypeDeclaration(TypeDeclaration node, Void data) {
            return !this._abort;
        }

        @Override
        public Boolean visitUnaryOperatorExpression(UnaryOperatorExpression node, Void p) {
            if (this._abort) {
                return Boolean.FALSE;
            }
            Expression operand = node.getExpression();
            switch (node.getOperator()) {
                case INCREMENT: 
                case DECREMENT: 
                case POST_INCREMENT: 
                case POST_DECREMENT: {
                    if (!(operand instanceof IdentifierExpression) || !StringUtilities.equals(((IdentifierExpression)operand).getIdentifier(), this._variableName)) break;
                    if (this._loopOrTryDepth != 0) {
                        this._abort = true;
                        return Boolean.FALSE;
                    }
                    if (this._assignmentCount == 0) {
                        ++this._assignmentCount;
                    }
                    ++this._assignmentCount;
                }
            }
            return (Boolean)super.visitUnaryOperatorExpression(node, p);
        }
    }

    protected static final class VariableToDeclare {
        private final AstType _type;
        private final String _name;
        private final Variable _variable;
        private final Statement _insertionPoint;
        private final AssignmentExpression _replacedAssignment;
        private final BlockStatement _block;
        private final CatchClause _catchClause;

        public VariableToDeclare(AstType type, String name, Variable variable, Statement insertionPoint, BlockStatement block) {
            this._type = type;
            this._name = name;
            this._variable = variable;
            this._insertionPoint = insertionPoint;
            this._replacedAssignment = null;
            this._block = block;
            this._catchClause = CatchClause.NULL;
        }

        public VariableToDeclare(AstType type, String name, Variable variable, AssignmentExpression replacedAssignment, BlockStatement block) {
            this._type = type;
            this._name = name;
            this._variable = variable;
            this._insertionPoint = null;
            this._replacedAssignment = replacedAssignment;
            this._block = block;
            this._catchClause = CatchClause.NULL;
        }

        public VariableToDeclare(AstType type, String name, Variable variable, CatchClause catchClause) {
            this._type = type;
            this._name = name;
            this._variable = variable;
            this._insertionPoint = null;
            this._replacedAssignment = null;
            this._block = null;
            this._catchClause = catchClause != null ? catchClause : CatchClause.NULL;
        }

        public boolean isCatchVariable() {
            return !this._catchClause.isNull();
        }

        public CatchClause getCatchClause() {
            return this._catchClause;
        }

        public BlockStatement getBlock() {
            if (this._catchClause.isNull()) {
                return this._block;
            }
            return this._catchClause.getBody();
        }

        public AstType getType() {
            return this._type;
        }

        public String getName() {
            return this._name;
        }

        public Variable getVariable() {
            return this._variable;
        }

        public AssignmentExpression getReplacedAssignment() {
            return this._replacedAssignment;
        }

        public Statement getInsertionPoint() {
            return this._insertionPoint;
        }

        public String toString() {
            return "VariableToDeclare{Type=" + this._type + ", Name='" + this._name + '\'' + ", Variable=" + this._variable + ", InsertionPoint=" + this._insertionPoint + ", ReplacedAssignment=" + this._replacedAssignment + '}';
        }
    }

    private static final class AnalysisResult {
        final boolean isAssigned;
        final boolean isSingleAssignment;
        final boolean needsInitializer;

        private AnalysisResult(boolean isAssigned, boolean singleAssignment, boolean needsInitializer) {
            this.isAssigned = isAssigned;
            this.isSingleAssignment = singleAssignment;
            this.needsInitializer = needsInitializer;
        }
    }
}

