/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.nio.charset.Charset;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

final class NIORefusePacket
extends NIOPacket {
    int userReason;
    int systemReason;
    String refuseData;

    NIORefusePacket(NIOHeader header, SessionAtts session) throws IOException {
        super(header, session);
    }

    @Override
    void readPayloadBuffer() throws IOException, NetException {
        this.userReason = this.session.payloadBufferForRead.get();
        this.systemReason = this.session.payloadBufferForRead.get();
        short refuseDataLen = this.session.payloadBufferForRead.getShort();
        if (refuseDataLen > 0) {
            byte[] data = null;
            if (this.session.payloadBufferForRead.limit() > this.session.payloadBufferForRead.position()) {
                data = new byte[refuseDataLen];
                this.session.payloadBufferForRead.get(data);
            } else {
                data = this.session.dataChannel.readPayloadDataFromSocketChannel(refuseDataLen);
            }
            this.refuseData = new String(data, Charset.forName("US-ASCII"));
        } else {
            this.refuseData = "";
        }
    }
}

