/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting;

import java.util.ArrayList;
import java.util.List;
import org.directwebremoting.io.StringWrapper;

public class ScriptBuffer {
    private final List<Object> parts = new ArrayList<Object>();

    public ScriptBuffer() {
    }

    public ScriptBuffer(String str) {
        this.appendScript(str);
    }

    public ScriptBuffer appendAll(ScriptBuffer buffer) {
        for (Object part : buffer.parts) {
            this.parts.add(part);
        }
        return this;
    }

    public ScriptBuffer appendScript(String str) {
        this.parts.add(new StringWrapper(str));
        return this;
    }

    public ScriptBuffer appendData(boolean b) {
        Boolean data = b ? Boolean.TRUE : Boolean.FALSE;
        this.parts.add(data);
        return this;
    }

    public ScriptBuffer appendData(char c) {
        this.parts.add(Character.valueOf(c));
        return this;
    }

    public ScriptBuffer appendData(double d) {
        this.parts.add(d);
        return this;
    }

    public ScriptBuffer appendData(float f) {
        this.parts.add(Float.valueOf(f));
        return this;
    }

    public ScriptBuffer appendData(int i) {
        this.parts.add(i);
        return this;
    }

    public ScriptBuffer appendData(long l) {
        this.parts.add(l);
        return this;
    }

    public ScriptBuffer appendData(Object obj) {
        this.parts.add(obj);
        return this;
    }

    public ScriptBuffer appendData(String str) {
        this.parts.add(str);
        return this;
    }

    public ScriptBuffer appendCall(String funcName, Object ... params) {
        this.appendScript(funcName);
        this.appendScript("(");
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.appendScript(",");
            }
            this.appendData(params[i]);
        }
        this.appendScript(");");
        return this;
    }

    public String toString() {
        return this.parts.toString();
    }

    public List<?> getParts() {
        return this.parts;
    }
}

