/* SPDX-FileCopyrightText: 2005-2007 - Paolo Maggi
 * SPDX-FileCopyrightText: 2007 - Steve Frécinaux
 * SPDX-FileCopyrightText: 2008 - Jesse van den Kieboom
 * SPDX-FileCopyrightText: 2014-2025 - Sébastien Wilmet
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtk/gtk.h>
#include <gtksourceview/gtksourcetypes.h>
#include <gtksourceview/gtksourcefile.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_FILE_LOADER              (gtk_source_file_loader_get_type())
#define GTK_SOURCE_FILE_LOADER(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), GTK_SOURCE_TYPE_FILE_LOADER, GtkSourceFileLoader))
#define GTK_SOURCE_FILE_LOADER_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), GTK_SOURCE_TYPE_FILE_LOADER, GtkSourceFileLoaderClass))
#define GTK_SOURCE_IS_FILE_LOADER(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), GTK_SOURCE_TYPE_FILE_LOADER))
#define GTK_SOURCE_IS_FILE_LOADER_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_FILE_LOADER))
#define GTK_SOURCE_FILE_LOADER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), GTK_SOURCE_TYPE_FILE_LOADER, GtkSourceFileLoaderClass))

typedef struct _GtkSourceFileLoader        GtkSourceFileLoader;
typedef struct _GtkSourceFileLoaderClass   GtkSourceFileLoaderClass;
typedef struct _GtkSourceFileLoaderPrivate GtkSourceFileLoaderPrivate;

#define GTK_SOURCE_FILE_LOADER_ERROR (gtk_source_file_loader_error_quark())

/**
 * GtkSourceFileLoaderError:
 * @GTK_SOURCE_FILE_LOADER_ERROR_TOO_BIG: The file is too big.
 * @GTK_SOURCE_FILE_LOADER_ERROR_ENCODING_AUTO_DETECTION_FAILED: It is not
 *   possible to detect the encoding automatically.
 * @GTK_SOURCE_FILE_LOADER_ERROR_CONVERSION_FALLBACK: There was an encoding
 *   conversion error and it was needed to use a fallback character.
 *
 * An error code used with the %GTK_SOURCE_FILE_LOADER_ERROR domain.
 */
typedef enum
{
	GTK_SOURCE_FILE_LOADER_ERROR_TOO_BIG,
	GTK_SOURCE_FILE_LOADER_ERROR_ENCODING_AUTO_DETECTION_FAILED,
	GTK_SOURCE_FILE_LOADER_ERROR_CONVERSION_FALLBACK,
} GtkSourceFileLoaderError;

struct _GtkSourceFileLoader
{
	GObject parent;

	GtkSourceFileLoaderPrivate *priv;
};

struct _GtkSourceFileLoaderClass
{
	GObjectClass parent_class;

	gpointer padding[1];
};

G_MODULE_EXPORT
GType			gtk_source_file_loader_get_type			(void) G_GNUC_CONST;

G_MODULE_EXPORT
GQuark			gtk_source_file_loader_error_quark		(void);

G_MODULE_EXPORT
GtkSourceFileLoader *	gtk_source_file_loader_new			(GtkSourceBuffer *buffer,
									 GtkSourceFile   *file);

G_MODULE_EXPORT
GtkSourceFileLoader *	gtk_source_file_loader_new_from_stream		(GtkSourceBuffer *buffer,
									 GtkSourceFile   *file,
									 GInputStream    *stream);

G_MODULE_EXPORT
void			gtk_source_file_loader_set_candidate_encodings	(GtkSourceFileLoader *loader,
									 GSList              *candidate_encodings);

G_MODULE_EXPORT
guint64			gtk_source_file_loader_get_max_size		(GtkSourceFileLoader *loader);

G_MODULE_EXPORT
void			gtk_source_file_loader_set_max_size		(GtkSourceFileLoader *loader,
									 guint64              max_size);

G_MODULE_EXPORT
GtkSourceBuffer *	gtk_source_file_loader_get_buffer		(GtkSourceFileLoader *loader);

G_MODULE_EXPORT
GtkSourceFile *		gtk_source_file_loader_get_file			(GtkSourceFileLoader *loader);

G_MODULE_EXPORT
GFile *			gtk_source_file_loader_get_location		(GtkSourceFileLoader *loader);

G_MODULE_EXPORT
GInputStream *		gtk_source_file_loader_get_input_stream		(GtkSourceFileLoader *loader);

G_MODULE_EXPORT
void			gtk_source_file_loader_load_async		(GtkSourceFileLoader   *loader,
									 gint                   io_priority,
									 GCancellable          *cancellable,
									 GFileProgressCallback  progress_callback,
									 gpointer               progress_callback_data,
									 GDestroyNotify         progress_callback_notify,
									 GAsyncReadyCallback    callback,
									 gpointer               user_data);

G_MODULE_EXPORT
gboolean		gtk_source_file_loader_load_finish		(GtkSourceFileLoader  *loader,
									 GAsyncResult         *result,
									 GError              **error);

G_MODULE_EXPORT
const GtkSourceEncoding *gtk_source_file_loader_get_encoding		(GtkSourceFileLoader *loader);

G_MODULE_EXPORT
GtkSourceNewlineType	gtk_source_file_loader_get_newline_type		(GtkSourceFileLoader *loader);

G_MODULE_EXPORT
GtkSourceCompressionType gtk_source_file_loader_get_compression_type	(GtkSourceFileLoader *loader);

G_END_DECLS
