/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class CompositeMaterials extends Resource {

	public CompositeMaterials(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the count of Composite-s in the CompositeMaterials.
	 *
	 * @return returns the count of Composite-s
	 * @throws Lib3MFException
	 */
	public int getCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_compositematerials_getcount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getInt(0);
	}

	/**
	 * returns all the PropertyIDs of all Composite-Mixing Values in this CompositeMaterials
	 *
	 * @return PropertyID of the Composite-Mixing Values in the CompositeMaterials.
	 * @throws Lib3MFException
	 */
	public int[] getAllPropertyIDs() throws Lib3MFException {
		Pointer countNeededPropertyIDs = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_compositematerials_getallpropertyids.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededPropertyIDs, Pointer.NULL}));
		long countPropertyIDs = countNeededPropertyIDs.getLong(0);
		Pointer bufferPropertyIDs = new Memory(Math.max(1, 4 * countPropertyIDs));
		mWrapper.checkError(this, mWrapper.lib3mf_compositematerials_getallpropertyids.invokeInt(new java.lang.Object[]{mHandle, countPropertyIDs, countNeededPropertyIDs, bufferPropertyIDs}));
		return bufferPropertyIDs.getIntArray(0, (int)countPropertyIDs);
	}

	/**
	 * Obtains the BaseMaterialGroup instance of this CompositeMaterials.
	 *
	 * @return returns the BaseMaterialGroup instance of this CompositeMaterials
	 * @throws Lib3MFException
	 */
	public BaseMaterialGroup getBaseMaterialGroup() throws Lib3MFException {
		Pointer bufferBaseMaterialGroupInstance = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_compositematerials_getbasematerialgroup.invokeInt(new java.lang.Object[]{mHandle, bufferBaseMaterialGroupInstance}));
		Pointer valueBaseMaterialGroupInstance = bufferBaseMaterialGroupInstance.getPointer(0);
		BaseMaterialGroup baseMaterialGroupInstance = null;
		if (valueBaseMaterialGroupInstance == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "BaseMaterialGroupInstance was a null pointer");
		}
		baseMaterialGroupInstance = mWrapper.PolymorphicFactory(valueBaseMaterialGroupInstance, BaseMaterialGroup.class);
		return baseMaterialGroupInstance;
	}

	/**
	 * Adds a new Composite-Mixing Values to the CompositeMaterials.
	 *
	 * @param composite The Composite Constituents to be added as composite
	 * @return returns new PropertyID of the new Composite in the CompositeMaterials.
	 * @throws Lib3MFException
	 */
	public int addComposite(CompositeConstituent[] composite) throws Lib3MFException {
		Pointer bufferComposite = new Memory(Math.max(1, CompositeConstituent.SIZE * composite.length));
		for (int i = 0; i < composite.length; i++) {
		  composite[i].writeToPointer(bufferComposite, i * CompositeConstituent.SIZE);
		}
		Pointer bufferPropertyID = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_compositematerials_addcomposite.invokeInt(new java.lang.Object[]{mHandle, (long) composite.length, bufferComposite, bufferPropertyID}));
		return bufferPropertyID.getInt(0);
	}

	/**
	 * Removes a Composite-Maxing Ratio from the CompositeMaterials.
	 *
	 * @param propertyID PropertyID of the  Composite-Mixing Values in the CompositeMaterials to be removed.
	 * @throws Lib3MFException
	 */
	public void removeComposite(int propertyID) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_compositematerials_removecomposite.invokeInt(new java.lang.Object[]{mHandle, propertyID}));
	}

	/**
	 * Obtains a Composite-Maxing Ratio of this CompositeMaterials.
	 *
	 * @param propertyID the PropertyID of the Composite-Maxing Ratio in the CompositeMaterials.
	 * @return The Composite-Mixing Values with the given PropertyID
	 * @throws Lib3MFException
	 */
	public CompositeConstituent[] getComposite(int propertyID) throws Lib3MFException {
		Pointer countNeededComposite = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_compositematerials_getcomposite.invokeInt(new java.lang.Object[]{mHandle, propertyID, 0L, countNeededComposite, null}));
		long countComposite = countNeededComposite.getLong(0);
		Pointer bufferComposite = new Memory(Math.max(1, countComposite * CompositeConstituent.SIZE));
		mWrapper.checkError(this, mWrapper.lib3mf_compositematerials_getcomposite.invokeInt(new java.lang.Object[]{mHandle, propertyID, countComposite, countNeededComposite, bufferComposite}));
		CompositeConstituent composite[] = new CompositeConstituent[(int)countComposite];
		for (int i = 0; i < (int)countComposite; i++) {
		  composite[i] = new CompositeConstituent();
		  composite[i].readFromPointer(bufferComposite, i * CompositeConstituent.SIZE);
		}
		return composite;
	}


}

