/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.netty.buffer.ByteBuf;
import io.undertow.UndertowMessages;
import io.undertow.httpcore.ClientAuth;
import io.undertow.httpcore.SSLSessionInfo;
import io.undertow.util.FlexBase64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Iterator;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public class BasicSSLSessionInfo
implements SSLSessionInfo {
    private final byte[] sessionId;
    private final String cypherSuite;
    private final Certificate[] peerCertificate;
    private final X509Certificate[] certificate;

    public BasicSSLSessionInfo(byte[] sessionId, String cypherSuite, String certificate) throws java.security.cert.CertificateException, CertificateException {
        this.sessionId = sessionId;
        this.cypherSuite = cypherSuite;
        if (certificate != null) {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            byte[] certificateBytes = certificate.getBytes(StandardCharsets.US_ASCII);
            ByteArrayInputStream stream = new ByteArrayInputStream(certificateBytes);
            Collection<? extends Certificate> certCol = cf.generateCertificates(stream);
            this.peerCertificate = new Certificate[certCol.size()];
            this.certificate = new X509Certificate[certCol.size()];
            int i = 0;
            Iterator<? extends Certificate> iterator = certCol.iterator();
            while (iterator.hasNext()) {
                Certificate cert;
                this.peerCertificate[i] = cert = iterator.next();
                this.certificate[i++] = X509Certificate.getInstance(cert.getEncoded());
            }
        } else {
            this.peerCertificate = null;
            this.certificate = null;
        }
    }

    public BasicSSLSessionInfo(String sessionId, String cypherSuite, String certificate) throws java.security.cert.CertificateException, CertificateException {
        this(sessionId == null ? null : BasicSSLSessionInfo.base64Decode(sessionId), cypherSuite, certificate);
    }

    public byte[] getSessionId() {
        if (this.sessionId == null) {
            return null;
        }
        byte[] copy = new byte[this.sessionId.length];
        System.arraycopy(this.sessionId, 0, copy, 0, copy.length);
        return copy;
    }

    public String getCipherSuite() {
        return this.cypherSuite;
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.certificate == null) {
            throw UndertowMessages.MESSAGES.peerUnverified();
        }
        return this.peerCertificate;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.certificate == null) {
            throw UndertowMessages.MESSAGES.peerUnverified();
        }
        return this.certificate;
    }

    public void renegotiate(ClientAuth sslClientAuthMode) throws IOException {
        throw UndertowMessages.MESSAGES.renegotiationNotSupported();
    }

    public SSLSession getSSLSession() {
        return null;
    }

    private static byte[] base64Decode(String sessionId) {
        try {
            byte[] sessionIdData;
            ByteBuf sessionIdBuffer = FlexBase64.decode(sessionId);
            if (sessionIdBuffer.hasArray()) {
                sessionIdData = sessionIdBuffer.array();
            } else {
                sessionIdData = new byte[sessionIdBuffer.readableBytes()];
                sessionIdBuffer.readBytes(sessionIdData);
            }
            return sessionIdData;
        }
        catch (IOException e) {
            return null;
        }
    }
}

