/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.Property;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyIndexBackRefImpl;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.PropertyAccessStrategy;

class PropertyAccessHelper {
    PropertyAccessHelper() {
    }

    static PropertyAccessStrategy propertyAccessStrategy(Property bootAttributeDescriptor, Class<?> mappedClass, StrategySelector strategySelector) {
        PropertyAccessStrategy strategy = bootAttributeDescriptor.getPropertyAccessStrategy(mappedClass);
        if (strategy != null) {
            return strategy;
        }
        String propertyAccessorName = bootAttributeDescriptor.getPropertyAccessorName();
        if (StringHelper.isNotEmpty(propertyAccessorName)) {
            return strategySelector.resolveStrategy(PropertyAccessStrategy.class, propertyAccessorName);
        }
        if (bootAttributeDescriptor instanceof Backref) {
            Backref backref = (Backref)bootAttributeDescriptor;
            return new PropertyAccessStrategyBackRefImpl(backref.getCollectionRole(), backref.getEntityName());
        }
        if (bootAttributeDescriptor instanceof IndexBackref) {
            IndexBackref indexBackref = (IndexBackref)bootAttributeDescriptor;
            return new PropertyAccessStrategyIndexBackRefImpl(indexBackref.getCollectionRole(), indexBackref.getEntityName());
        }
        return BuiltInPropertyAccessStrategies.MIXED.getStrategy();
    }
}

