/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/InlineClassDescriptorResolver;", "", "<init>", "()V", "BOX_METHOD_NAME", "Lorg/jetbrains/kotlin/name/Name;", "UNBOX_METHOD_NAME", "SPECIALIZED_EQUALS_NAME", "BOXING_VALUE_PARAMETER_NAME", "getBOXING_VALUE_PARAMETER_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME", "getSPECIALIZED_EQUALS_FIRST_PARAMETER_NAME", "SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME", "getSPECIALIZED_EQUALS_SECOND_PARAMETER_NAME", "isSynthesizedBoxMethod", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isSynthesizedUnboxMethod", "isSynthesizedBoxOrUnboxMethod", "isSpecializedEqualsMethod", "isSynthesizedInlineClassMemberWithName", "name", "isSynthesizedInlineClassMember", "frontend"})
public final class InlineClassDescriptorResolver {
    @NotNull
    public static final InlineClassDescriptorResolver INSTANCE = new InlineClassDescriptorResolver();
    @JvmField
    @NotNull
    public static final Name BOX_METHOD_NAME;
    @JvmField
    @NotNull
    public static final Name UNBOX_METHOD_NAME;
    @JvmField
    @NotNull
    public static final Name SPECIALIZED_EQUALS_NAME;
    @NotNull
    private static final Name BOXING_VALUE_PARAMETER_NAME;
    @NotNull
    private static final Name SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME;
    @NotNull
    private static final Name SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME;

    private InlineClassDescriptorResolver() {
    }

    @NotNull
    public final Name getBOXING_VALUE_PARAMETER_NAME() {
        return BOXING_VALUE_PARAMETER_NAME;
    }

    @NotNull
    public final Name getSPECIALIZED_EQUALS_FIRST_PARAMETER_NAME() {
        return SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME;
    }

    @NotNull
    public final Name getSPECIALIZED_EQUALS_SECOND_PARAMETER_NAME() {
        return SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME;
    }

    @JvmStatic
    public static final boolean isSynthesizedBoxMethod(@NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return INSTANCE.isSynthesizedInlineClassMemberWithName(descriptor, BOX_METHOD_NAME);
    }

    @JvmStatic
    public static final boolean isSynthesizedUnboxMethod(@NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return INSTANCE.isSynthesizedInlineClassMemberWithName(descriptor, UNBOX_METHOD_NAME);
    }

    @JvmStatic
    public static final boolean isSynthesizedBoxOrUnboxMethod(@NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return INSTANCE.isSynthesizedInlineClassMember(descriptor) && (Intrinsics.areEqual((Object)descriptor.getName(), (Object)BOX_METHOD_NAME) || Intrinsics.areEqual((Object)descriptor.getName(), (Object)UNBOX_METHOD_NAME));
    }

    @JvmStatic
    public static final boolean isSpecializedEqualsMethod(@NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return INSTANCE.isSynthesizedInlineClassMemberWithName(descriptor, SPECIALIZED_EQUALS_NAME);
    }

    private final boolean isSynthesizedInlineClassMemberWithName(CallableMemberDescriptor descriptor, Name name2) {
        return this.isSynthesizedInlineClassMember(descriptor) && Intrinsics.areEqual((Object)descriptor.getName(), (Object)name2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSynthesizedInlineClassMember(CallableMemberDescriptor descriptor) {
        if (descriptor.getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED) return false;
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        if (!InlineClassesUtilsKt.isInlineClass(declarationDescriptor)) return false;
        return true;
    }

    static {
        Name name2 = Name.identifier("box");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        BOX_METHOD_NAME = name2;
        Name name3 = Name.identifier("unbox");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        UNBOX_METHOD_NAME = name3;
        Name name4 = Name.identifier("equals-impl0");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        SPECIALIZED_EQUALS_NAME = name4;
        Name name5 = Name.identifier("v");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(...)");
        BOXING_VALUE_PARAMETER_NAME = name5;
        Name name6 = Name.identifier("p1");
        Intrinsics.checkNotNullExpressionValue((Object)name6, (String)"identifier(...)");
        SPECIALIZED_EQUALS_FIRST_PARAMETER_NAME = name6;
        Name name7 = Name.identifier("p2");
        Intrinsics.checkNotNullExpressionValue((Object)name7, (String)"identifier(...)");
        SPECIALIZED_EQUALS_SECOND_PARAMETER_NAME = name7;
    }
}

