/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.AbstractBuffer;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.LongObjectHashMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public class PointerBuffer
extends AbstractBuffer<PointerBuffer> {
    protected LongObjectHashMap dataMap = null;

    static PointerBuffer create(ByteBuffer byteBuffer) {
        return Platform.is32Bit() ? new PointerBuffer(byteBuffer.asIntBuffer()) : new PointerBuffer(byteBuffer.asLongBuffer());
    }

    PointerBuffer(IntBuffer intBuffer) {
        super(intBuffer, POINTER_SIZE, intBuffer.capacity());
    }

    PointerBuffer(LongBuffer longBuffer) {
        super(longBuffer, POINTER_SIZE, longBuffer.capacity());
    }

    private final void validateDataMap() {
        if (null == this.dataMap) {
            this.dataMap = new LongObjectHashMap();
            this.dataMap.setKeyNotFoundValue(null);
        }
    }

    public static PointerBuffer allocate(int n) {
        if (Platform.is32Bit()) {
            return new PointerBuffer(IntBuffer.wrap(new int[n]));
        }
        return new PointerBuffer(LongBuffer.wrap(new long[n]));
    }

    public static PointerBuffer allocateDirect(int n) {
        return PointerBuffer.create(Buffers.newDirectByteBuffer(POINTER_SIZE * n));
    }

    public static PointerBuffer wrap(ByteBuffer byteBuffer) {
        return PointerBuffer.create(byteBuffer);
    }

    public static PointerBuffer wrap(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        byteBuffer.position(n);
        byteBuffer.limit(n + POINTER_SIZE * n2);
        ByteBuffer byteBuffer2 = byteBuffer.slice().order(byteBuffer.order());
        byteBuffer.position(n3);
        byteBuffer.limit(n4);
        return PointerBuffer.create(byteBuffer2);
    }

    public static PointerBuffer derefPointer(long l, int n) {
        if (0L == l) {
            throw new NullPointerException("aptr is null");
        }
        ByteBuffer byteBuffer = Buffers.getDirectByteBuffer(l, n * POINTER_SIZE);
        if (null == byteBuffer) {
            throw new InternalError("Couldn't dereference aptr 0x" + Long.toHexString(l) + ", size " + n + " * " + POINTER_SIZE);
        }
        return PointerBuffer.create(byteBuffer);
    }

    public static PointerBuffer derefPointer(ByteBuffer byteBuffer, int n, int n2) {
        return PointerBuffer.derefPointer(PointerBuffer.wrap(byteBuffer, n, 1).get(0), n2);
    }

    public final PointerBuffer duplicate() {
        PointerBuffer pointerBuffer = Platform.is32Bit() ? new PointerBuffer((IntBuffer)this.buffer) : new PointerBuffer((LongBuffer)this.buffer);
        if (null != this.dataMap) {
            pointerBuffer.dataMap = (LongObjectHashMap)this.dataMap.clone();
        }
        pointerBuffer.position = this.position;
        return pointerBuffer;
    }

    @Override
    public final PointerBuffer put(PointerBuffer pointerBuffer) {
        if (this.remaining() < pointerBuffer.remaining()) {
            throw new IndexOutOfBoundsException("remaining[this " + this.remaining() + " < src " + pointerBuffer.remaining() + "], this " + this + ", src " + pointerBuffer);
        }
        if (null == pointerBuffer.dataMap && null == this.dataMap) {
            while (pointerBuffer.hasRemaining()) {
                this.put(pointerBuffer.get());
            }
        } else {
            while (pointerBuffer.hasRemaining()) {
                long l = pointerBuffer.get();
                this.put(l);
                if (null != pointerBuffer.dataMap) {
                    Buffer buffer = (Buffer)pointerBuffer.dataMap.get(l);
                    if (null != buffer) {
                        this.validateDataMap();
                        this.dataMap.put(l, buffer);
                        continue;
                    }
                    if (null == this.dataMap) continue;
                    this.dataMap.remove(l);
                    continue;
                }
                if (null == this.dataMap) continue;
                this.dataMap.remove(l);
            }
        }
        return this;
    }

    public final long get(int n) {
        if (0 > n || n >= this.limit()) {
            throw new IndexOutOfBoundsException("idx " + n + " not within [0.." + this.limit() + "), " + this);
        }
        if (Platform.is32Bit()) {
            return (long)((IntBuffer)this.buffer).get(n) & 0xFFFFFFFFL;
        }
        return ((LongBuffer)this.buffer).get(n);
    }

    public final long get() {
        long l = this.get(this.position);
        ++this.position;
        return l;
    }

    public final PointerBuffer get(int n, long[] lArray, int n2, int n3) {
        if (0 > n || n + n3 > this.limit() || 0 > n3 || 0 > n2 || n2 + n3 > lArray.length) {
            throw new IndexOutOfBoundsException("destElemPos " + n2 + ", srcElemPos " + n + ", elemCount " + n3 + ", srcLimit " + this.limit() + ", destLimit " + lArray.length + ", " + this);
        }
        if (Platform.is32Bit()) {
            IntBuffer intBuffer = (IntBuffer)this.buffer;
            for (int i = 0; i < n3; ++i) {
                lArray[n2 + i] = (long)intBuffer.get(n + i) & 0xFFFFFFFFL;
            }
        } else {
            LongBuffer longBuffer = (LongBuffer)this.buffer;
            int n4 = longBuffer.limit();
            int n5 = longBuffer.position();
            longBuffer.position(n).limit(n + n3);
            longBuffer.get(lArray, n2, n3);
            longBuffer.limit(n4).position(n5);
        }
        return this;
    }

    public final PointerBuffer get(long[] lArray, int n, int n2) {
        this.get(this.position, lArray, n, n2);
        this.position += n2;
        return this;
    }

    public final PointerBuffer put(int n, long l) {
        if (0 > n || n >= this.limit()) {
            throw new IndexOutOfBoundsException("idx " + n + " not within [0.." + this.limit() + "), " + this);
        }
        if (Platform.is32Bit()) {
            ((IntBuffer)this.buffer).put(n, (int)l);
        } else {
            ((LongBuffer)this.buffer).put(n, l);
        }
        return this;
    }

    @Override
    public final PointerBuffer put(long l) {
        this.put(this.position, l);
        ++this.position;
        return this;
    }

    public final PointerBuffer put(long[] lArray, int n, int n2, int n3) {
        if (0 > n2 || n2 + n3 > this.limit() || 0 > n3 || 0 > n || n + n3 > lArray.length) {
            throw new IndexOutOfBoundsException("srcElemPos " + n + ", destElemPos " + n2 + ", elemCount " + n3 + ", destLimit " + this.limit() + ", srcLimit " + lArray.length + ", " + this);
        }
        if (Platform.is32Bit()) {
            IntBuffer intBuffer = (IntBuffer)this.buffer;
            for (int i = 0; i < n3; ++i) {
                intBuffer.put(n2 + i, (int)lArray[n + i]);
            }
        } else {
            LongBuffer longBuffer = (LongBuffer)this.buffer;
            int n4 = longBuffer.limit();
            int n5 = longBuffer.position();
            longBuffer.position(n2).limit(n2 + n3);
            longBuffer.put(lArray, n, n3);
            longBuffer.limit(n4).position(n5);
        }
        return this;
    }

    public final PointerBuffer put(long[] lArray, int n, int n2) {
        this.put(lArray, n, this.position, n2);
        this.position += n2;
        return this;
    }

    public final PointerBuffer referenceBuffer(int n, Buffer buffer) {
        if (null == buffer) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Buffer is not direct");
        }
        long l = Platform.is32Bit() ? 0xFFFFFFFFL : -1L;
        long l2 = Buffers.getDirectBufferAddressImpl(buffer) & l;
        if (0L == l2) {
            throw new RuntimeException("Couldn't determine native address of given Buffer: " + buffer);
        }
        this.validateDataMap();
        this.put(n, l2);
        this.dataMap.put(l2, buffer);
        return this;
    }

    public final PointerBuffer referenceBuffer(Buffer buffer) {
        this.referenceBuffer(this.position, buffer);
        ++this.position;
        return this;
    }

    public final Buffer getReferencedBuffer(int n) {
        if (null != this.dataMap) {
            long l = this.get(n);
            return (Buffer)this.dataMap.get(l);
        }
        return null;
    }

    public final Buffer getReferencedBuffer() {
        Buffer buffer = this.getReferencedBuffer(this.position);
        ++this.position;
        return buffer;
    }

    @Override
    public String toString() {
        return "PointerBuffer" + this.toSubString();
    }
}

