# arp-scan from https://github.com/royhills/arp-scan

complete -c arp-scan -x

complete -c arp-scan -l help -s h -d 'Display usage message and exit'
complete -c arp-scan -l verbose -s v -d 'Display verbose progress messages'
complete -c arp-scan -l version -s V -d 'Display program version and exit'
complete -c arp-scan -l interface -s I -xa "(__fish_print_interfaces)" -d 'Use network interface'
complete -c arp-scan -l file -s f -rF -d 'Read hostnames or addresses from file'
complete -c arp-scan -l localnet -s l -d 'Generate addresses from interface configuration'
complete -c arp-scan -l ouifile -s O -rF -d 'Use specified IEEE registry vendor mapping file'
complete -c arp-scan -l macfile -s m -rF -d 'Use custom vendor mapping file'
complete -c arp-scan -l quiet -s q -d 'Display minimal output for each responding host'
complete -c arp-scan -l plain -s x -d 'Supress header and footer text'
complete -c arp-scan -l ignoredups -s g -d 'Don\'t display duplicate packets'
complete -c arp-scan -l rtt -s D -d 'Calculate and display packet round-trip time'
complete -c arp-scan -l format -s F -x -d 'Specify the output format string'
complete -c arp-scan -l random -s R -d 'Randomise the target host list'
complete -c arp-scan -l randomseed -x -d 'Seed the pseudo random number generator'
complete -c arp-scan -l retry -s r -x -d 'Set total number of attempts per host'
complete -c arp-scan -l backoff -s b -x -d 'Set backoff factor'
complete -c arp-scan -l timeout -s t -x -d 'Set initial per host timeout'
complete -c arp-scan -l interval -s i -x -d 'Set minimum packet interval'
complete -c arp-scan -l bandwidth -s B -x -d 'Set outbound bandwidth'
complete -c arp-scan -l numeric -s N -d 'Targets must be IP addresses, not hostnames'
complete -c arp-scan -l resolve -s d -d 'Resolve responding addresses to hostnames'
complete -c arp-scan -l arpsha -s u -x -d 'Set the ARP source Ethernet address'
complete -c arp-scan -l arptha -s w -x -d 'Set the ARP target Ethernet address'
complete -c arp-scan -l arphrd -s H -x -d 'Set the ARP hardware type'
complete -c arp-scan -l arppro -s p -x -d 'Set the ARP protocol type'
complete -c arp-scan -l arphln -s a -x -d 'Set the hardware address length'
complete -c arp-scan -l arppln -s P -x -d 'Set the protocol address length'
complete -c arp-scan -l arpop -s o -x -d 'Specify the ARP operation'
complete -c arp-scan -l arpspa -s s -x -d 'Set the source IPv4 address'
complete -c arp-scan -l srcaddr -s S -x -d 'Set the source Ethernet MAC address'
complete -c arp-scan -l destaddr -s T -x -d 'Set the destination MAC address'
complete -c arp-scan -l prototype -s y -x -d 'Sets the Ethernet protocol type'
complete -c arp-scan -l llc -s L -d 'Use RFC 1042 LLC/SNAP encapsulation for 802.2 networks'
complete -c arp-scan -l vlan -s Q -x -d 'Use 802.1Q tagging with specified VLAN id'
complete -c arp-scan -l limit -s M -x -d 'Exit after the specified number of hosts have responded'
complete -c arp-scan -l pcapsavefile -s W -rF -d 'Write received packets to pcap savefile'
complete -c arp-scan -l snap -s n -x -d 'Set the pcap snap length'
complete -c arp-scan -l retry-send -s Y -x -d 'Set number of send attempts'
complete -c arp-scan -l retry-send-interval -s E -x -d 'Set interval between send attempts'
complete -c arp-scan -l padding -s A -x -d 'Specify padding after packet data'
