!function(){"use strict";var document,registry,crossOriginUpdater,crossOriginRect;function getFrameElement(doc){try{return doc.defaultView&&doc.defaultView.frameElement||null}catch(e){return null}}function IntersectionObserverEntry(entry){this.time=entry.time,this.target=entry.target,this.rootBounds=ensureDOMRect(entry.rootBounds),this.boundingClientRect=ensureDOMRect(entry.boundingClientRect),this.intersectionRect=ensureDOMRect(entry.intersectionRect||getEmptyRect()),this.isIntersecting=!!entry.intersectionRect;var entry=this.boundingClientRect,entry=entry.width*entry.height,intersectionRect=this.intersectionRect,intersectionRect=intersectionRect.width*intersectionRect.height;this.intersectionRatio=entry?Number((intersectionRect/entry).toFixed(4)):this.isIntersecting?1:0}function IntersectionObserver(callback,opt_options){var fn,timeout,timer,opt_options=opt_options||{};if("function"!=typeof callback)throw new Error("callback must be a function");if(opt_options.root&&1!=opt_options.root.nodeType&&9!=opt_options.root.nodeType)throw new Error("root must be a Document or Element");this._checkForIntersections=(fn=this._checkForIntersections.bind(this),timeout=this.THROTTLE_TIMEOUT,timer=null,function(){timer=timer||setTimeout(function(){fn(),timer=null},timeout)}),this._callback=callback,this._observationTargets=[],this._queuedEntries=[],this._rootMarginValues=this._parseRootMargin(opt_options.rootMargin),this.thresholds=this._initThresholds(opt_options.threshold),this.root=opt_options.root||null,this.rootMargin=this._rootMarginValues.map(function(margin){return margin.value+margin.unit}).join(" "),this._monitoringDocuments=[],this._monitoringUnsubscribes=[]}function addEvent(node,event,fn,opt_useCapture){"function"==typeof node.addEventListener?node.addEventListener(event,fn,opt_useCapture||!1):"function"==typeof node.attachEvent&&node.attachEvent("on"+event,fn)}function removeEvent(node,event,fn,opt_useCapture){"function"==typeof node.removeEventListener?node.removeEventListener(event,fn,opt_useCapture||!1):"function"==typeof node.detatchEvent&&node.detatchEvent("on"+event,fn)}function getBoundingClientRect(el){var rect;try{rect=el.getBoundingClientRect()}catch(err){}return rect?rect.width&&rect.height?rect:{top:rect.top,right:rect.right,bottom:rect.bottom,left:rect.left,width:rect.right-rect.left,height:rect.bottom-rect.top}:getEmptyRect()}function getEmptyRect(){return{top:0,bottom:0,left:0,right:0,width:0,height:0}}function ensureDOMRect(rect){return!rect||"x"in rect?rect:{top:rect.top,y:rect.top,bottom:rect.bottom,left:rect.left,x:rect.left,right:rect.right,width:rect.width,height:rect.height}}function convertFromParentRect(parentBoundingRect,parentIntersectionRect){var top=parentIntersectionRect.top-parentBoundingRect.top,parentBoundingRect=parentIntersectionRect.left-parentBoundingRect.left;return{top:top,left:parentBoundingRect,height:parentIntersectionRect.height,width:parentIntersectionRect.width,bottom:top+parentIntersectionRect.height,right:parentBoundingRect+parentIntersectionRect.width}}function containsDeep(parent,child){for(var node=child;node;){if(node==parent)return!0;node=getParentNode(node)}return!1}function getParentNode(node){var parent=node.parentNode;return 9==node.nodeType&&node!=document?getFrameElement(node):(parent=parent&&parent.assignedSlot?parent.assignedSlot.parentNode:parent)&&11==parent.nodeType&&parent.host?parent.host:parent}function isDoc(node){return node&&9===node.nodeType}"object"==typeof window&&("IntersectionObserver"in window&&"IntersectionObserverEntry"in window&&"intersectionRatio"in window.IntersectionObserverEntry.prototype?"isIntersecting"in window.IntersectionObserverEntry.prototype||Object.defineProperty(window.IntersectionObserverEntry.prototype,"isIntersecting",{get:function(){return 0<this.intersectionRatio}}):(document=function(){for(var doc=window.document,frame=getFrameElement(doc);frame;)frame=getFrameElement(doc=frame.ownerDocument);return doc}(),registry=[],crossOriginRect=crossOriginUpdater=null,IntersectionObserver.prototype.THROTTLE_TIMEOUT=100,IntersectionObserver.prototype.POLL_INTERVAL=null,IntersectionObserver.prototype.USE_MUTATION_OBSERVER=!1,IntersectionObserver._setupCrossOriginUpdater=function(){return crossOriginUpdater=crossOriginUpdater||function(boundingClientRect,intersectionRect){crossOriginRect=boundingClientRect&&intersectionRect?convertFromParentRect(boundingClientRect,intersectionRect):getEmptyRect(),registry.forEach(function(observer){observer._checkForIntersections()})}},IntersectionObserver._resetCrossOriginUpdater=function(){crossOriginRect=crossOriginUpdater=null},IntersectionObserver.prototype.observe=function(target){var isTargetAlreadyObserved=this._observationTargets.some(function(item){return item.element==target});if(!isTargetAlreadyObserved){if(!target||1!=target.nodeType)throw new Error("target must be an Element");this._registerInstance(),this._observationTargets.push({element:target,entry:null}),this._monitorIntersections(target.ownerDocument),this._checkForIntersections()}},IntersectionObserver.prototype.unobserve=function(target){this._observationTargets=this._observationTargets.filter(function(item){return item.element!=target}),this._unmonitorIntersections(target.ownerDocument),0==this._observationTargets.length&&this._unregisterInstance()},IntersectionObserver.prototype.disconnect=function(){this._observationTargets=[],this._unmonitorAllIntersections(),this._unregisterInstance()},IntersectionObserver.prototype.takeRecords=function(){var records=this._queuedEntries.slice();return this._queuedEntries=[],records},IntersectionObserver.prototype._initThresholds=function(opt_threshold){opt_threshold=opt_threshold||[0];return(opt_threshold=Array.isArray(opt_threshold)?opt_threshold:[opt_threshold]).sort().filter(function(t,i,a){if("number"!=typeof t||isNaN(t)||t<0||1<t)throw new Error("threshold must be a number between 0 and 1 inclusively");return t!==a[i-1]})},IntersectionObserver.prototype._parseRootMargin=function(opt_rootMargin){opt_rootMargin=(opt_rootMargin||"0px").split(/\s+/).map(function(margin){margin=/^(-?\d*\.?\d+)(px|%)$/.exec(margin);if(margin)return{value:parseFloat(margin[1]),unit:margin[2]};throw new Error("rootMargin must be specified in pixels or percent")});return opt_rootMargin[1]=opt_rootMargin[1]||opt_rootMargin[0],opt_rootMargin[2]=opt_rootMargin[2]||opt_rootMargin[0],opt_rootMargin[3]=opt_rootMargin[3]||opt_rootMargin[1],opt_rootMargin},IntersectionObserver.prototype._monitorIntersections=function(doc){var callback,monitoringInterval,domObserver,win=doc.defaultView;win&&-1==this._monitoringDocuments.indexOf(doc)&&(callback=this._checkForIntersections,domObserver=monitoringInterval=null,this.POLL_INTERVAL?monitoringInterval=win.setInterval(callback,this.POLL_INTERVAL):(addEvent(win,"resize",callback,!0),addEvent(win,"orientationchange",callback,!0),addEvent(doc,"scroll",callback,!0),this.USE_MUTATION_OBSERVER&&"MutationObserver"in win&&(domObserver=new win.MutationObserver(callback)).observe(doc,{attributes:!0,childList:!0,characterData:!0,subtree:!0})),this._monitoringDocuments.push(doc),this._monitoringUnsubscribes.push(function(){var win=doc.defaultView;win&&(monitoringInterval&&win.clearInterval(monitoringInterval),removeEvent(win,"resize",callback,!0),removeEvent(win,"orientationchange",callback,!0)),removeEvent(doc,"scroll",callback,!0),domObserver&&domObserver.disconnect()}),win=this.root&&(this.root.ownerDocument||this.root)||document,doc!=win)&&(win=getFrameElement(doc))&&this._monitorIntersections(win.ownerDocument)},IntersectionObserver.prototype._unmonitorIntersections=function(doc){var rootDoc,unsubscribe,index=this._monitoringDocuments.indexOf(doc);-1==index||(rootDoc=this.root&&(this.root.ownerDocument||this.root)||document,this._observationTargets.some(function(item){if((itemDoc=item.element.ownerDocument)==doc)return!0;for(;itemDoc&&itemDoc!=rootDoc;){var itemDoc,frame=getFrameElement(itemDoc);if((itemDoc=frame&&frame.ownerDocument)==doc)return!0}return!1}))||(unsubscribe=this._monitoringUnsubscribes[index],this._monitoringDocuments.splice(index,1),this._monitoringUnsubscribes.splice(index,1),unsubscribe(),doc!=rootDoc&&(index=getFrameElement(doc))&&this._unmonitorIntersections(index.ownerDocument))},IntersectionObserver.prototype._unmonitorAllIntersections=function(){var unsubscribes=this._monitoringUnsubscribes.slice(0);this._monitoringDocuments.length=0;for(var i=this._monitoringUnsubscribes.length=0;i<unsubscribes.length;i++)unsubscribes[i]()},IntersectionObserver.prototype._checkForIntersections=function(){var rootIsInDom,rootRect;(this.root||!crossOriginUpdater||crossOriginRect)&&(rootIsInDom=this._rootIsInDom(),rootRect=rootIsInDom?this._getRootRect():getEmptyRect(),this._observationTargets.forEach(function(item){var target=item.element,targetRect=getBoundingClientRect(target),rootContainsTarget=this._rootContainsTarget(target),oldEntry=item.entry,intersectionRect=rootIsInDom&&rootContainsTarget&&this._computeTargetAndRootIntersection(target,targetRect,rootRect),rootBounds=null,item=(this._rootContainsTarget(target)?crossOriginUpdater&&!this.root||(rootBounds=rootRect):rootBounds=getEmptyRect(),item.entry=new IntersectionObserverEntry({time:window.performance&&performance.now&&performance.now(),target:target,boundingClientRect:targetRect,rootBounds:rootBounds,intersectionRect:intersectionRect}));oldEntry?rootIsInDom&&rootContainsTarget?this._hasCrossedThreshold(oldEntry,item)&&this._queuedEntries.push(item):oldEntry&&oldEntry.isIntersecting&&this._queuedEntries.push(item):this._queuedEntries.push(item)},this),this._queuedEntries.length)&&this._callback(this.takeRecords(),this)},IntersectionObserver.prototype._computeTargetAndRootIntersection=function(target,targetRect,rootRect){if("none"!=window.getComputedStyle(target).display){for(var left,height,intersectionRect=targetRect,parent=getParentNode(target),atRoot=!1;!atRoot&&parent;){var frameRect,frameIntersect,frame,parentRect=null,parentComputedStyle=1==parent.nodeType?window.getComputedStyle(parent):{};if("none"==parentComputedStyle.display)return null;if(parent==this.root||9==parent.nodeType?(atRoot=!0,parent==this.root||parent==document?crossOriginUpdater&&!this.root?!crossOriginRect||0==crossOriginRect.width&&0==crossOriginRect.height?intersectionRect=parentRect=parent=null:parentRect=crossOriginRect:parentRect=rootRect:(frameRect=(frame=getParentNode(parent))&&getBoundingClientRect(frame),frameIntersect=frame&&this._computeTargetAndRootIntersection(frame,frameRect,rootRect),frameRect&&frameIntersect?(parent=frame,parentRect=convertFromParentRect(frameRect,frameIntersect)):intersectionRect=parent=null)):parent!=(frame=parent.ownerDocument).body&&parent!=frame.documentElement&&"visible"!=parentComputedStyle.overflow&&(parentRect=getBoundingClientRect(parent)),parentRect&&(frameRect=parentRect,frameIntersect=intersectionRect,height=left=parentRect=parentComputedStyle=void 0,parentComputedStyle=Math.max(frameRect.top,frameIntersect.top),parentRect=Math.min(frameRect.bottom,frameIntersect.bottom),left=Math.max(frameRect.left,frameIntersect.left),frameRect=Math.min(frameRect.right,frameIntersect.right),height=parentRect-parentComputedStyle,intersectionRect=0<=(frameIntersect=frameRect-left)&&0<=height?{top:parentComputedStyle,bottom:parentRect,left:left,right:frameRect,width:frameIntersect,height:height}:null),!intersectionRect)break;parent=parent&&getParentNode(parent)}return intersectionRect}},IntersectionObserver.prototype._getRootRect=function(){var doc,html;return html=this.root&&!isDoc(this.root)?getBoundingClientRect(this.root):(html=(doc=isDoc(this.root)?this.root:document).documentElement,doc=doc.body,{top:0,left:0,right:html.clientWidth||doc.clientWidth,width:html.clientWidth||doc.clientWidth,bottom:html.clientHeight||doc.clientHeight,height:html.clientHeight||doc.clientHeight}),this._expandRectByRootMargin(html)},IntersectionObserver.prototype._expandRectByRootMargin=function(rect){var margins=this._rootMarginValues.map(function(margin,i){return"px"==margin.unit?margin.value:margin.value*(i%2?rect.width:rect.height)/100}),margins={top:rect.top-margins[0],right:rect.right+margins[1],bottom:rect.bottom+margins[2],left:rect.left-margins[3]};return margins.width=margins.right-margins.left,margins.height=margins.bottom-margins.top,margins},IntersectionObserver.prototype._hasCrossedThreshold=function(oldEntry,newEntry){var oldRatio=oldEntry&&oldEntry.isIntersecting?oldEntry.intersectionRatio||0:-1,newRatio=newEntry.isIntersecting?newEntry.intersectionRatio||0:-1;if(oldRatio!==newRatio)for(var i=0;i<this.thresholds.length;i++){var threshold=this.thresholds[i];if(threshold==oldRatio||threshold==newRatio||threshold<oldRatio!=threshold<newRatio)return!0}},IntersectionObserver.prototype._rootIsInDom=function(){return!this.root||containsDeep(document,this.root)},IntersectionObserver.prototype._rootContainsTarget=function(target){var rootDoc=this.root&&(this.root.ownerDocument||this.root)||document;return containsDeep(rootDoc,target)&&(!this.root||rootDoc==target.ownerDocument)},IntersectionObserver.prototype._registerInstance=function(){registry.indexOf(this)<0&&registry.push(this)},IntersectionObserver.prototype._unregisterInstance=function(){var index=registry.indexOf(this);-1!=index&&registry.splice(index,1)},window.IntersectionObserver=IntersectionObserver,window.IntersectionObserverEntry=IntersectionObserverEntry))}();