/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.controls.VerticalButton;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentationPanel;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPropertyTester;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationPanelDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationRegistry;
import org.jkiss.utils.CommonUtils;

class ExtraPresentationManager {
    @NotNull
    private final SQLEditor owner;
    final Map<SQLPresentationDescriptor, SQLEditorPresentation> presentations = new LinkedHashMap<SQLPresentationDescriptor, SQLEditorPresentation>();
    final Map<SQLPresentationPanelDescriptor, SQLEditorPresentationPanel> panels = new HashMap<SQLPresentationPanelDescriptor, SQLEditorPresentationPanel>();
    final Map<SQLPresentationDescriptor, Integer> presentationStackIndices = new HashMap<SQLPresentationDescriptor, Integer>();
    SQLPresentationDescriptor activePresentationDescriptor;
    SQLEditorPresentation activePresentation;
    SQLEditorPresentationPanel activePresentationPanel;

    public ExtraPresentationManager(@NotNull SQLEditor owner) {
        this.owner = owner;
        for (SQLPresentationDescriptor presentation : SQLPresentationRegistry.getInstance().getPresentations()) {
            this.presentations.put(presentation, null);
            for (SQLPresentationPanelDescriptor panel : presentation.getPanels()) {
                this.panels.put(panel, null);
            }
        }
    }

    public boolean setActivePresentation(@Nullable SQLPresentationDescriptor descriptor) throws DBException {
        if (this.owner.getPresentationStack() == null || this.activePresentationDescriptor == descriptor) {
            return true;
        }
        if (this.activePresentation != null && !this.activePresentation.canHidePresentation(this.owner)) {
            return false;
        }
        if (descriptor == null) {
            this.activePresentationDescriptor = null;
            this.activePresentation = null;
            this.activePresentationPanel = null;
            SQLEditorPropertyTester.firePropertyChange("canExecute");
            return true;
        }
        SQLEditorPresentation presentation = this.presentations.get((Object)descriptor);
        if (presentation == null) {
            presentation = descriptor.createPresentation();
            if (presentation.canShowPresentation(this.owner, true)) {
                this.presentationStackIndices.put(descriptor, this.owner.getPresentationStack().getChildren().length);
                Composite placeholder = new Composite(this.owner.getPresentationStack(), 0);
                placeholder.setLayout((Layout)new FillLayout());
                if (this.activePresentation != null) {
                    this.activePresentation.hidePresentation(this.owner);
                }
                this.activePresentationDescriptor = descriptor;
                this.activePresentation = presentation;
                this.activePresentation.createPresentation(placeholder, this.owner);
                this.activePresentation.showPresentation(this.owner, true);
                this.presentations.put(descriptor, this.activePresentation);
                SQLEditorPropertyTester.firePropertyChange("canExecute");
                return true;
            }
        } else if (presentation.canShowPresentation(this.owner, false)) {
            if (this.activePresentation != null) {
                this.activePresentation.hidePresentation(this.owner);
            }
            this.activePresentationDescriptor = descriptor;
            this.activePresentation = presentation;
            this.activePresentation.showPresentation(this.owner, false);
            SQLEditorPropertyTester.firePropertyChange("canExecute");
            return true;
        }
        return false;
    }

    @Nullable
    Control getActivePresentationControl() {
        if (this.owner.getPresentationStack() == null || this.activePresentationDescriptor == null) {
            return null;
        }
        int index = this.presentationStackIndices.get((Object)this.activePresentationDescriptor);
        return this.owner.getPresentationStack().getChildren()[index];
    }

    @NotNull
    VerticalButton createPresentationButton(@NotNull SQLPresentationDescriptor presentation) {
        VerticalButton button = new VerticalButton(this.owner.getPresentationSwitchFolder(), 131104);
        button.setData((Object)presentation);
        button.setText(presentation.getLabel());
        button.setImage(DBeaverIcons.getImage((DBPImage)presentation.getIcon()));
        String toolTip = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.switch.presentation", (IServiceLocator)this.owner.getSite(), (boolean)true, (String)"presentationId", (String)presentation.getId());
        if (CommonUtils.isEmpty((String)toolTip)) {
            button.setToolTipText(presentation.getDescription());
        } else {
            button.setToolTipText(presentation.getDescription() + " (" + toolTip + ")");
        }
        IEvaluationService evaluationService = (IEvaluationService)this.owner.getSite().getService(IEvaluationService.class);
        Expression enabledWhen = presentation.getEnabledWhen();
        if (evaluationService != null && enabledWhen != null) {
            IEvaluationReference reference = evaluationService.addEvaluationListener(enabledWhen, event -> this.handlePresentationEnablement(button, presentation, CommonUtils.toBoolean((Object)event.getNewValue())), "enabled");
            button.addDisposeListener(e -> evaluationService.removeEvaluationListener(reference));
        }
        return button;
    }

    private void handlePresentationEnablement(@NotNull VerticalButton button, @NotNull SQLPresentationDescriptor presentation, boolean enabled) {
        if (this.owner.isDisposed()) {
            return;
        }
        if (!enabled && this.activePresentationDescriptor == presentation) {
            this.owner.showExtraPresentation((SQLPresentationDescriptor)null);
        }
        button.setVisible(enabled);
        button.getParent().layout(true, true);
    }

    public void dispose() {
        this.activePresentationDescriptor = null;
        this.activePresentation = null;
        this.activePresentationPanel = null;
        for (SQLEditorPresentation presentation : this.presentations.values()) {
            if (presentation == null) continue;
            presentation.dispose();
        }
        this.presentations.clear();
        this.panels.clear();
    }
}

