/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.data;

import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.MySQLUtils;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCDateTimeValueHandler;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.ContentUtils;

public class MySQLDateTimeValueHandler
extends JDBCDateTimeValueHandler {
    private static final Date ZERO_DATE = new Date(0L);
    private static final Date ZERO_TIMESTAMP = new Date(0L);
    private static final String ZERO_DATE_STRING = "0000-00-00";
    private static final String ZERO_TIMESTAMP_STRING = "0000-00-00 00:00:00";

    public MySQLDateTimeValueHandler(DBDFormatSettings formatSettings) {
        super(formatSettings);
    }

    public Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        if (resultSet instanceof JDBCResultSet) {
            JDBCResultSet dbResults = (JDBCResultSet)resultSet;
            boolean isMariaDB = MySQLUtils.isMariaDB(session.getDataSource().getContainer().getDriver());
            try {
                if ("year".equalsIgnoreCase(type.getTypeName())) {
                    int year = dbResults.getInt(index + 1);
                    if (dbResults.wasNull()) {
                        return null;
                    }
                    return year;
                }
                if (isMariaDB && type.getTypeID() == 92) {
                    return dbResults.getString(index + 1);
                }
            }
            catch (SQLException e) {
                log.debug((Object)"Exception caught when fetching date/time value", (Throwable)e);
            }
            if (!isMariaDB && type.getTypeID() == 92 && this.formatSettings.isUseNativeDateTimeFormat()) {
                byte[] bytes = null;
                try {
                    bytes = dbResults.getBytes(index + 1);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (ContentUtils.isAsciiText(bytes)) {
                    return new String(bytes, StandardCharsets.ISO_8859_1);
                }
            }
        }
        return super.fetchValueObject(session, resultSet, type, index);
    }

    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, @Nullable Object value) throws DBCException {
        if (value == ZERO_DATE || value == ZERO_TIMESTAMP) {
            try {
                JDBCPreparedStatement dbStat = (JDBCPreparedStatement)statement;
                if (value == ZERO_DATE) {
                    dbStat.setString(index + 1, ZERO_DATE_STRING);
                }
                dbStat.setString(index + 1, ZERO_TIMESTAMP_STRING);
            }
            catch (SQLException e) {
                throw new DBCException(ModelMessages.model_jdbc_exception_could_not_bind_statement_parameter, (Throwable)e);
            }
        } else if ("year".equalsIgnoreCase(type.getTypeName())) {
            try {
                JDBCPreparedStatement dbStat = (JDBCPreparedStatement)statement;
                if (value instanceof Number) {
                    dbStat.setInt(index + 1, ((Number)value).intValue());
                }
                if (value instanceof Date) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime((Date)value);
                    dbStat.setInt(index + 1, cal.get(1));
                }
                if (value instanceof String) {
                    dbStat.setString(index + 1, (String)value);
                }
                dbStat.setObject(index + 1, value);
            }
            catch (SQLException e) {
                throw new DBCException(ModelMessages.model_jdbc_exception_could_not_bind_statement_parameter, (Throwable)e);
            }
        } else {
            super.bindValueObject(session, statement, type, index, value);
        }
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value == ZERO_DATE) {
            return ZERO_DATE_STRING;
        }
        if (value == ZERO_TIMESTAMP) {
            return ZERO_TIMESTAMP_STRING;
        }
        return super.getValueDisplayString(column, value, format);
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object instanceof String) {
            switch (type.getTypeID()) {
                case 91: {
                    if (!object.equals(ZERO_DATE_STRING)) break;
                    return ZERO_DATE;
                }
                default: {
                    if (!object.equals(ZERO_TIMESTAMP_STRING)) break;
                    return ZERO_TIMESTAMP;
                }
            }
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }
}

