/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;

public class PairListControl<ELEMENT>
extends Composite {
    private static final Log log = Log.getLog(PairListControl.class);
    public static final int MOVE_LEFT = 0;
    public static final int MOVE_RIGHT = 1;
    private Table leftList;
    private Table rightList;
    private Collection<ELEMENT> leftElements;
    private Collection<ELEMENT> rightElements;
    private List<ELEMENT> movedElements = new ArrayList<ELEMENT>();
    private Font movedFont;
    private SelectionListener selListener;

    public PairListControl(Composite parent, int style, String leftTitle, String rightTitle) {
        super(parent, style);
        this.createPairList(leftTitle, rightTitle);
        this.movedFont = UIUtils.modifyFont(this.getFont(), 2);
    }

    public void setModel(Collection<ELEMENT> leftElements, Collection<ELEMENT> rightElements) {
        this.leftElements = leftElements;
        this.setListData(this.leftList, this.leftElements);
        this.rightElements = rightElements;
        this.setListData(this.rightList, this.rightElements);
        this.updateControls();
    }

    private void createPairList(String leftTitle, String rightTitle) {
        this.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(1808);
        this.setLayoutData(gd);
        Label leftLabel = new Label((Composite)this, 0);
        leftLabel.setText(leftTitle);
        new Label((Composite)this, 0);
        Label rightLabel = new Label((Composite)this, 0);
        rightLabel.setText(rightTitle);
        this.leftList = this.createList(this);
        Composite buttonsPane = new Composite((Composite)this, 0);
        gd = new GridData(4);
        gd.minimumWidth = 50;
        buttonsPane.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(1, false);
        buttonsPane.setLayout((Layout)gl);
        final Button btnMoveRight = this.createButton(buttonsPane, DBeaverIcons.getImage((DBPImage)UIIcon.ARROW_RIGHT), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PairListControl.this.moveElements(true);
            }
        });
        final Button btnMoveRightAll = this.createButton(buttonsPane, DBeaverIcons.getImage((DBPImage)UIIcon.ARROW_RIGHT_ALL), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PairListControl.this.leftList.selectAll();
                PairListControl.this.moveElements(true);
            }
        });
        final Button btnMoveLeft = this.createButton(buttonsPane, DBeaverIcons.getImage((DBPImage)UIIcon.ARROW_LEFT), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PairListControl.this.moveElements(false);
            }
        });
        final Button btnMoveLeftAll = this.createButton(buttonsPane, DBeaverIcons.getImage((DBPImage)UIIcon.ARROW_LEFT_ALL), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PairListControl.this.rightList.selectAll();
                PairListControl.this.moveElements(false);
            }
        });
        this.createButton(buttonsPane, DBeaverIcons.getImage((DBPImage)UIIcon.ARROW_RESET), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PairListControl.this.setListData(PairListControl.this.leftList, PairListControl.this.leftElements);
                PairListControl.this.setListData(PairListControl.this.rightList, PairListControl.this.rightElements);
            }
        });
        this.selListener = new SelectionAdapter(this){
            final /* synthetic */ PairListControl this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                btnMoveLeft.setEnabled(this.this$0.rightList.getSelectionCount() > 0);
                btnMoveLeftAll.setEnabled(this.this$0.rightList.getItemCount() > 0);
                btnMoveRight.setEnabled(this.this$0.leftList.getSelectionCount() > 0);
                btnMoveRightAll.setEnabled(this.this$0.leftList.getItemCount() > 0);
            }
        };
        btnMoveLeft.setEnabled(false);
        btnMoveLeftAll.setEnabled(false);
        btnMoveRight.setEnabled(false);
        btnMoveRightAll.setEnabled(false);
        this.rightList = this.createList(this);
        this.leftList.addSelectionListener(this.selListener);
        this.rightList.addSelectionListener(this.selListener);
        this.leftList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                PairListControl.this.moveElements(true);
            }
        });
        this.rightList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                PairListControl.this.moveElements(false);
            }
        });
    }

    private Table createList(Composite panel) {
        final Table table = new Table(panel, 2818);
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        final TableColumn column = new TableColumn(table, 16384);
        table.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                column.setWidth(table.getClientArea().width);
            }
        });
        return table;
    }

    private Button createButton(Composite panel, Image label, SelectionListener listener) {
        Button button = new Button(panel, 8);
        button.setImage(label);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener(listener);
        return button;
    }

    private void setListData(Table list, Collection<ELEMENT> elements) {
        list.removeAll();
        for (ELEMENT element : elements) {
            this.createListItem(list, element);
        }
    }

    private void updateControls() {
        if (this.selListener != null) {
            this.selListener.widgetSelected(null);
        }
    }

    private TableItem createListItem(Table list, Object element) {
        TableItem item = new TableItem(list, 0);
        item.setData(element);
        item.setText(element.toString());
        return item;
    }

    /*
     * WARNING - void declaration
     */
    private void moveElements(boolean toRight) {
        void var8_10;
        Table fromTable = toRight ? this.leftList : this.rightList;
        Table toTable = toRight ? this.rightList : this.leftList;
        Collection<ELEMENT> checkList = toRight ? this.rightElements : this.leftElements;
        ArrayList<Object> movedElements = new ArrayList<Object>();
        TableItem[] tableItemArray = fromTable.getSelection();
        int n = tableItemArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            TableItem item = tableItemArray[var8_10];
            Object element = item.getData();
            movedElements.add(element);
            TableItem newItem = this.createListItem(toTable, element);
            if (!checkList.contains(element)) {
                newItem.setFont(this.movedFont);
            }
            ++var8_10;
        }
        fromTable.remove(fromTable.getSelectionIndices());
        this.updateControls();
        Event event = new Event();
        event.detail = toRight ? 1 : 0;
        event.widget = this;
        for (Object e : movedElements) {
            event.data = e;
            super.notifyListeners(24, event);
        }
    }
}

