/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class TasksJob
extends AbstractJob {
    private final List<DBRRunnableWithProgress> tasks;

    private TasksJob(String name, Collection<DBRRunnableWithProgress> tasks) {
        super(name);
        this.setUser(true);
        this.tasks = new ArrayList<DBRRunnableWithProgress>(tasks);
    }

    private TasksJob(String name, DBRRunnableWithProgress task) {
        this(name, Collections.singletonList(task));
    }

    @Override
    @NotNull
    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
        monitor.beginTask(this.getName(), this.tasks.size());
        boolean ignoreErrors = false;
        int i = 0;
        block9: while (i < this.tasks.size()) {
            DBRRunnableWithProgress task = this.tasks.get(i);
            if (monitor.isCanceled()) break;
            try {
                task.run(monitor);
            }
            catch (InvocationTargetException e) {
                if (this.tasks.size() == 1) {
                    DBWorkbench.getPlatformUI().showError(this.getName(), null, e.getTargetException());
                } else if (!ignoreErrors) {
                    boolean keepRunning = true;
                    switch (DBWorkbench.getPlatformUI().showErrorStopRetryIgnore(this.getName(), e.getTargetException(), true)) {
                        case STOP: {
                            keepRunning = false;
                            break;
                        }
                        case RETRY: {
                            continue block9;
                        }
                        case IGNORE: {
                            break;
                        }
                        case IGNORE_ALL: {
                            ignoreErrors = true;
                        }
                    }
                    if (!keepRunning) {
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            monitor.worked(1);
            ++i;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public static void runTasks(String name, Collection<DBRRunnableWithProgress> tasks) {
        new TasksJob(name, tasks).schedule();
    }

    public static void runTask(String name, DBRRunnableWithProgress task) {
        new TasksJob(name, task).schedule();
    }
}

