/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.create.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class Index
implements Serializable {
    private final List<String> name = new ArrayList<String>();
    private String type;
    private String using;
    private List<ColumnParams> columns;
    private List<String> idxSpec;
    private String commentText;
    private String indexKeyword;

    public List<String> getColumnsNames() {
        return this.columns.stream().map(col -> col.columnName).collect(Collectors.toList());
    }

    public void setColumnsNames(List<String> list) {
        this.columns = list == null ? Collections.emptyList() : list.stream().map(ColumnParams::new).collect(Collectors.toList());
    }

    @Deprecated
    public List<ColumnParams> getColumnWithParams() {
        return this.getColumns();
    }

    @Deprecated
    public void setColumnNamesWithParams(List<ColumnParams> list) {
        this.setColumns(list);
    }

    public List<ColumnParams> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnParams> columns) {
        this.columns = columns;
    }

    public Index withColumns(List<ColumnParams> columns) {
        this.setColumns(columns);
        return this;
    }

    public Index addColumns(ColumnParams ... functionDeclarationParts) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, functionDeclarationParts);
        return this.withColumns(collection);
    }

    public Index addColumns(Collection<? extends ColumnParams> functionDeclarationParts) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        collection.addAll(functionDeclarationParts);
        return this.withColumns(collection);
    }

    public String getName() {
        return this.name.isEmpty() ? null : String.join((CharSequence)".", this.name);
    }

    public void setName(String name) {
        this.name.clear();
        if (name != null) {
            this.name.add(name);
        }
    }

    public void setName(List<String> name) {
        this.name.clear();
        this.name.addAll(name);
    }

    public List<String> getNameParts() {
        return Collections.unmodifiableList(this.name);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public Index withColumnsNames(List<String> list) {
        this.setColumnsNames(list);
        return this;
    }

    public String getUsing() {
        return this.using;
    }

    public void setUsing(String using) {
        this.using = using;
    }

    public List<String> getIndexSpec() {
        return this.idxSpec;
    }

    public void setIndexSpec(List<String> idxSpec) {
        this.idxSpec = idxSpec;
    }

    public Index withIndexSpec(List<String> idxSpec) {
        this.setIndexSpec(idxSpec);
        return this;
    }

    public void setIndexKeyword(String indexKeyword) {
        this.indexKeyword = indexKeyword;
    }

    public String getIndexKeyword() {
        return this.indexKeyword;
    }

    public Index withIndexKeyword(String indexKeyword) {
        this.setIndexKeyword(indexKeyword);
        return this;
    }

    public String toString() {
        String idxSpecText = PlainSelect.getStringList(this.idxSpec, false, false);
        String keyword = this.indexKeyword != null ? " " + this.indexKeyword : "";
        String head = (this.type != null ? this.type : "") + keyword + (String)(!this.name.isEmpty() ? " " + this.getName() : "") + (String)(this.using != null ? " USING " + this.using : "");
        String tail = (this.columns != null && !this.columns.isEmpty() ? PlainSelect.getStringList(this.columns, true, true) : "") + (String)(!idxSpecText.isEmpty() ? " " + idxSpecText : "");
        return tail.isEmpty() ? head : head + " " + tail;
    }

    public Index withType(String type) {
        this.setType(type);
        return this;
    }

    public Index withUsing(String using) {
        this.setUsing(using);
        return this;
    }

    public Index withName(List<String> name) {
        this.setName(name);
        return this;
    }

    public Index withName(String name) {
        this.setName(name);
        return this;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public static class ColumnParams
    implements Serializable {
        public final String columnName;
        public final List<String> params;

        public ColumnParams(String columnName) {
            this.columnName = columnName;
            this.params = null;
        }

        public ColumnParams(String columnName, List<String> params) {
            this.columnName = columnName;
            this.params = params;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public List<String> getParams() {
            return this.params;
        }

        public String toString() {
            return this.columnName + (String)(this.params != null ? " " + String.join((CharSequence)" ", this.params) : "");
        }
    }
}

