/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.Map;
import proguard.backport.LambdaExpression;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ArrayUtil;

public class LambdaExpressionCollector
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
AttributeVisitor,
BootstrapMethodInfoVisitor {
    private final Map<Integer, LambdaExpression> lambdaExpressions;
    private InvokeDynamicConstant referencedInvokeDynamicConstant;
    private int referencedBootstrapMethodIndex;
    private Clazz referencedInvokedClass;
    private Method referencedInvokedMethod;
    private static final String NAME_JAVA_LANG_INVOKE_LAMBDA_METAFACTORY = "java/lang/invoke/LambdaMetafactory";
    private static final String LAMBDA_ALTERNATE_METAFACTORY_METHOD = "altMetafactory";

    public LambdaExpressionCollector(Map<Integer, LambdaExpression> lambdaExpressions) {
        this.lambdaExpressions = lambdaExpressions;
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(new ConstantTagFilter(18, (ConstantVisitor)this));
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.referencedInvokeDynamicConstant = invokeDynamicConstant;
        this.referencedBootstrapMethodIndex = invokeDynamicConstant.getBootstrapMethodAttributeIndex();
        clazz.attributesAccept(this);
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        this.referencedInvokedClass = refConstant.referencedClass;
        this.referencedInvokedMethod = (Method)refConstant.referencedMember;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        bootstrapMethodsAttribute.bootstrapMethodEntryAccept(clazz, this.referencedBootstrapMethodIndex, this);
    }

    @Override
    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        ProgramClass programClass = (ProgramClass)clazz;
        MethodHandleConstant bootstrapMethodHandle = (MethodHandleConstant)programClass.getConstant(bootstrapMethodInfo.u2methodHandleIndex);
        if (LambdaExpressionCollector.isLambdaMetaFactory(bootstrapMethodHandle.getClassName(clazz))) {
            String factoryMethodDescriptor = this.referencedInvokeDynamicConstant.getType(clazz);
            String interfaceClassName = ClassUtil.internalClassNameFromClassType(ClassUtil.internalMethodReturnType(factoryMethodDescriptor));
            MethodHandleConstant invokedMethodHandle = (MethodHandleConstant)programClass.getConstant(bootstrapMethodInfo.u2methodArguments[1]);
            this.referencedInvokedClass = null;
            this.referencedInvokedMethod = null;
            clazz.constantPoolEntryAccept(invokedMethodHandle.u2referenceIndex, this);
            LambdaExpression lambdaExpression = new LambdaExpression(programClass, this.referencedBootstrapMethodIndex, bootstrapMethodInfo, factoryMethodDescriptor, new String[]{interfaceClassName}, new String[0], this.referencedInvokeDynamicConstant.getName(clazz), LambdaExpressionCollector.getMethodTypeConstant(programClass, bootstrapMethodInfo.u2methodArguments[0]).getType(clazz), invokedMethodHandle.getReferenceKind(), invokedMethodHandle.getClassName(clazz), invokedMethodHandle.getName(clazz), invokedMethodHandle.getType(clazz), this.referencedInvokedClass, this.referencedInvokedMethod);
            if (LambdaExpressionCollector.isAlternateFactoryMethod(bootstrapMethodHandle.getName(clazz))) {
                int i;
                int flags = LambdaExpressionCollector.getIntegerConstant(programClass, bootstrapMethodInfo.u2methodArguments[3]);
                int argumentIndex = 4;
                if ((flags & 2) != 0) {
                    int markerInterfaceCount = LambdaExpressionCollector.getIntegerConstant(programClass, bootstrapMethodInfo.u2methodArguments[argumentIndex++]);
                    for (i = 0; i < markerInterfaceCount; ++i) {
                        String interfaceName = programClass.getClassName(bootstrapMethodInfo.u2methodArguments[argumentIndex++]);
                        lambdaExpression.interfaces = ArrayUtil.add(lambdaExpression.interfaces, lambdaExpression.interfaces.length, interfaceName);
                    }
                }
                if ((flags & 4) != 0) {
                    int bridgeMethodCount = LambdaExpressionCollector.getIntegerConstant(programClass, bootstrapMethodInfo.u2methodArguments[argumentIndex++]);
                    for (i = 0; i < bridgeMethodCount; ++i) {
                        MethodTypeConstant methodTypeConstant = LambdaExpressionCollector.getMethodTypeConstant(programClass, bootstrapMethodInfo.u2methodArguments[argumentIndex++]);
                        lambdaExpression.bridgeMethodDescriptors = ArrayUtil.add(lambdaExpression.bridgeMethodDescriptors, lambdaExpression.bridgeMethodDescriptors.length, methodTypeConstant.getType(programClass));
                    }
                }
                if ((flags & 1) != 0) {
                    lambdaExpression.interfaces = ArrayUtil.add(lambdaExpression.interfaces, lambdaExpression.interfaces.length, "java/io/Serializable");
                }
            }
            this.lambdaExpressions.put(this.referencedBootstrapMethodIndex, lambdaExpression);
        }
    }

    private static boolean isLambdaMetaFactory(String className) {
        return NAME_JAVA_LANG_INVOKE_LAMBDA_METAFACTORY.equals(className);
    }

    private static boolean isAlternateFactoryMethod(String methodName) {
        return LAMBDA_ALTERNATE_METAFACTORY_METHOD.equals(methodName);
    }

    private static int getIntegerConstant(ProgramClass programClass, int constantIndex) {
        return ((IntegerConstant)programClass.getConstant(constantIndex)).getValue();
    }

    private static MethodTypeConstant getMethodTypeConstant(ProgramClass programClass, int constantIndex) {
        return (MethodTypeConstant)programClass.getConstant(constantIndex);
    }
}

