﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/ScanResultStatus.h>
#include <aws/guardduty/model/ScanResultThreat.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Contains information about the results of the malware scan.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMalwareScanResultDetails">AWS
 * API Reference</a></p>
 */
class GetMalwareScanResultDetails {
 public:
  AWS_GUARDDUTY_API GetMalwareScanResultDetails() = default;
  AWS_GUARDDUTY_API GetMalwareScanResultDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API GetMalwareScanResultDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Status indicating whether threats were found for a completed scan.</p>
   */
  inline ScanResultStatus GetScanResultStatus() const { return m_scanResultStatus; }
  inline bool ScanResultStatusHasBeenSet() const { return m_scanResultStatusHasBeenSet; }
  inline void SetScanResultStatus(ScanResultStatus value) {
    m_scanResultStatusHasBeenSet = true;
    m_scanResultStatus = value;
  }
  inline GetMalwareScanResultDetails& WithScanResultStatus(ScanResultStatus value) {
    SetScanResultStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The total number of files that were skipped during the scan.</p>
   */
  inline long long GetSkippedFileCount() const { return m_skippedFileCount; }
  inline bool SkippedFileCountHasBeenSet() const { return m_skippedFileCountHasBeenSet; }
  inline void SetSkippedFileCount(long long value) {
    m_skippedFileCountHasBeenSet = true;
    m_skippedFileCount = value;
  }
  inline GetMalwareScanResultDetails& WithSkippedFileCount(long long value) {
    SetSkippedFileCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The total number of files that failed to be scanned.</p>
   */
  inline long long GetFailedFileCount() const { return m_failedFileCount; }
  inline bool FailedFileCountHasBeenSet() const { return m_failedFileCountHasBeenSet; }
  inline void SetFailedFileCount(long long value) {
    m_failedFileCountHasBeenSet = true;
    m_failedFileCount = value;
  }
  inline GetMalwareScanResultDetails& WithFailedFileCount(long long value) {
    SetFailedFileCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The total number of files in which threats were detected.</p>
   */
  inline long long GetThreatFoundFileCount() const { return m_threatFoundFileCount; }
  inline bool ThreatFoundFileCountHasBeenSet() const { return m_threatFoundFileCountHasBeenSet; }
  inline void SetThreatFoundFileCount(long long value) {
    m_threatFoundFileCountHasBeenSet = true;
    m_threatFoundFileCount = value;
  }
  inline GetMalwareScanResultDetails& WithThreatFoundFileCount(long long value) {
    SetThreatFoundFileCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The total number of files that were processed during the scan.</p>
   */
  inline long long GetTotalFileCount() const { return m_totalFileCount; }
  inline bool TotalFileCountHasBeenSet() const { return m_totalFileCountHasBeenSet; }
  inline void SetTotalFileCount(long long value) {
    m_totalFileCountHasBeenSet = true;
    m_totalFileCount = value;
  }
  inline GetMalwareScanResultDetails& WithTotalFileCount(long long value) {
    SetTotalFileCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The total number of bytes that were scanned.</p>
   */
  inline long long GetTotalBytes() const { return m_totalBytes; }
  inline bool TotalBytesHasBeenSet() const { return m_totalBytesHasBeenSet; }
  inline void SetTotalBytes(long long value) {
    m_totalBytesHasBeenSet = true;
    m_totalBytes = value;
  }
  inline GetMalwareScanResultDetails& WithTotalBytes(long long value) {
    SetTotalBytes(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The total number of unique threats that were detected during the scan.</p>
   */
  inline long long GetUniqueThreatCount() const { return m_uniqueThreatCount; }
  inline bool UniqueThreatCountHasBeenSet() const { return m_uniqueThreatCountHasBeenSet; }
  inline void SetUniqueThreatCount(long long value) {
    m_uniqueThreatCountHasBeenSet = true;
    m_uniqueThreatCount = value;
  }
  inline GetMalwareScanResultDetails& WithUniqueThreatCount(long long value) {
    SetUniqueThreatCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The threats that were detected during the malware scan.</p>
   */
  inline const Aws::Vector<ScanResultThreat>& GetThreats() const { return m_threats; }
  inline bool ThreatsHasBeenSet() const { return m_threatsHasBeenSet; }
  template <typename ThreatsT = Aws::Vector<ScanResultThreat>>
  void SetThreats(ThreatsT&& value) {
    m_threatsHasBeenSet = true;
    m_threats = std::forward<ThreatsT>(value);
  }
  template <typename ThreatsT = Aws::Vector<ScanResultThreat>>
  GetMalwareScanResultDetails& WithThreats(ThreatsT&& value) {
    SetThreats(std::forward<ThreatsT>(value));
    return *this;
  }
  template <typename ThreatsT = ScanResultThreat>
  GetMalwareScanResultDetails& AddThreats(ThreatsT&& value) {
    m_threatsHasBeenSet = true;
    m_threats.emplace_back(std::forward<ThreatsT>(value));
    return *this;
  }
  ///@}
 private:
  ScanResultStatus m_scanResultStatus{ScanResultStatus::NOT_SET};

  long long m_skippedFileCount{0};

  long long m_failedFileCount{0};

  long long m_threatFoundFileCount{0};

  long long m_totalFileCount{0};

  long long m_totalBytes{0};

  long long m_uniqueThreatCount{0};

  Aws::Vector<ScanResultThreat> m_threats;
  bool m_scanResultStatusHasBeenSet = false;
  bool m_skippedFileCountHasBeenSet = false;
  bool m_failedFileCountHasBeenSet = false;
  bool m_threatFoundFileCountHasBeenSet = false;
  bool m_totalFileCountHasBeenSet = false;
  bool m_totalBytesHasBeenSet = false;
  bool m_uniqueThreatCountHasBeenSet = false;
  bool m_threatsHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
