﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces-web/WorkSpacesWeb_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WorkSpacesWeb {
namespace Model {
class CreateDataProtectionSettingsResult {
 public:
  AWS_WORKSPACESWEB_API CreateDataProtectionSettingsResult() = default;
  AWS_WORKSPACESWEB_API CreateDataProtectionSettingsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WORKSPACESWEB_API CreateDataProtectionSettingsResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the data protection settings resource.</p>
   */
  inline const Aws::String& GetDataProtectionSettingsArn() const { return m_dataProtectionSettingsArn; }
  template <typename DataProtectionSettingsArnT = Aws::String>
  void SetDataProtectionSettingsArn(DataProtectionSettingsArnT&& value) {
    m_dataProtectionSettingsArnHasBeenSet = true;
    m_dataProtectionSettingsArn = std::forward<DataProtectionSettingsArnT>(value);
  }
  template <typename DataProtectionSettingsArnT = Aws::String>
  CreateDataProtectionSettingsResult& WithDataProtectionSettingsArn(DataProtectionSettingsArnT&& value) {
    SetDataProtectionSettingsArn(std::forward<DataProtectionSettingsArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateDataProtectionSettingsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_dataProtectionSettingsArn;
  bool m_dataProtectionSettingsArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpacesWeb
}  // namespace Aws
