/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.parosproxy.paros.core.scanner.Alert;

public class AlertSet {
    private Map<Integer, Alert> map = new ConcurrentHashMap<Integer, Alert>();
    private Alert highestRisk;

    public synchronized boolean add(Alert alert) {
        boolean added = this.map.put(alert.getAlertId(), alert) == null;
        this.highestRisk = AlertSet.getHighestRisk(this.highestRisk, alert);
        return added;
    }

    public boolean addAll(List<Alert> alerts) {
        AtomicBoolean changed = new AtomicBoolean(false);
        alerts.forEach(a -> {
            if (this.add((Alert)a)) {
                changed.set(true);
            }
        });
        return changed.get();
    }

    public synchronized boolean remove(Alert alert) {
        Alert a = this.map.remove(alert.getAlertId());
        if (a != null) {
            if (this.highestRisk != null && a.getAlertId() == this.highestRisk.getAlertId()) {
                this.calculateHighestRisk();
            }
            return true;
        }
        return false;
    }

    public boolean removeAll(List<Alert> alerts) {
        AtomicBoolean changed = new AtomicBoolean(false);
        alerts.forEach(a -> {
            if (this.remove((Alert)a)) {
                changed.set(true);
            }
        });
        return changed.get();
    }

    public boolean hasAlert(int alertId) {
        return this.map.containsKey(alertId);
    }

    public boolean hasSimilar(Alert alert) {
        return this.map.values().stream().anyMatch(a -> a.compareTo(alert) == 0);
    }

    public Alert get() {
        return this.map.values().stream().findAny().orElse(null);
    }

    public List<Alert> getAll() {
        return this.map.values().stream().toList();
    }

    public List<Alert> getAllUnique() {
        return new ArrayList<Alert>(new TreeSet<Alert>(this.map.values()));
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Alert getHighestRisk() {
        return this.highestRisk;
    }

    private void calculateHighestRisk() {
        this.highestRisk = null;
        for (Alert a : this.map.values()) {
            this.highestRisk = AlertSet.getHighestRisk(this.highestRisk, a);
        }
    }

    public int size() {
        return this.map.size();
    }

    private static Alert getHighestRisk(Alert a1, Alert a2) {
        if (a2.getConfidence() == 0) {
            if (a1 != null && a1.getConfidence() == 0) {
                return null;
            }
            return a1;
        }
        if (a1 == null) {
            return a2;
        }
        return a2.getRisk() > a1.getRisk() ? a2 : a1;
    }

    public String toString() {
        return "AlertSet[" + this.map.values().stream().map(Alert::getAlertId).map(Object::toString).collect(Collectors.joining(",")) + "]";
    }
}

