/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RefreshLogAction
extends RefreshAction {
    private static final Logger LOG = Logger.getInstance(RefreshLogAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        VisiblePackRefresher refresher;
        if (e == null) {
            RefreshLogAction.$$$reportNull$$$0(0);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        VcsLogManager logManager = (VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER);
        if (logManager == null) {
            return;
        }
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (ui == null) {
            return;
        }
        if (ui instanceof VcsLogUiEx && !(refresher = ((VcsLogUiEx)ui).getRefresher()).isValid()) {
            String message = "Trying to refresh invalid log tab '" + ui.getId() + "'.";
            if (!logManager.getDataManager().getProgress().isRunning()) {
                LOG.error(message, RefreshLogAction.collectDiagnosticInformation(e.getProject(), logManager));
            } else {
                LOG.warn(message);
            }
            refresher.setValid(true, false);
        }
        logManager.getDataManager().refresh(VcsLogUtil.getVisibleRoots(ui));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RefreshLogAction.$$$reportNull$$$0(1);
        }
        VcsLogManager logManager = (VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER);
        e.getPresentation().setEnabledAndVisible(logManager != null && e.getData(VcsLogDataKeys.VCS_LOG_UI) != null);
    }

    private static Attachment @NotNull [] collectDiagnosticInformation(@Nullable Project project, @NotNull VcsLogManager logManager) {
        ToolWindow toolWindow;
        if (logManager == null) {
            RefreshLogAction.$$$reportNull$$$0(2);
        }
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        result.add(new Attachment("log-windows.txt", "Log Windows:\n" + logManager.getLogUiInformation()));
        if (project != null && (toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control")) != null) {
            String contentDump = StringUtil.join((Object[])toolWindow.getContentManager().getContents(), content -> {
                if (content instanceof TabbedContent) {
                    return String.valueOf(content) + ", tabs=[" + StringUtil.join((Collection)((TabbedContent)content).getTabs(), pair -> (String)pair.first, (String)", ") + "]";
                }
                return content.toString();
            }, (String)"\n");
            result.add(new Attachment("vcs-tool-window-content.txt", "Tool Window " + toolWindow.getTitle() + " (" + String.valueOf(toolWindow.getType()) + "):\n" + contentDump));
        }
        Attachment[] attachmentArray = result.toArray(Attachment.EMPTY_ARRAY);
        if (attachmentArray == null) {
            RefreshLogAction.$$$reportNull$$$0(3);
        }
        return attachmentArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/RefreshLogAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/RefreshLogAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDiagnosticInformation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectDiagnosticInformation";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

