/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.impl.LocationImpl;
import com.fasterxml.aalto.in.CharBasedPNameTable;
import com.fasterxml.aalto.in.ElementScope;
import com.fasterxml.aalto.in.InputCharTypes;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.PNameC;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.util.DataUtil;
import com.fasterxml.aalto.util.XmlCharTypes;
import com.fasterxml.aalto.util.XmlChars;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamLocation2;

public final class ReaderScanner
extends XmlScanner {
    private static final XmlCharTypes sCharTypes = InputCharTypes.getLatin1CharTypes();
    protected Reader _in;
    protected char[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected int mTmpChar = 0;
    protected final CharBasedPNameTable _symbols;

    public ReaderScanner(ReaderConfig cfg, Reader r, char[] buffer, int ptr, int last) {
        super(cfg);
        this._in = r;
        this._inputBuffer = buffer;
        this._inputPtr = ptr;
        this._inputEnd = last;
        this._pastBytesOrChars = 0L;
        this._rowStartOffset = 0;
        this._symbols = cfg.getCBSymbols();
    }

    public ReaderScanner(ReaderConfig cfg, Reader r) {
        super(cfg);
        this._in = r;
        this._inputBuffer = cfg.allocFullCBuffer(4000);
        this._inputEnd = 0;
        this._inputPtr = 0;
        this._pastBytesOrChars = 0L;
        this._rowStartOffset = 0;
        this._symbols = cfg.getCBSymbols();
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        if (this._symbols.maybeDirty()) {
            this._config.updateCBSymbols(this._symbols);
        }
        if (this._in != null && this._inputBuffer != null) {
            this._config.freeFullCBuffer(this._inputBuffer);
            this._inputBuffer = null;
        }
    }

    @Override
    protected void _closeSource() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
    }

    @Override
    protected final void finishToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.finishPI();
                break;
            }
            case 4: {
                this.finishCharacters();
                break;
            }
            case 5: {
                this.finishComment();
                break;
            }
            case 6: {
                this.finishSpace();
                break;
            }
            case 11: {
                this.finishDTD(true);
                break;
            }
            case 12: {
                this.finishCData();
                break;
            }
            default: {
                ErrorConsts.throwInternalError();
            }
        }
    }

    @Override
    public final int nextFromProlog(boolean isProlog) throws XMLStreamException {
        char c;
        if (this._tokenIncomplete) {
            this.skipToken();
        }
        this.setStartLocation();
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.setStartLocation();
                return -1;
            }
            if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) == '<') break;
            if (c == ' ') continue;
            if (c == '\n') {
                this.markLF();
                continue;
            }
            if (c == '\r') {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this.markLF();
                    this.setStartLocation();
                    return -1;
                }
                if (this._inputBuffer[this._inputPtr] == '\n') {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (c == '\t') continue;
            this.reportPrologUnexpChar(isProlog, c, null);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed(5);
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '!') {
            return this.handlePrologDeclStart(isProlog);
        }
        if (c == '?') {
            return this.handlePIStart();
        }
        if (c == '/' || !isProlog) {
            this.reportPrologUnexpElement(isProlog, c);
        }
        return this.handleStartElement(c);
    }

    @Override
    public final int nextFromTree() throws XMLStreamException {
        if (this._tokenIncomplete) {
            if (this.skipToken()) {
                return this._nextEntity();
            }
        } else if (this._currToken == 1) {
            if (this._isEmptyTag) {
                --this._depth;
                this._currToken = 2;
                return 2;
            }
        } else if (this._currToken == 2) {
            this._currElem = this._currElem.getParent();
            while (this._lastNsDecl != null && this._lastNsDecl.getLevel() >= this._depth) {
                this._lastNsDecl = this._lastNsDecl.unbind();
            }
        } else if (this._entityPending) {
            this._entityPending = false;
            return this._nextEntity();
        }
        this.setStartLocation();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.setStartLocation();
            return -1;
        }
        char c = this._inputBuffer[this._inputPtr];
        if (c == '<') {
            ++this._inputPtr;
            c = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne(5);
            if (c == '!') {
                return this.handleCommentOrCdataStart();
            }
            if (c == '?') {
                return this.handlePIStart();
            }
            if (c == '/') {
                return this.handleEndElement();
            }
            return this.handleStartElement(c);
        }
        if (c == '&') {
            ++this._inputPtr;
            int i = this.handleEntityInText(false);
            if (i == 0) {
                this._currToken = 9;
                return 9;
            }
            this.mTmpChar = -i;
        } else {
            this.mTmpChar = c;
        }
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        this._currToken = 4;
        return 4;
    }

    protected int _nextEntity() {
        this._textBuilder.resetWithEmpty();
        this._currToken = 9;
        return 9;
    }

    protected final int handlePrologDeclStart(boolean isProlog) throws XMLStreamException {
        char c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '-') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == '-') {
                if (this._cfgLazyParsing) {
                    this._tokenIncomplete = true;
                } else {
                    this.finishComment();
                }
                this._currToken = 5;
                return 5;
            }
        } else if (c == 'D' && isProlog) {
            this.handleDtdStart();
            if (!this._cfgLazyParsing && this._tokenIncomplete) {
                this.finishDTD(true);
                this._tokenIncomplete = false;
            }
            return 11;
        }
        this._tokenIncomplete = true;
        this._currToken = 4;
        this.reportPrologUnexpChar(isProlog, c, " (expected '-' for COMMENT)");
        return this._currToken;
    }

    private final int handleDtdStart() throws XMLStreamException {
        this.matchAsciiKeyword("DOCTYPE");
        char c = this.skipInternalWs(true, "after DOCTYPE keyword, before root name");
        this._tokenName = this.parsePName(c);
        c = this.skipInternalWs(false, null);
        if (c == 'P') {
            this.matchAsciiKeyword("PUBLIC");
            c = this.skipInternalWs(true, null);
            this._publicId = this.parsePublicId(c);
            c = this.skipInternalWs(true, null);
            this._systemId = this.parseSystemId(c);
            c = this.skipInternalWs(false, null);
        } else if (c == 'S') {
            this.matchAsciiKeyword("SYSTEM");
            c = this.skipInternalWs(true, null);
            this._publicId = null;
            this._systemId = this.parseSystemId(c);
            c = this.skipInternalWs(false, null);
        } else {
            this._systemId = null;
            this._publicId = null;
        }
        if (c == '>') {
            this._tokenIncomplete = false;
            this._currToken = 11;
            return 11;
        }
        if (c != '[') {
            String msg = this._systemId != null ? " (expected '[' for the internal subset, or '>' to end DOCTYPE declaration)" : " (expected a 'PUBLIC' or 'SYSTEM' keyword, '[' for the internal subset, or '>' to end DOCTYPE declaration)";
            this.reportTreeUnexpChar(c, msg);
        }
        this._tokenIncomplete = true;
        this._currToken = 11;
        return 11;
    }

    protected final int handleCommentOrCdataStart() throws XMLStreamException {
        char c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '-') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) != '-') {
                this.reportTreeUnexpChar(c, " (expected '-' for COMMENT)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishComment();
            }
            this._currToken = 5;
            return 5;
        }
        if (c == '[') {
            this._currToken = 12;
            for (int i = 0; i < 6; ++i) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == "CDATA[".charAt(i)) continue;
                this.reportTreeUnexpChar(c, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishCData();
            }
            return 12;
        }
        this.reportTreeUnexpChar(c, " (expected either '-' for COMMENT or '[CDATA[' for CDATA section)");
        return -1;
    }

    protected final int handlePIStart() throws XMLStreamException {
        this._currToken = 3;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        char c = this._inputBuffer[this._inputPtr++];
        this._tokenName = this.parsePName(c);
        String ln = this._tokenName.getLocalName();
        if (ln.length() == 3 && ln.equalsIgnoreCase("xml") && this._tokenName.getPrefix() == null) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') {
            while (true) {
                if (c == '\n') {
                    this.markLF();
                } else if (c == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                } else if (c != ' ' && c != '\t') {
                    this.throwInvalidSpace(c);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr]) > ' ') break;
                ++this._inputPtr;
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishPI();
            }
        } else {
            if (c != '?') {
                this.reportMissingPISpace(c);
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) != '>') {
                this.reportMissingPISpace(c);
            }
            this._textBuilder.resetWithEmpty();
            this._tokenIncomplete = false;
        }
        return 3;
    }

    protected final int handleCharEntity() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        char c = this._inputBuffer[this._inputPtr++];
        int value = 0;
        if (c == 'x') {
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) != ';') {
                    value <<= 4;
                    if (c <= '9' && c >= '0') {
                        value += c - 48;
                    } else if (c >= 'a' && c <= 'f') {
                        value += 10 + (c - 97);
                    } else if (c >= 'A' && c <= 'F') {
                        value += 10 + (c - 65);
                    } else {
                        this.throwUnexpectedChar(c, "; expected a hex digit (0-9a-fA-F)");
                    }
                    if (value <= 0x10FFFF) continue;
                    this.reportEntityOverflow();
                    continue;
                }
                break;
            }
        } else {
            while (c != ';') {
                if (c <= '9' && c >= '0') {
                    if ((value = value * 10 + (c - 48)) > 0x10FFFF) {
                        this.reportEntityOverflow();
                    }
                } else {
                    this.throwUnexpectedChar(c, "; expected a decimal number");
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                c = this._inputBuffer[this._inputPtr++];
            }
        }
        if (value >= 55296) {
            if (value < 57344) {
                this.reportInvalidXmlChar(value);
            }
            if (value == 65534 || value == 65535) {
                this.reportInvalidXmlChar(value);
            }
        } else if (!(value >= 32 || value == 10 || value == 13 || value == 9 || this._xml11 && value != 0)) {
            this.reportInvalidXmlChar(value);
        }
        return value;
    }

    protected final int handleStartElement(char c) throws XMLStreamException {
        boolean allBound;
        this._currToken = 1;
        this._currNsCount = 0;
        PName elemName = this.parsePName(c);
        String prefix = elemName.getPrefix();
        if (prefix == null) {
            allBound = true;
        } else {
            elemName = this.bindName(elemName, prefix);
            allBound = elemName.isBound();
        }
        this._tokenName = elemName;
        this._currElem = new ElementScope(elemName, this._currElem);
        int attrPtr = 0;
        while (true) {
            boolean isNsDecl;
            PName attrName;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') {
                do {
                    if (c == '\n') {
                        this.markLF();
                    } else if (c == '\r') {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                    } else if (c != ' ' && c != '\t') {
                        this.throwInvalidSpace(c);
                    }
                    if (this._inputPtr < this._inputEnd) continue;
                    this.loadMoreGuaranteed();
                } while ((c = this._inputBuffer[this._inputPtr++]) <= ' ');
            } else if (c != '/' && c != '>') {
                this.throwUnexpectedChar(c, " expected space, or '>' or \"/>\"");
            }
            if (c == '/') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) != '>') {
                    this.throwUnexpectedChar(c, " expected '>'");
                }
                this._isEmptyTag = true;
                break;
            }
            if (c == '>') {
                this._isEmptyTag = false;
                break;
            }
            if (c == '<') {
                this.reportInputProblem("Unexpected '<' character in element (missing closing '>'?)");
            }
            if ((prefix = (attrName = this.parsePName(c)).getPrefix()) == null) {
                isNsDecl = attrName.getLocalName() == "xmlns";
            } else if (prefix == "xmlns") {
                isNsDecl = true;
            } else {
                attrName = this.bindName(attrName, prefix);
                if (allBound) {
                    allBound = attrName.isBound();
                }
                isNsDecl = false;
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) > ' ') break;
                if (c == '\n') {
                    this.markLF();
                    continue;
                }
                if (c == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c == ' ' || c == '\t') continue;
                this.throwInvalidSpace(c);
            }
            if (c != '=') {
                this.throwUnexpectedChar(c, " expected '='");
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) > ' ') break;
                if (c == '\n') {
                    this.markLF();
                    continue;
                }
                if (c == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c == ' ' || c == '\t') continue;
                this.throwInvalidSpace(c);
            }
            if (c != '\"' && c != '\'') {
                this.throwUnexpectedChar(c, " Expected a quote");
            }
            if (isNsDecl) {
                this.handleNsDeclaration(attrName, c);
                ++this._currNsCount;
                continue;
            }
            attrPtr = this.collectValue(attrPtr, c, attrName);
        }
        int act = this._attrCollector.finishLastValue(attrPtr);
        if (act < 0) {
            act = this._attrCollector.getCount();
            this.reportInputProblem(this._attrCollector.getErrorMsg());
        }
        this._attrCount = act;
        ++this._depth;
        if (!allBound) {
            if (!elemName.isBound()) {
                this.reportUnboundPrefix(this._tokenName, false);
            }
            int len = this._attrCount;
            for (int i = 0; i < len; ++i) {
                PName attrName = this._attrCollector.getName(i);
                if (attrName.isBound()) continue;
                this.reportUnboundPrefix(attrName, true);
            }
        }
        return 1;
    }

    private int collectValue(int attrPtr, char quoteChar, PName attrName) throws XMLStreamException {
        char[] attrBuffer = this._attrCollector.startNewValue(attrName, attrPtr);
        int[] TYPES = ReaderScanner.sCharTypes.ATTR_CHARS;
        block9: while (true) {
            int c;
            block31: {
                int d;
                block30: {
                    block29: {
                        int max;
                        int max2;
                        int ptr;
                        if ((ptr = this._inputPtr) >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        if (attrPtr >= attrBuffer.length) {
                            attrBuffer = this._attrCollector.valueBufferFull();
                        }
                        if ((max2 = ptr + (attrBuffer.length - attrPtr)) < (max = this._inputEnd)) {
                            max = max2;
                        }
                        while (ptr < max) {
                            if ((c = this._inputBuffer[ptr++]) <= 255) {
                                if (TYPES[c] != 0) {
                                    this._inputPtr = ptr;
                                    break block29;
                                }
                            } else if (c >= 55296) {
                                this._inputPtr = ptr;
                                break block29;
                            }
                            attrBuffer[attrPtr++] = c;
                        }
                        this._inputPtr = ptr;
                        continue;
                    }
                    if (c > 255) break block30;
                    switch (TYPES[c]) {
                        case 1: {
                            c = this.handleInvalidXmlChar(c);
                        }
                        case 2: {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if (this._inputBuffer[this._inputPtr] == '\n') {
                                ++this._inputPtr;
                            }
                        }
                        case 3: {
                            this.markLF();
                        }
                        case 8: {
                            c = 32;
                            break;
                        }
                        case 9: {
                            this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
                        }
                        case 10: {
                            if (!this._config.willRetainAttributeGeneralEntities()) {
                                d = this.handleEntityInText(false);
                                if (d == 0) {
                                    this.reportUnexpandedEntityInAttr(attrName, false);
                                }
                                if (d >> 16 != 0) {
                                    attrBuffer[attrPtr++] = (char)(0xD800 | (d -= 65536) >> 10);
                                    d = 0xDC00 | d & 0x3FF;
                                    if (attrPtr >= attrBuffer.length) {
                                        attrBuffer = this._attrCollector.valueBufferFull();
                                    }
                                }
                                c = (char)d;
                                break;
                            }
                            break block31;
                        }
                        case 14: {
                            if (c == quoteChar) break block9;
                        }
                    }
                    break block31;
                }
                if (c >= 55296) {
                    if (c < 57344) {
                        d = this.checkSurrogate((char)c);
                        attrBuffer[attrPtr++] = c;
                        if (attrPtr >= attrBuffer.length) {
                            attrBuffer = this._attrCollector.valueBufferFull();
                        }
                        c = d;
                    } else if (c >= 65534) {
                        c = this.handleInvalidXmlChar(c);
                    }
                }
            }
            attrBuffer[attrPtr++] = c;
        }
        return attrPtr;
    }

    private void handleNsDeclaration(PName name, char quoteChar) throws XMLStreamException {
        int attrPtr = 0;
        char[] attrBuffer = this._nameBuffer;
        while (true) {
            char c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == quoteChar) break;
            if (c == '&') {
                int d = this.handleEntityInText(false);
                if (d == 0) {
                    this.reportUnexpandedEntityInAttr(name, true);
                }
                if (d >> 16 != 0) {
                    if (attrPtr >= attrBuffer.length) {
                        this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                    }
                    attrBuffer[attrPtr++] = (char)(0xD800 | (d -= 65536) >> 10);
                    d = 0xDC00 | d & 0x3FF;
                }
                c = (char)d;
            } else if (c == '<') {
                this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
            } else if (c < ' ') {
                if (c == '\n') {
                    this.markLF();
                } else if (c == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = '\n';
                } else if (c != '\t') {
                    this.throwInvalidSpace(c);
                }
            }
            if (attrPtr >= attrBuffer.length) {
                this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
            }
            attrBuffer[attrPtr++] = c;
        }
        if (attrPtr == 0) {
            this.bindNs(name, "");
        } else {
            String uri = this._config.canonicalizeURI(attrBuffer, attrPtr);
            this.bindNs(name, uri);
        }
    }

    protected final int handleEndElement() throws XMLStreamException {
        char c;
        --this._depth;
        this._currToken = 2;
        this._tokenName = this._currElem.getName();
        String pname = this._tokenName.getPrefixedName();
        int i = 0;
        int len = pname.length();
        do {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == pname.charAt(i)) continue;
            this.reportUnexpectedEndTag(pname);
        } while (++i < len);
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') {
            c = this.skipInternalWs(false, null);
        } else if (c != '>' && (c == ':' || XmlChars.is10NameChar(c))) {
            this.reportUnexpectedEndTag(pname);
        }
        if (c != '>') {
            this.throwUnexpectedChar(c, " expected space or closing '>'");
        }
        return 2;
    }

    protected final int handleEntityInText(boolean inAttr) throws XMLStreamException {
        int cix;
        String start;
        char c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '#') {
            return this.handleCharEntity();
        }
        if (c == 'a') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == 'm') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == 'p') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                        return 38;
                    }
                    start = "amp";
                } else {
                    start = "am";
                }
            } else if (c == 'p') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == 'o') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == 's') {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                            return 39;
                        }
                        start = "apos";
                    } else {
                        start = "apo";
                    }
                } else {
                    start = "ap";
                }
            } else {
                start = "a";
            }
        } else if (c == 'l') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == 't') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                    return 60;
                }
                start = "lt";
            } else {
                start = "l";
            }
        } else if (c == 'g') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == 't') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                    return 62;
                }
                start = "gt";
            } else {
                start = "g";
            }
        } else if (c == 'q') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == 'u') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == 'o') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == 't') {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                            return 34;
                        }
                        start = "quot";
                    } else {
                        start = "quo";
                    }
                } else {
                    start = "qu";
                }
            } else {
                start = "q";
            }
        } else {
            start = "";
        }
        int[] TYPES = ReaderScanner.sCharTypes.NAME_CHARS;
        char[] cbuf = this._nameBuffer;
        int len = start.length();
        for (cix = 0; cix < len; ++cix) {
            cbuf[cix] = start.charAt(cix);
        }
        while (c != ';') {
            boolean ok;
            if (c <= '\u00ff') {
                switch (TYPES[c]) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ok = cix > 0;
                        break;
                    }
                    case 3: {
                        ok = true;
                        break;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
            } else if (c < '\ue000') {
                int value = this.decodeSurrogate(c);
                if (cix >= cbuf.length) {
                    this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
                }
                cbuf[cix++] = c;
                c = this._inputBuffer[this._inputPtr - 1];
                ok = XmlChars.is10NameChar(value);
            } else if (c >= '\ufffe') {
                c = this.handleInvalidXmlChar(c);
                ok = false;
            } else {
                ok = true;
            }
            if (!ok) {
                this.reportInvalidNameChar(c, cix);
            }
            if (cix >= cbuf.length) {
                this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
            }
            cbuf[cix++] = c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            c = this._inputBuffer[this._inputPtr++];
        }
        String pname = new String(cbuf, 0, cix);
        this._tokenName = new PNameC(pname, null, pname, 0);
        if (this._config.willExpandEntities()) {
            this.reportInputProblem("General entity reference (&" + pname + ";) encountered in entity expanding mode: operation not (yet) implemented");
        }
        if (inAttr) {
            this.reportInputProblem("General entity reference (&" + pname + ";) encountered in attribute value, in non-entity-expanding mode: no way to handle it");
        }
        return 0;
    }

    @Override
    protected final void finishComment() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.resetWithEmpty();
        int outPtr = 0;
        block6: while (true) {
            int c;
            block27: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c] != 0) {
                            this._inputPtr = ptr;
                            break block27;
                        }
                    } else if (c >= 55296) {
                        this._inputPtr = ptr;
                        break block27;
                    }
                    outputBuffer[outPtr++] = c;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= 255) {
                switch (TYPES[c]) {
                    case 1: {
                        c = this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 13: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '-') {
                            ++this._inputPtr;
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if (this._inputBuffer[this._inputPtr++] == '>') break block6;
                            this.reportDoubleHyphenInComments();
                            break block6;
                        } else {
                            break;
                        }
                    }
                }
            } else if (c >= 55296) {
                if (c < 57344) {
                    char d = this.checkSurrogate((char)c);
                    outputBuffer[outPtr++] = c;
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = d;
                } else if (c >= 65534) {
                    c = this.handleInvalidXmlChar(c);
                }
            }
            outputBuffer[outPtr++] = c;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected final void finishPI() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.resetWithEmpty();
        int outPtr = 0;
        block5: while (true) {
            int c;
            block25: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c] != 0) {
                            this._inputPtr = ptr;
                            break block25;
                        }
                    } else if (c >= 55296) {
                        this._inputPtr = ptr;
                        break block25;
                    }
                    outputBuffer[outPtr++] = c;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= 255) {
                switch (TYPES[c]) {
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 12: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '>') {
                            ++this._inputPtr;
                            break block5;
                        } else {
                            break;
                        }
                    }
                }
            } else if (c >= 55296) {
                if (c < 57344) {
                    char d = this.checkSurrogate((char)c);
                    outputBuffer[outPtr++] = c;
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = d;
                } else if (c >= 65534) {
                    c = this.handleInvalidXmlChar(c);
                }
            }
            outputBuffer[outPtr++] = c;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected final void finishDTD(boolean copyContents) throws XMLStreamException {
        int c;
        char[] outputBuffer = copyContents ? this._textBuilder.resetWithEmpty() : null;
        int outPtr = 0;
        int[] TYPES = ReaderScanner.sCharTypes.DTD_CHARS;
        boolean inDecl = false;
        int quoteChar = 0;
        block9: while (true) {
            block35: {
                block34: {
                    block33: {
                        int ptr;
                        if ((ptr = this._inputPtr) >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        int max = this._inputEnd;
                        if (outputBuffer != null) {
                            int max2;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            if ((max2 = ptr + (outputBuffer.length - outPtr)) < max) {
                                max = max2;
                            }
                        }
                        while (ptr < max) {
                            if ((c = this._inputBuffer[ptr++]) <= 255) {
                                if (TYPES[c] != 0) {
                                    this._inputPtr = ptr;
                                    break block33;
                                }
                            } else if (c >= 55296) {
                                this._inputPtr = ptr;
                                break block33;
                            }
                            if (outputBuffer == null) continue;
                            outputBuffer[outPtr++] = c;
                        }
                        this._inputPtr = ptr;
                        continue;
                    }
                    if (c > 255) break block34;
                    switch (TYPES[c]) {
                        case 1: {
                            c = this.handleInvalidXmlChar(c);
                        }
                        case 2: {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if (this._inputBuffer[this._inputPtr] == '\n') {
                                ++this._inputPtr;
                            }
                            this.markLF();
                            c = 10;
                            break;
                        }
                        case 3: {
                            this.markLF();
                            break;
                        }
                        case 8: {
                            if (quoteChar == 0) {
                                quoteChar = c;
                                break;
                            }
                            if (quoteChar == c) {
                                quoteChar = 0;
                                break;
                            }
                            break block35;
                        }
                        case 9: {
                            if (!inDecl) {
                                inDecl = true;
                                break;
                            }
                            break block35;
                        }
                        case 10: {
                            if (quoteChar == 0) {
                                inDecl = false;
                                break;
                            }
                            break block35;
                        }
                        case 11: {
                            if (!inDecl && quoteChar == 0) break block9;
                        }
                    }
                    break block35;
                }
                if (c >= 55296) {
                    if (c < 57344) {
                        int d = this.checkSurrogate((char)c);
                        if (outputBuffer != null) {
                            outputBuffer[outPtr++] = c;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                        }
                        c = d;
                    } else if (c >= 65534) {
                        c = this.handleInvalidXmlChar(c);
                    }
                }
            }
            if (outputBuffer == null) continue;
            outputBuffer[outPtr++] = c;
        }
        if (outputBuffer != null) {
            this._textBuilder.setCurrentLength(outPtr);
        }
        if ((c = this.skipInternalWs(false, null)) != 62) {
            this.throwUnexpectedChar(c, " expected '>' after the internal subset");
        }
    }

    @Override
    protected final void finishCData() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.resetWithEmpty();
        int outPtr = 0;
        block6: while (true) {
            int c;
            block31: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c] != 0) {
                            this._inputPtr = ptr;
                            break block31;
                        }
                    } else if (c >= 55296) {
                        this._inputPtr = ptr;
                        break block31;
                    }
                    outputBuffer[outPtr++] = c;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= 255) {
                switch (TYPES[c]) {
                    case 1: {
                        c = this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 11: {
                        boolean ok;
                        char d;
                        int count = 0;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((d = this._inputBuffer[this._inputPtr]) != ']') break;
                            ++this._inputPtr;
                            ++count;
                        }
                        boolean bl = ok = d == '>' && count >= 1;
                        if (ok) {
                            --count;
                        }
                        while (count > 0) {
                            outputBuffer[outPtr++] = 93;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            --count;
                        }
                        if (ok) {
                            ++this._inputPtr;
                            break block6;
                        } else {
                            break;
                        }
                    }
                }
            } else if (c >= 55296) {
                if (c < 57344) {
                    char d = this.checkSurrogate((char)c);
                    outputBuffer[outPtr++] = c;
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = d;
                } else if (c >= 65534) {
                    c = this.handleInvalidXmlChar(c);
                }
            }
            outputBuffer[outPtr++] = c;
        }
        this._textBuilder.setCurrentLength(outPtr);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    @Override
    protected final void finishCharacters() throws XMLStreamException {
        int outPtr;
        char[] outputBuffer;
        int c = this.mTmpChar;
        if (c < 0) {
            c = -c;
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
            if (c >> 16 != 0) {
                outputBuffer[outPtr++] = (char)(0xD800 | (c -= 65536) >> 10);
                c = 0xDC00 | c & 0x3FF;
            }
            outputBuffer[outPtr++] = (char)c;
        } else if (c == 13 || c == 10) {
            ++this._inputPtr;
            outPtr = this.checkInTreeIndentation((char)c);
            if (outPtr < 0) {
                return;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
        } else {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
        }
        int[] TYPES = ReaderScanner.sCharTypes.TEXT_CHARS;
        char[] inputBuffer = this._inputBuffer;
        block8: while (true) {
            int d;
            int c2;
            int ptr;
            block41: {
                int max;
                int max2;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c2 = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c2] != 0) {
                            this._inputPtr = ptr;
                            break block41;
                        }
                    } else if (c2 >= 55296) {
                        this._inputPtr = ptr;
                        break block41;
                    }
                    outputBuffer[outPtr++] = c2;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c2 <= 255) {
                switch (TYPES[c2]) {
                    case 1: {
                        c2 = this.handleInvalidXmlChar(c2);
                    }
                    case 2: {
                        ptr = this._inputPtr;
                        if (ptr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        if (inputBuffer[ptr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 9: {
                        --this._inputPtr;
                        break block8;
                    }
                    case 10: {
                        d = this.handleEntityInText(false);
                        if (d == 0) {
                            this._entityPending = true;
                            break block8;
                        }
                        if (d >> 16 != 0) {
                            outputBuffer[outPtr++] = (char)(0xD800 | (d -= 65536) >> 10);
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            d = 0xDC00 | d & 0x3FF;
                        }
                        c2 = (char)d;
                        break;
                    }
                    case 11: {
                        int count = 1;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((c2 = inputBuffer[this._inputPtr]) != 93) break;
                            ++this._inputPtr;
                            ++count;
                        }
                        if (c2 == 62 && count > 1) {
                            this.reportIllegalCDataEnd();
                        }
                        while (count > 1) {
                            outputBuffer[outPtr++] = 93;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            --count;
                        }
                        c2 = 93;
                    }
                }
            } else if (c2 >= 55296) {
                if (c2 < 57344) {
                    d = this.checkSurrogate((char)c2);
                    outputBuffer[outPtr++] = c2;
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c2 = d;
                } else if (c2 >= 65534) {
                    c2 = this.handleInvalidXmlChar(c2);
                }
            }
            outputBuffer[outPtr++] = c2;
        }
        this._textBuilder.setCurrentLength(outPtr);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    @Override
    protected final void finishSpace() throws XMLStreamException {
        char[] outputBuffer;
        int outPtr;
        char tmp = (char)this.mTmpChar;
        if (tmp == '\r' || tmp == '\n') {
            outPtr = this.checkPrologIndentation(tmp);
            if (outPtr < 0) {
                return;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
        } else {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = tmp;
            outPtr = 1;
        }
        int ptr = this._inputPtr;
        while (true) {
            int c;
            if (ptr >= this._inputEnd) {
                if (!this.loadMore()) break;
                ptr = this._inputPtr;
            }
            if ((c = this._inputBuffer[ptr]) > 32) break;
            ++ptr;
            if (c == 10) {
                this.markLF(ptr);
            } else if (c == 13) {
                if (ptr >= this._inputEnd) {
                    if (!this.loadMore()) {
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        outputBuffer[outPtr++] = 10;
                        break;
                    }
                    ptr = this._inputPtr;
                }
                if (this._inputBuffer[ptr] == '\n') {
                    ++ptr;
                }
                this.markLF(ptr);
                c = 10;
            } else if (c != 32 && c != 9) {
                this._inputPtr = ptr;
                this.throwInvalidSpace(c);
            }
            if (outPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outPtr = 0;
            }
            outputBuffer[outPtr++] = c;
        }
        this._inputPtr = ptr;
        this._textBuilder.setCurrentLength(outPtr);
    }

    protected final void finishCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return;
            }
            if (this._inputBuffer[this._inputPtr] == '<') {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain(3)) {
                    return;
                }
                if (this._inputBuffer[this._inputPtr + 1] != '!' || this._inputBuffer[this._inputPtr + 2] != '[') {
                    return;
                }
                this._inputPtr += 3;
                for (int i = 0; i < 6; ++i) {
                    char c;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == "CDATA[".charAt(i)) continue;
                    this.reportTreeUnexpChar(c, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
                }
                this.finishCoalescedCData();
                continue;
            }
            this.finishCoalescedCharacters();
            if (this._entityPending) break;
        }
    }

    protected final void finishCoalescedCData() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.getBufferWithoutReset();
        int outPtr = this._textBuilder.getCurrentLength();
        block6: while (true) {
            int c;
            block30: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c] != 0) {
                            this._inputPtr = ptr;
                            break block30;
                        }
                    } else if (c >= 55296) {
                        this._inputPtr = ptr;
                        break block30;
                    }
                    outputBuffer[outPtr++] = c;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= 255) {
                switch (TYPES[c]) {
                    case 1: {
                        c = this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 11: {
                        boolean ok;
                        char d;
                        int count = 0;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((d = this._inputBuffer[this._inputPtr]) != ']') break;
                            ++this._inputPtr;
                            ++count;
                        }
                        boolean bl = ok = d == '>' && count >= 1;
                        if (ok) {
                            --count;
                        }
                        while (count > 0) {
                            outputBuffer[outPtr++] = 93;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            --count;
                        }
                        if (ok) {
                            ++this._inputPtr;
                            break block6;
                        } else {
                            break;
                        }
                    }
                }
            } else if (c >= 55296) {
                if (c < 57344) {
                    char d = this.checkSurrogate((char)c);
                    outputBuffer[outPtr++] = c;
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = d;
                } else if (c >= 65534) {
                    c = this.handleInvalidXmlChar(c);
                }
            }
            outputBuffer[outPtr++] = c;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    protected final void finishCoalescedCharacters() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.TEXT_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.getBufferWithoutReset();
        int outPtr = this._textBuilder.getCurrentLength();
        block8: while (true) {
            int d;
            int c;
            int ptr;
            block34: {
                int max;
                int max2;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c] != 0) {
                            this._inputPtr = ptr;
                            break block34;
                        }
                    } else if (c >= 55296) {
                        this._inputPtr = ptr;
                        break block34;
                    }
                    outputBuffer[outPtr++] = c;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= 255) {
                switch (TYPES[c]) {
                    case 1: {
                        c = this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        ptr = this._inputPtr;
                        if (ptr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        if (inputBuffer[ptr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 9: {
                        --this._inputPtr;
                        break block8;
                    }
                    case 10: {
                        d = this.handleEntityInText(false);
                        if (d == 0) {
                            this._entityPending = true;
                            break block8;
                        }
                        if (d >> 16 != 0) {
                            outputBuffer[outPtr++] = (char)(0xD800 | (d -= 65536) >> 10);
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            d = 0xDC00 | d & 0x3FF;
                        }
                        c = (char)d;
                        break;
                    }
                    case 11: {
                        int count = 1;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((c = inputBuffer[this._inputPtr]) != 93) break;
                            ++this._inputPtr;
                            ++count;
                        }
                        if (c == 62 && count > 1) {
                            this.reportIllegalCDataEnd();
                        }
                        while (count > 1) {
                            outputBuffer[outPtr++] = 93;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            --count;
                        }
                        c = 93;
                    }
                }
            } else if (c >= 55296) {
                if (c < 57344) {
                    d = this.checkSurrogate((char)c);
                    outputBuffer[outPtr++] = c;
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = d;
                } else if (c >= 65534) {
                    c = this.handleInvalidXmlChar(c);
                }
            }
            outputBuffer[outPtr++] = c;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected final boolean skipCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return false;
            }
            if (this._inputBuffer[this._inputPtr] == '<') {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain(3)) {
                    return false;
                }
                if (this._inputBuffer[this._inputPtr + 1] != '!' || this._inputBuffer[this._inputPtr + 2] != '[') {
                    return false;
                }
                this._inputPtr += 3;
                for (int i = 0; i < 6; ++i) {
                    char c;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == "CDATA[".charAt(i)) continue;
                    this.reportTreeUnexpChar(c, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
                }
                this.skipCData();
                continue;
            }
            if (this.skipCharacters()) break;
        }
        return true;
    }

    @Override
    protected final void skipComment() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        while (true) {
            char c;
            block16: {
                int max;
                int ptr;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= '\u00ff') {
                        if (TYPES[c] == 0) continue;
                        this._inputPtr = ptr;
                    } else {
                        if (c < '\ud800') continue;
                        this._inputPtr = ptr;
                    }
                    break block16;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c > '\u00ff') continue;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 13: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] != '-') break;
                    ++this._inputPtr;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr++] != '>') {
                        this.reportDoubleHyphenInComments();
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected final void skipPI() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        while (true) {
            char c;
            block15: {
                int max;
                int ptr;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= '\u00ff') {
                        if (TYPES[c] == 0) continue;
                        this._inputPtr = ptr;
                    } else {
                        if (c < '\ud800') continue;
                        this._inputPtr = ptr;
                    }
                    break block15;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= '\u00ff') {
                switch (TYPES[c]) {
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 12: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] != '>') break;
                        ++this._inputPtr;
                        return;
                    }
                }
                continue;
            }
            if (c < '\ud800') continue;
            if (c < '\ue000') {
                this.checkSurrogate(c);
                continue;
            }
            if (c < '\ufffe') continue;
            char c2 = this.handleInvalidXmlChar(c);
        }
    }

    @Override
    protected final boolean skipCharacters() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.TEXT_CHARS;
        char[] inputBuffer = this._inputBuffer;
        block8: while (true) {
            char c;
            block19: {
                int max;
                int ptr;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= '\u00ff') {
                        if (TYPES[c] == 0) continue;
                        this._inputPtr = ptr;
                    } else {
                        if (c < '\ud800') continue;
                        this._inputPtr = ptr;
                    }
                    break block19;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= '\u00ff') {
                switch (TYPES[c]) {
                    case 1: {
                        c = this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 9: {
                        --this._inputPtr;
                        return false;
                    }
                    case 10: {
                        int d = this.handleEntityInText(false);
                        if (d != 0) continue block8;
                        return true;
                    }
                    case 11: {
                        int count = 1;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((c = inputBuffer[this._inputPtr]) != ']') break;
                            ++this._inputPtr;
                            ++count;
                        }
                        if (c != '>' || count <= true) break;
                        this.reportIllegalCDataEnd();
                    }
                }
                continue;
            }
            if (c < '\ud800') continue;
            if (c < '\ue000') {
                this.checkSurrogate(c);
                continue;
            }
            if (c < '\ufffe') continue;
            char c2 = this.handleInvalidXmlChar(c);
        }
    }

    @Override
    protected final void skipCData() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        while (true) {
            char c;
            int ptr;
            block18: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= '\u00ff') {
                        if (TYPES[c] == 0) continue;
                        this._inputPtr = ptr;
                    } else {
                        if (c < '\ud800') continue;
                        this._inputPtr = ptr;
                    }
                    break block18;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= '\u00ff') {
                switch (TYPES[c]) {
                    case 1: {
                        c = this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        ptr = this._inputPtr;
                        if (ptr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        if (inputBuffer[ptr] == '\n') {
                            ++ptr;
                            ++this._inputPtr;
                        }
                        this.markLF(ptr);
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 11: {
                        int count = 0;
                        do {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            ++count;
                        } while ((c = this._inputBuffer[this._inputPtr++]) == ']');
                        if (c == '>') {
                            if (count <= 1) break;
                            return;
                        }
                        --this._inputPtr;
                    }
                }
                continue;
            }
            if (c < '\ud800') continue;
            if (c < '\ue000') {
                this.checkSurrogate(c);
                continue;
            }
            if (c < '\ufffe') continue;
            char c2 = this.handleInvalidXmlChar(c);
        }
    }

    @Override
    protected final void skipSpace() throws XMLStreamException {
        int ptr = this._inputPtr;
        while (true) {
            char c;
            if (ptr >= this._inputEnd) {
                if (!this.loadMore()) break;
                ptr = this._inputPtr;
            }
            if ((c = this._inputBuffer[ptr]) > ' ') break;
            ++ptr;
            if (c == '\n') {
                this.markLF(ptr);
                continue;
            }
            if (c == '\r') {
                if (ptr >= this._inputEnd) {
                    if (!this.loadMore()) break;
                    ptr = this._inputPtr;
                }
                if (this._inputBuffer[ptr] == '\n') {
                    ++ptr;
                }
                this.markLF(ptr);
                continue;
            }
            if (c == ' ' || c == '\t') continue;
            this._inputPtr = ptr;
            this.throwInvalidSpace(c);
        }
        this._inputPtr = ptr;
    }

    protected char skipInternalWs(boolean reqd, String msg) throws XMLStreamException {
        char c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
            if (!reqd) {
                return c;
            }
            this.reportTreeUnexpChar(c, " (expected white space " + msg + ")");
        }
        do {
            if (c == '\n') {
                this.markLF();
            } else if (c == '\r') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if (this._inputBuffer[this._inputPtr] == '\n') {
                    ++this._inputPtr;
                }
                this.markLF();
            } else if (c != ' ' && c != '\t') {
                this.throwInvalidSpace(c);
            }
            if (this._inputPtr < this._inputEnd) continue;
            this.loadMoreGuaranteed();
        } while ((c = this._inputBuffer[this._inputPtr++]) <= ' ');
        return c;
    }

    private final void matchAsciiKeyword(String keyw) throws XMLStreamException {
        int len = keyw.length();
        for (int i = 1; i < len; ++i) {
            char c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == keyw.charAt(i)) continue;
            this.reportTreeUnexpChar(c, " (expected '" + keyw.charAt(i) + "' for " + keyw + " keyword)");
        }
    }

    protected final int checkInTreeIndentation(char c) throws XMLStreamException {
        int count;
        int max;
        if (c == '\r') {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == '\n') {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr]) != ' ' && c != '\t') {
            if (c == '<' && this._inputPtr + 1 < this._inputEnd && this._inputBuffer[this._inputPtr + 1] != '!') {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int n = max = c == ' ' ? 32 : 8;
        for (count = 1; count <= max; ++count) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr]) != c) {
                if (c2 != '<' || this._inputPtr + 1 >= this._inputEnd || this._inputBuffer[this._inputPtr + 1] == '!') break;
                this._textBuilder.resetWithIndentation(count, c);
                return -1;
            }
            ++this._inputPtr;
        }
        char[] outputBuffer = this._textBuilder.resetWithEmpty();
        outputBuffer[0] = 10;
        for (int i = 1; i <= count; ++i) {
            outputBuffer[i] = c;
        }
        this._textBuilder.setCurrentLength(++count);
        return count;
    }

    protected final int checkPrologIndentation(char c) throws XMLStreamException {
        int max;
        if (c == '\r') {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == '\n') {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._textBuilder.resetWithIndentation(0, ' ');
            return -1;
        }
        c = this._inputBuffer[this._inputPtr];
        if (c != ' ' && c != '\t') {
            if (c == '<') {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int count = 1;
        int n = max = c == ' ' ? 32 : 8;
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == c) {
            ++this._inputPtr;
            if (++count < max) continue;
            char[] outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = 10;
            for (int i = 1; i <= count; ++i) {
                outputBuffer[i] = c;
            }
            this._textBuilder.setCurrentLength(++count);
            return count;
        }
        this._textBuilder.resetWithIndentation(count, c);
        return -1;
    }

    protected PName parsePName(char c) throws XMLStreamException {
        char[] nameBuffer = this._nameBuffer;
        if (c < 65) {
            this.throwUnexpectedChar(c, "; expected a name start character");
        }
        nameBuffer[0] = c;
        int hash = c;
        int ptr = 1;
        while (true) {
            int d;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((d = (c = this._inputBuffer[this._inputPtr])) < 65 && (d < 45 || d > 58 || d == 47)) {
                PName n = this._symbols.findSymbol(nameBuffer, 0, ptr, hash);
                if (n == null) {
                    n = this.addPName(nameBuffer, ptr, hash);
                }
                return n;
            }
            ++this._inputPtr;
            if (ptr >= nameBuffer.length) {
                this._nameBuffer = nameBuffer = DataUtil.growArrayBy(nameBuffer, nameBuffer.length);
            }
            nameBuffer[ptr++] = c;
            hash = hash * 31 + d;
        }
    }

    protected final PName addPName(char[] nameBuffer, int nameLen, int hash) throws XMLStreamException {
        char c = nameBuffer[0];
        int namePtr = 1;
        int last_colon = -1;
        if (c < '\ud800' || c >= '\ue000') {
            if (!XmlChars.is10NameStartChar(c)) {
                this.reportInvalidNameChar(c, 0);
            }
        } else {
            if (nameLen == 1) {
                this.reportInvalidFirstSurrogate(c);
            }
            this.checkSurrogateNameChar(c, nameBuffer[1], 0);
            ++namePtr;
        }
        while (namePtr < nameLen) {
            c = nameBuffer[namePtr];
            if (c < '\ud800' || c >= '\ue000') {
                if (c == ':') {
                    if (last_colon >= 0) {
                        this.reportMultipleColonsInName();
                    }
                    last_colon = namePtr;
                } else if (!XmlChars.is10NameChar(c)) {
                    this.reportInvalidNameChar(c, namePtr);
                }
            } else {
                if (namePtr + 1 >= nameLen) {
                    this.reportInvalidFirstSurrogate(c);
                }
                this.checkSurrogateNameChar(c, nameBuffer[namePtr + 1], namePtr);
            }
            ++namePtr;
        }
        return this._symbols.addSymbol(nameBuffer, 0, nameLen, hash);
    }

    protected String parsePublicId(char quoteChar) throws XMLStreamException {
        char[] outputBuffer = this._nameBuffer;
        int outPtr = 0;
        int[] TYPES = XmlCharTypes.PUBID_CHARS;
        boolean addSpace = false;
        while (true) {
            char c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == quoteChar) break;
            if (c > '\u00ff' || TYPES[c] != 1) {
                this.throwUnexpectedChar(c, " in public identifier");
            }
            if (c <= ' ') {
                addSpace = true;
                continue;
            }
            if (addSpace) {
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                outputBuffer[outPtr++] = 32;
                addSpace = false;
            }
            if (outPtr >= outputBuffer.length) {
                this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                outPtr = 0;
            }
            outputBuffer[outPtr++] = c;
        }
        return new String(outputBuffer, 0, outPtr);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String parseSystemId(char quoteChar) throws XMLStreamException {
        char[] outputBuffer = this._nameBuffer;
        int outPtr = 0;
        int[] TYPES = ReaderScanner.sCharTypes.ATTR_CHARS;
        while (true) {
            int c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (TYPES[c = this._inputBuffer[this._inputPtr++]] != 0) {
                switch (TYPES[c]) {
                    case 1: {
                        c = this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 14: {
                        if (c != quoteChar) break;
                        return new String(outputBuffer, 0, outPtr);
                    }
                }
            }
            if (outPtr >= outputBuffer.length) {
                this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                outPtr = 0;
            }
            outputBuffer[outPtr++] = c;
        }
    }

    private char checkSurrogate(char firstChar) throws XMLStreamException {
        int val;
        char sec;
        if (firstChar >= '\udc00') {
            this.reportInvalidFirstSurrogate(firstChar);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((sec = this._inputBuffer[this._inputPtr++]) < '\udc00' || sec >= '\ue000') {
            this.reportInvalidSecondSurrogate(sec);
        }
        if ((val = (firstChar - 55296 << 10) + 65536) > 0x10FFFF) {
            this.reportInvalidXmlChar(val);
        }
        return sec;
    }

    private int checkSurrogateNameChar(char firstChar, char sec, int index) throws XMLStreamException {
        int val;
        if (firstChar >= '\udc00') {
            this.reportInvalidFirstSurrogate(firstChar);
        }
        if (sec < '\udc00' || sec >= '\ue000') {
            this.reportInvalidSecondSurrogate(sec);
        }
        if ((val = (firstChar - 55296 << 10) + 65536) > 0x10FFFF) {
            this.reportInvalidXmlChar(val);
        }
        this.reportInvalidNameChar(val, index);
        return val;
    }

    private int decodeSurrogate(char firstChar) throws XMLStreamException {
        int val;
        char sec;
        if (firstChar >= '\udc00') {
            this.reportInvalidFirstSurrogate(firstChar);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((sec = this._inputBuffer[this._inputPtr++]) < '\udc00' || sec >= '\ue000') {
            this.reportInvalidSecondSurrogate(sec);
        }
        if ((val = (firstChar - 55296 << 10) + 65536) > 0x10FFFF) {
            this.reportInvalidXmlChar(val);
        }
        return val;
    }

    private void reportInvalidFirstSurrogate(char ch) throws XMLStreamException {
        this.reportInputProblem("Invalid surrogate character (code 0x" + Integer.toHexString(ch) + "): can not start a surrogate pair");
    }

    private void reportInvalidSecondSurrogate(char ch) throws XMLStreamException {
        this.reportInputProblem("Invalid surrogate character (code " + Integer.toHexString(ch) + "): is not legal as the second part of a surrogate pair");
    }

    @Override
    public XMLStreamLocation2 getCurrentLocation() {
        return LocationImpl.fromZeroBased(this._config.getPublicId(), this._config.getSystemId(), this._pastBytesOrChars + (long)this._inputPtr, this._currRow, this._inputPtr - this._rowStartOffset);
    }

    @Override
    public int getCurrentColumnNr() {
        return this._inputPtr - this._rowStartOffset;
    }

    @Override
    public long getStartingByteOffset() {
        return -1L;
    }

    @Override
    public long getStartingCharOffset() {
        return this._startRawOffset;
    }

    @Override
    public long getEndingByteOffset() throws XMLStreamException {
        return -1L;
    }

    @Override
    public long getEndingCharOffset() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._pastBytesOrChars + (long)this._inputPtr;
    }

    protected final void markLF(int offset) {
        this._rowStartOffset = offset;
        ++this._currRow;
    }

    protected final void markLF() {
        this._rowStartOffset = this._inputPtr;
        ++this._currRow;
    }

    protected final void setStartLocation() {
        this._startRawOffset = this._pastBytesOrChars + (long)this._inputPtr;
        this._startRow = this._currRow;
        this._startColumn = this._inputPtr - this._rowStartOffset;
    }

    @Override
    protected final boolean loadMore() throws XMLStreamException {
        if (this._in == null) {
            this._inputEnd = 0;
            return false;
        }
        this._pastBytesOrChars += (long)this._inputEnd;
        this._rowStartOffset -= this._inputEnd;
        this._inputPtr = 0;
        try {
            int count = this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (count < 1) {
                this._inputEnd = 0;
                if (count == 0) {
                    this.reportInputProblem("Reader returned 0 bytes, even when asked to read up to " + this._inputBuffer.length);
                }
                return false;
            }
            this._inputEnd = count;
            return true;
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected final char loadOne() throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final char loadOne(int type) throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(type));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final boolean loadAndRetain(int nrOfChars) throws XMLStreamException {
        if (this._in == null) {
            return false;
        }
        this._pastBytesOrChars += (long)this._inputPtr;
        this._rowStartOffset -= this._inputPtr;
        int remaining = this._inputEnd - this._inputPtr;
        System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, remaining);
        this._inputPtr = 0;
        this._inputEnd = remaining;
        try {
            do {
                int max;
                int count;
                if ((count = this._in.read(this._inputBuffer, this._inputEnd, max = this._inputBuffer.length - this._inputEnd)) < 1) {
                    if (count == 0) {
                        this.reportInputProblem("Reader returned 0 bytes, even when asked to read up to " + max);
                    }
                    return false;
                }
                this._inputEnd += count;
            } while (this._inputEnd < nrOfChars);
            return true;
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }
}

