/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.toolwindow.impl;

import com.intellij.frontend.FrontendApplicationInfo;
import com.intellij.frontend.FrontendType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.terminal.frontend.toolwindow.TerminalToolWindowTabsManager;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.content.ContentManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalEngine;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.fus.TerminalStartupFusInfo;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001aR\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u001a\b\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u000f"}, d2={"createTerminalTab", "", "project", "Lcom/intellij/openapi/project/Project;", "shellCommand", "", "", "workingDirectory", "tabName", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "startupFusInfo", "Lorg/jetbrains/plugins/terminal/fus/TerminalStartupFusInfo;", "shouldUseReworkedTerminal", "", "intellij.terminal.frontend"})
public final class TerminalInternalUtilsKt {
    public static final void createTerminalTab(@NotNull Project project, @Nullable List<String> shellCommand, @Nullable String workingDirectory, @NlsSafe @Nullable String tabName, @Nullable ContentManager contentManager, @Nullable TerminalStartupFusInfo startupFusInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (TerminalInternalUtilsKt.shouldUseReworkedTerminal()) {
            TerminalToolWindowTabsManager.Companion.getInstance(project).createTabBuilder().shellCommand(shellCommand).workingDirectory(workingDirectory).tabName(tabName).contentManager(contentManager).startupFusInfo(startupFusInfo).createTab();
        } else {
            TerminalTabState terminalTabState;
            TerminalTabState it = terminalTabState = new TerminalTabState();
            boolean bl = false;
            it.myShellCommand = shellCommand;
            it.myWorkingDirectory = workingDirectory;
            it.myTabName = tabName;
            TerminalTabState tabState = terminalTabState;
            TerminalEngine engine = TerminalOptionsProvider.Companion.getInstance().getTerminalEngine();
            TerminalWidget terminalWidget = TerminalToolWindowManager.getInstance(project).createNewTab(engine, tabState, contentManager);
            Intrinsics.checkNotNull((Object)terminalWidget);
        }
    }

    public static /* synthetic */ void createTerminalTab$default(Project project, List list, String string, String string2, ContentManager contentManager, TerminalStartupFusInfo terminalStartupFusInfo, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            contentManager = null;
        }
        if ((n & 0x20) != 0) {
            terminalStartupFusInfo = null;
        }
        TerminalInternalUtilsKt.createTerminalTab(project, list, string, string2, contentManager, terminalStartupFusInfo);
    }

    public static final boolean shouldUseReworkedTerminal() {
        TerminalEngine engine = TerminalOptionsProvider.Companion.getInstance().getTerminalEngine();
        FrontendType frontendType = FrontendApplicationInfo.INSTANCE.getFrontendType();
        boolean isCodeWithMe = frontendType instanceof FrontendType.Remote && ((FrontendType.Remote)frontendType).isGuest();
        return ExperimentalUI.Companion.isNewUI() && engine == TerminalEngine.REWORKED && !isCodeWithMe;
    }
}

