/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.util.BytesRef;

public final class MultiPostingsEnum
extends PostingsEnum {
    private final MultiTermsEnum parent;
    final PostingsEnum[] subPostingsEnums;
    private final EnumWithSlice[] subs;
    int numSubs;
    int upto;
    PostingsEnum current;
    int currentBase;
    int doc = -1;

    public MultiPostingsEnum(MultiTermsEnum parent, int subReaderCount) {
        this.parent = parent;
        this.subPostingsEnums = new PostingsEnum[subReaderCount];
        this.subs = new EnumWithSlice[subReaderCount];
        for (int i = 0; i < this.subs.length; ++i) {
            this.subs[i] = new EnumWithSlice();
        }
    }

    public boolean canReuse(MultiTermsEnum parent) {
        return this.parent == parent;
    }

    public MultiPostingsEnum reset(EnumWithSlice[] subs, int numSubs) {
        this.numSubs = numSubs;
        for (int i = 0; i < numSubs; ++i) {
            this.subs[i].postingsEnum = subs[i].postingsEnum;
            this.subs[i].slice = subs[i].slice;
        }
        this.upto = -1;
        this.doc = -1;
        this.current = null;
        return this;
    }

    public int getNumSubs() {
        return this.numSubs;
    }

    public EnumWithSlice[] getSubs() {
        return this.subs;
    }

    @Override
    public int freq() throws IOException {
        assert (this.current != null);
        return this.current.freq();
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        assert (target > this.doc);
        while (true) {
            if (this.current != null) {
                int doc = target < this.currentBase ? this.current.nextDoc() : this.current.advance(target - this.currentBase);
                if (doc == Integer.MAX_VALUE) {
                    this.current = null;
                    continue;
                }
                this.doc = doc + this.currentBase;
                return this.doc;
            }
            if (this.upto == this.numSubs - 1) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            ++this.upto;
            this.current = this.subs[this.upto].postingsEnum;
            this.currentBase = this.subs[this.upto].slice.start();
        }
    }

    @Override
    public int nextDoc() throws IOException {
        while (true) {
            int doc;
            if (this.current == null) {
                if (this.upto == this.numSubs - 1) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                ++this.upto;
                this.current = this.subs[this.upto].postingsEnum;
                this.currentBase = this.subs[this.upto].slice.start();
            }
            if ((doc = this.current.nextDoc()) != Integer.MAX_VALUE) {
                this.doc = this.currentBase + doc;
                return this.doc;
            }
            this.current = null;
        }
    }

    @Override
    public int nextPosition() throws IOException {
        return this.current.nextPosition();
    }

    @Override
    public int startOffset() throws IOException {
        return this.current.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.current.endOffset();
    }

    @Override
    public BytesRef getPayload() throws IOException {
        return this.current.getPayload();
    }

    @Override
    public long cost() {
        long cost = 0L;
        for (int i = 0; i < this.numSubs; ++i) {
            cost += this.subs[i].postingsEnum.cost();
        }
        return cost;
    }

    public String toString() {
        return "MultiDocsAndPositionsEnum(" + Arrays.toString(this.getSubs()) + ")";
    }

    public static final class EnumWithSlice {
        public PostingsEnum postingsEnum;
        public ReaderSlice slice;

        EnumWithSlice() {
        }

        public String toString() {
            return this.slice.toString() + ":" + String.valueOf(this.postingsEnum);
        }
    }
}

