/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene103.blocktree;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.lucene103.blocktree.FieldReader;
import org.apache.lucene.codecs.lucene103.blocktree.SegmentTermsEnumFrame;
import org.apache.lucene.codecs.lucene103.blocktree.Stats;
import org.apache.lucene.codecs.lucene103.blocktree.TrieReader;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOBooleanSupplier;
import org.apache.lucene.util.RamUsageEstimator;

final class SegmentTermsEnum
extends BaseTermsEnum {
    IndexInput in;
    private SegmentTermsEnumFrame[] stack = new SegmentTermsEnumFrame[0];
    private final SegmentTermsEnumFrame staticFrame;
    SegmentTermsEnumFrame currentFrame;
    boolean termExists;
    final FieldReader fr;
    private int targetBeforeCurrentLength;
    private int validIndexPrefix;
    private boolean eof;
    final BytesRefBuilder term = new BytesRefBuilder();
    private final TrieReader trieReader;
    private TrieReader.Node[] nodes = new TrieReader.Node[1];

    public SegmentTermsEnum(FieldReader fr, TrieReader reader) throws IOException {
        this.fr = fr;
        this.staticFrame = new SegmentTermsEnumFrame(this, -1);
        this.trieReader = reader;
        this.currentFrame = this.staticFrame;
        this.nodes[0] = this.trieReader.root;
        this.validIndexPrefix = 0;
    }

    void initIndexInput() {
        if (this.in == null) {
            this.in = this.fr.parent.termsIn.clone();
        }
    }

    public Stats computeBlockStats() throws IOException {
        Stats stats = new Stats(this.fr.parent.segment, this.fr.fieldInfo.name);
        this.currentFrame = this.staticFrame;
        TrieReader.Node node = this.nodes[0] = this.trieReader.root;
        this.currentFrame = this.pushFrame(node, 0);
        this.currentFrame.fpOrig = this.currentFrame.fp;
        this.currentFrame.loadBlock();
        this.validIndexPrefix = 0;
        stats.startBlock(this.currentFrame, !this.currentFrame.isLastInFloor);
        while (true) {
            if (this.currentFrame.nextEnt == this.currentFrame.entCount) {
                stats.endBlock(this.currentFrame);
                if (!this.currentFrame.isLastInFloor) {
                    this.currentFrame.loadNextFloorBlock();
                    stats.startBlock(this.currentFrame, true);
                } else {
                    if (this.currentFrame.ord == 0) break;
                    long lastFP = this.currentFrame.fpOrig;
                    this.currentFrame = this.stack[this.currentFrame.ord - 1];
                    assert (lastFP == this.currentFrame.lastSubFP);
                    continue;
                }
            }
            while (this.currentFrame.next()) {
                this.currentFrame = this.pushFrame(null, this.currentFrame.lastSubFP, this.term.length());
                this.currentFrame.fpOrig = this.currentFrame.fp;
                this.currentFrame.loadBlock();
                stats.startBlock(this.currentFrame, !this.currentFrame.isLastInFloor);
            }
            stats.term(this.term.get());
        }
        stats.finish();
        this.currentFrame = this.staticFrame;
        node = this.nodes[0] = this.trieReader.root;
        assert (node.hasOutput());
        this.currentFrame = this.pushFrame(node, 0);
        this.currentFrame.rewind();
        this.currentFrame.loadBlock();
        this.validIndexPrefix = 0;
        this.term.clear();
        return stats;
    }

    private SegmentTermsEnumFrame getFrame(int ord) throws IOException {
        if (ord >= this.stack.length) {
            SegmentTermsEnumFrame[] next = new SegmentTermsEnumFrame[ArrayUtil.oversize(1 + ord, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.stack, 0, next, 0, this.stack.length);
            for (int stackOrd = this.stack.length; stackOrd < next.length; ++stackOrd) {
                next[stackOrd] = new SegmentTermsEnumFrame(this, stackOrd);
            }
            this.stack = next;
        }
        assert (this.stack[ord].ord == ord);
        return this.stack[ord];
    }

    private TrieReader.Node getNode(int ord) {
        if (ord >= this.nodes.length) {
            TrieReader.Node[] next = new TrieReader.Node[ArrayUtil.oversize(1 + ord, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.nodes, 0, next, 0, this.nodes.length);
            for (int nodeOrd = this.nodes.length; nodeOrd < next.length; ++nodeOrd) {
                next[nodeOrd] = new TrieReader.Node();
            }
            this.nodes = next;
        }
        return this.nodes[ord];
    }

    SegmentTermsEnumFrame pushFrame(TrieReader.Node node, int length) throws IOException {
        SegmentTermsEnumFrame f = this.getFrame(1 + this.currentFrame.ord);
        f.hasTermsOrig = f.hasTerms = node.hasTerms;
        f.isFloor = node.isFloor();
        if (f.isFloor) {
            f.setFloorData(node.floorData(this.trieReader));
        }
        this.pushFrame(node, node.outputFp, length);
        return f;
    }

    SegmentTermsEnumFrame pushFrame(TrieReader.Node node, long fp, int length) throws IOException {
        SegmentTermsEnumFrame f = this.getFrame(1 + this.currentFrame.ord);
        f.node = node;
        if (f.fpOrig == fp && f.nextEnt != -1) {
            if (f.ord > this.targetBeforeCurrentLength) {
                f.rewind();
            }
            assert (length == f.prefixLength);
        } else {
            f.nextEnt = -1;
            f.prefixLength = length;
            f.state.termBlockOrd = 0;
            f.fpOrig = f.fp = fp;
            f.lastSubFP = -1L;
        }
        return f;
    }

    private boolean clearEOF() {
        this.eof = false;
        return true;
    }

    private boolean setEOF() {
        this.eof = true;
        return true;
    }

    private IOBooleanSupplier prepareSeekExact(BytesRef target, boolean prefetch) throws IOException {
        int targetUpto;
        TrieReader.Node node;
        if (this.fr.size() > 0L && (target.compareTo(this.fr.getMin()) < 0 || target.compareTo(this.fr.getMax()) > 0)) {
            return null;
        }
        this.term.grow(1 + target.length);
        assert (this.clearEOF());
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        if (this.currentFrame != this.staticFrame) {
            node = this.nodes[0];
            assert (node.hasOutput());
            SegmentTermsEnumFrame lastFrame = this.stack[0];
            assert (this.validIndexPrefix <= this.term.length());
            int targetLimit = Math.min(target.length, this.validIndexPrefix);
            int cmp = 0;
            for (targetUpto = 0; targetUpto < targetLimit && (cmp = (this.term.byteAt(targetUpto) & 0xFF) - (target.bytes[target.offset + targetUpto] & 0xFF)) == 0; ++targetUpto) {
                node = this.nodes[1 + targetUpto];
                assert (node.label == (target.bytes[target.offset + targetUpto] & 0xFF)) : "node.label=" + (char)node.label + " targetLabel=" + (char)(target.bytes[target.offset + targetUpto] & 0xFF);
                if (!node.hasOutput()) continue;
                lastFrame = this.stack[1 + lastFrame.ord];
            }
            if (cmp == 0) {
                cmp = Arrays.compareUnsigned(this.term.bytes(), targetUpto, this.term.length(), target.bytes, target.offset + targetUpto, target.offset + target.length);
            }
            if (cmp < 0) {
                this.currentFrame = lastFrame;
            } else if (cmp > 0) {
                this.targetBeforeCurrentLength = lastFrame.ord;
                this.currentFrame = lastFrame;
                this.currentFrame.rewind();
            } else {
                assert (this.term.length() == target.length);
                if (this.termExists) {
                    return () -> true;
                }
            }
        } else {
            this.targetBeforeCurrentLength = -1;
            node = this.trieReader.root;
            assert (node.hasOutput());
            this.currentFrame = this.staticFrame;
            targetUpto = 0;
            this.currentFrame = this.pushFrame(node, 0);
        }
        while (targetUpto < target.length) {
            int targetLabel = target.bytes[target.offset + targetUpto] & 0xFF;
            TrieReader.Node nextNode = this.trieReader.lookupChild(targetLabel, node, this.getNode(1 + targetUpto));
            if (nextNode == null) {
                this.validIndexPrefix = this.currentFrame.prefixLength;
                this.currentFrame.scanToFloorFrame(target);
                if (!this.currentFrame.hasTerms) {
                    this.termExists = false;
                    this.term.setByteAt(targetUpto, (byte)targetLabel);
                    this.term.setLength(1 + targetUpto);
                    return null;
                }
                if (prefetch) {
                    this.currentFrame.prefetchBlock();
                }
                return () -> {
                    this.currentFrame.loadBlock();
                    TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, true);
                    return result == TermsEnum.SeekStatus.FOUND;
                };
            }
            node = nextNode;
            this.term.setByteAt(targetUpto, (byte)targetLabel);
            ++targetUpto;
            if (!node.hasOutput()) continue;
            this.currentFrame = this.pushFrame(node, targetUpto);
        }
        this.validIndexPrefix = this.currentFrame.prefixLength;
        this.currentFrame.scanToFloorFrame(target);
        if (!this.currentFrame.hasTerms) {
            this.termExists = false;
            this.term.setLength(targetUpto);
            return null;
        }
        if (prefetch) {
            this.currentFrame.prefetchBlock();
        }
        return () -> {
            this.currentFrame.loadBlock();
            TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, true);
            return result == TermsEnum.SeekStatus.FOUND;
        };
    }

    @Override
    public IOBooleanSupplier prepareSeekExact(BytesRef target) throws IOException {
        return this.prepareSeekExact(target, true);
    }

    @Override
    public boolean seekExact(BytesRef target) throws IOException {
        IOBooleanSupplier termExistsSupplier = this.prepareSeekExact(target, false);
        return termExistsSupplier != null && termExistsSupplier.get();
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef target) throws IOException {
        int targetUpto;
        TrieReader.Node node;
        this.term.grow(1 + target.length);
        assert (this.clearEOF());
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        if (this.currentFrame != this.staticFrame) {
            node = this.nodes[0];
            assert (node.hasOutput());
            SegmentTermsEnumFrame lastFrame = this.stack[0];
            assert (this.validIndexPrefix <= this.term.length());
            int targetLimit = Math.min(target.length, this.validIndexPrefix);
            int cmp = 0;
            for (targetUpto = 0; targetUpto < targetLimit && (cmp = (this.term.byteAt(targetUpto) & 0xFF) - (target.bytes[target.offset + targetUpto] & 0xFF)) == 0; ++targetUpto) {
                node = this.nodes[1 + targetUpto];
                assert (node.label == (target.bytes[target.offset + targetUpto] & 0xFF)) : "node.label=" + (char)node.label + " targetLabel=" + (char)(target.bytes[target.offset + targetUpto] & 0xFF);
                if (!node.hasOutput()) continue;
                lastFrame = this.stack[1 + lastFrame.ord];
            }
            if (cmp == 0) {
                cmp = Arrays.compareUnsigned(this.term.bytes(), targetUpto, this.term.length(), target.bytes, target.offset + targetUpto, target.offset + target.length);
            }
            if (cmp < 0) {
                this.currentFrame = lastFrame;
            } else if (cmp > 0) {
                this.targetBeforeCurrentLength = 0;
                this.currentFrame = lastFrame;
                this.currentFrame.rewind();
            } else {
                assert (this.term.length() == target.length);
                if (this.termExists) {
                    return TermsEnum.SeekStatus.FOUND;
                }
            }
        } else {
            this.targetBeforeCurrentLength = -1;
            node = this.nodes[0] = this.trieReader.root;
            assert (node.hasOutput());
            this.currentFrame = this.staticFrame;
            targetUpto = 0;
            this.currentFrame = this.pushFrame(node, 0);
        }
        while (targetUpto < target.length) {
            int targetLabel = target.bytes[target.offset + targetUpto] & 0xFF;
            TrieReader.Node nextNode = this.trieReader.lookupChild(targetLabel, node, this.getNode(1 + targetUpto));
            if (nextNode == null) {
                this.validIndexPrefix = this.currentFrame.prefixLength;
                this.currentFrame.scanToFloorFrame(target);
                this.currentFrame.loadBlock();
                TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, false);
                if (result == TermsEnum.SeekStatus.END) {
                    this.term.copyBytes(target);
                    this.termExists = false;
                    if (this.next() != null) {
                        return TermsEnum.SeekStatus.NOT_FOUND;
                    }
                    return TermsEnum.SeekStatus.END;
                }
                return result;
            }
            this.term.setByteAt(targetUpto, (byte)targetLabel);
            node = nextNode;
            ++targetUpto;
            if (!node.hasOutput()) continue;
            this.currentFrame = this.pushFrame(node, targetUpto);
        }
        this.validIndexPrefix = this.currentFrame.prefixLength;
        this.currentFrame.scanToFloorFrame(target);
        this.currentFrame.loadBlock();
        TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, false);
        if (result == TermsEnum.SeekStatus.END) {
            this.term.copyBytes(target);
            this.termExists = false;
            if (this.next() != null) {
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            return TermsEnum.SeekStatus.END;
        }
        return result;
    }

    private void printSeekState(PrintStream out) throws IOException {
        if (this.currentFrame == this.staticFrame) {
            out.println("  no prior seek");
        } else {
            out.println("  prior seek state:");
            int ord = 0;
            boolean isSeekFrame = true;
            while (true) {
                SegmentTermsEnumFrame f = this.getFrame(ord);
                assert (f != null);
                BytesRef prefix = new BytesRef(this.term.get().bytes, 0, f.prefixLength);
                if (f.nextEnt == -1) {
                    out.println("    frame " + (isSeekFrame ? "(seek)" : "(next)") + " ord=" + ord + " fp=" + f.fp + (String)(f.isFloor ? " (fpOrig=" + f.fpOrig + ")" : "") + " prefixLen=" + f.prefixLength + " prefix=" + String.valueOf(prefix) + (String)(f.nextEnt == -1 ? "" : " (of " + f.entCount + ")") + " hasTerms=" + f.hasTerms + " isFloor=" + f.isFloor + " isLastInFloor=" + f.isLastInFloor + " mdUpto=" + f.metaDataUpto + " tbOrd=" + f.getTermBlockOrd());
                } else {
                    out.println("    frame " + (isSeekFrame ? "(seek, loaded)" : "(next, loaded)") + " ord=" + ord + " fp=" + f.fp + (String)(f.isFloor ? " (fpOrig=" + f.fpOrig + ")" : "") + " prefixLen=" + f.prefixLength + " prefix=" + String.valueOf(prefix) + " nextEnt=" + f.nextEnt + (String)(f.nextEnt == -1 ? "" : " (of " + f.entCount + ")") + " hasTerms=" + f.hasTerms + " isFloor=" + f.isFloor + " lastSubFP=" + f.lastSubFP + " isLastInFloor=" + f.isLastInFloor + " mdUpto=" + f.metaDataUpto + " tbOrd=" + f.getTermBlockOrd());
                }
                assert (!isSeekFrame || f.node != null) : "isSeekFrame=" + isSeekFrame + " f.node=" + String.valueOf(f.node);
                if (f.prefixLength > 0 && isSeekFrame && f.node.label != (this.term.byteAt(f.prefixLength - 1) & 0xFF)) {
                    out.println("      broken seek state: node.label=" + (char)f.node.label + " vs term byte=" + (char)(this.term.byteAt(f.prefixLength - 1) & 0xFF));
                    throw new RuntimeException("seek state is broken");
                }
                TrieReader.Node node = this.trieReader.root;
                TrieReader.Node child = new TrieReader.Node();
                for (int i = 0; i < prefix.length; ++i) {
                    TrieReader.Node found = this.trieReader.lookupChild(prefix.bytes[i + prefix.offset] & 0xFF, node, child);
                    if (found == null) {
                        throw new RuntimeException("seek state is broken, prefix not exist in index");
                    }
                    node = child;
                    child = new TrieReader.Node();
                }
                if (!node.hasOutput()) {
                    out.println("      broken seek state: prefix is not final in index");
                    throw new RuntimeException("seek state is broken");
                }
                if (isSeekFrame && !f.isFloor && (f.fp != node.outputFp || f.hasTerms != node.hasTerms || f.isFloor != node.isFloor())) {
                    out.println("      broken seek state: output fp=" + node.outputFp + ", hasTerms=" + node.hasTerms + ", isFloor=" + node.isFloor() + " doesn't match frame fp=" + f.fp + ", hasTerms=" + f.hasTerms + ", isFloor=" + f.isFloor);
                    throw new RuntimeException("seek state is broken");
                }
                if (f == this.currentFrame) break;
                if (f.prefixLength == this.validIndexPrefix) {
                    isSeekFrame = false;
                }
                ++ord;
            }
        }
    }

    @Override
    public BytesRef next() throws IOException {
        if (this.in == null) {
            TrieReader.Node node = this.nodes[0] = this.trieReader.root;
            this.currentFrame = this.pushFrame(node, 0);
            this.currentFrame.loadBlock();
        }
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        assert (!this.eof);
        if (this.currentFrame == this.staticFrame) {
            boolean result = this.seekExact(this.term.get());
            assert (result);
        }
        while (this.currentFrame.nextEnt == this.currentFrame.entCount) {
            if (!this.currentFrame.isLastInFloor) {
                this.currentFrame.loadNextFloorBlock();
                break;
            }
            if (this.currentFrame.ord == 0) {
                assert (this.setEOF());
                this.term.clear();
                this.validIndexPrefix = 0;
                this.currentFrame.rewind();
                this.termExists = false;
                return null;
            }
            long lastFP = this.currentFrame.fpOrig;
            this.currentFrame = this.stack[this.currentFrame.ord - 1];
            if (this.currentFrame.nextEnt == -1 || this.currentFrame.lastSubFP != lastFP) {
                this.currentFrame.scanToFloorFrame(this.term.get());
                this.currentFrame.loadBlock();
                this.currentFrame.scanToSubBlock(lastFP);
            }
            this.validIndexPrefix = Math.min(this.validIndexPrefix, this.currentFrame.prefixLength);
        }
        while (this.currentFrame.next()) {
            this.currentFrame = this.pushFrame(null, this.currentFrame.lastSubFP, this.term.length());
            this.currentFrame.loadBlock();
        }
        return this.term.get();
    }

    @Override
    public BytesRef term() {
        assert (!this.eof);
        return this.term.get();
    }

    @Override
    public int docFreq() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.currentFrame.state.docFreq;
    }

    @Override
    public long totalTermFreq() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.currentFrame.state.totalTermFreq;
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.postings(this.fr.fieldInfo, this.currentFrame.state, reuse, flags);
    }

    @Override
    public ImpactsEnum impacts(int flags) throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.impacts(this.fr.fieldInfo, this.currentFrame.state, flags);
    }

    @Override
    public void seekExact(BytesRef target, TermState otherState) {
        assert (this.clearEOF());
        if (target.compareTo(this.term.get()) != 0 || !this.termExists) {
            assert (otherState != null && otherState instanceof BlockTermState);
            this.currentFrame = this.staticFrame;
            this.currentFrame.state.copyFrom(otherState);
            this.term.copyBytes(target);
            this.currentFrame.metaDataUpto = this.currentFrame.getTermBlockOrd();
            assert (this.currentFrame.metaDataUpto > 0);
            this.validIndexPrefix = 0;
        }
    }

    @Override
    public TermState termState() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        TermState ts = this.currentFrame.state.clone();
        return ts;
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }
}

