/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format.formatter;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.internal.DecimalFraction;
import kotlinx.datetime.internal.MathKt;
import kotlinx.datetime.internal.format.formatter.FormatterStructure;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002B7\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\u0010\u000bJ)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkotlinx/datetime/internal/format/formatter/DecimalFractionFormatterStructure;", "T", "Lkotlinx/datetime/internal/format/formatter/FormatterStructure;", "number", "Lkotlin/Function1;", "Lkotlinx/datetime/internal/DecimalFraction;", "minDigits", "", "maxDigits", "zerosToAdd", "", "(Lkotlin/jvm/functions/Function1;IILjava/util/List;)V", "format", "", "obj", "builder", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "minusNotRequired", "", "(Ljava/lang/Object;Ljava/lang/Appendable;Z)V", "kotlinx-datetime"})
public final class DecimalFractionFormatterStructure<T>
implements FormatterStructure<T> {
    @NotNull
    private final Function1<T, DecimalFraction> number;
    private final int minDigits;
    private final int maxDigits;
    @NotNull
    private final List<Integer> zerosToAdd;

    public DecimalFractionFormatterStructure(@NotNull Function1<? super T, DecimalFraction> number, int minDigits, int maxDigits, @NotNull List<Integer> zerosToAdd) {
        Intrinsics.checkNotNullParameter(number, (String)"number");
        Intrinsics.checkNotNullParameter(zerosToAdd, (String)"zerosToAdd");
        this.number = number;
        this.minDigits = minDigits;
        this.maxDigits = maxDigits;
        this.zerosToAdd = zerosToAdd;
        int n = this.minDigits;
        if (!(1 <= n ? n < 10 : false)) {
            boolean $i$a$-require-DecimalFractionFormatterStructure$32 = false;
            String $i$a$-require-DecimalFractionFormatterStructure$32 = "The minimum number of digits (" + this.minDigits + ") is not in range 1..9";
            throw new IllegalArgumentException($i$a$-require-DecimalFractionFormatterStructure$32.toString());
        }
        n = this.minDigits;
        int $i$a$-require-DecimalFractionFormatterStructure$32 = this.maxDigits;
        if (!(n <= $i$a$-require-DecimalFractionFormatterStructure$32 ? $i$a$-require-DecimalFractionFormatterStructure$32 < 10 : false)) {
            boolean bl = false;
            String string = "The maximum number of digits (" + this.maxDigits + ") is not in range " + this.minDigits + "..9";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void format(T obj, @NotNull Appendable builder, boolean minusNotRequired) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DecimalFraction number = (DecimalFraction)this.number.invoke(obj);
        int numberWithRequiredPrecision = number.fractionalPartWithNDigits(this.maxDigits);
        int zerosToStrip = 0;
        while (this.maxDigits > this.minDigits + zerosToStrip && numberWithRequiredPrecision % MathKt.getPOWERS_OF_TEN()[zerosToStrip + 1] == 0) {
            ++zerosToStrip;
        }
        int zerosToAddBack = ((Number)this.zerosToAdd.get(this.maxDigits - zerosToStrip - 1)).intValue();
        if (zerosToStrip >= zerosToAddBack) {
            zerosToStrip -= zerosToAddBack;
        }
        int digitsToOutput = this.maxDigits - zerosToStrip;
        int numberToOutput = numberWithRequiredPrecision / MathKt.getPOWERS_OF_TEN()[zerosToStrip];
        String string = String.valueOf(numberToOutput + MathKt.getPOWERS_OF_TEN()[digitsToOutput]).substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        builder.append(string);
    }
}

