/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.containerview.PyDataViewDialog;
import com.jetbrains.python.debugger.containerview.PyDataViewerAbstractPanel;
import com.jetbrains.python.debugger.containerview.PyDataViewerCommunityPanel;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import com.jetbrains.python.icons.PythonIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 02\u00020\u0001:\u0002/0B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\rH\u0002J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0015\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\bJ\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\b\u0010\u001c\u001a\u00020\rH\u0002J\u0006\u0010\u001d\u001a\u00020\rJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0018J\b\u0010&\u001a\u00020\u001fH\u0002J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0(J\u000e\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u001fJ\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataView;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "selectedInfos", "", "Lcom/intellij/execution/process/ProcessHandler;", "Lcom/intellij/ui/content/Content;", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "init", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "addEmptyContent", "show", "value", "Lcom/jetbrains/python/debugger/PyDebugValue;", "showInToolWindow", "closeTabs", "ifClose", "Ljava/util/function/Predicate;", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "updateTabs", "handler", "restoreSelectedInfo", "saveSelectedInfo", "closeDisconnectedFromConsoleTabs", "isConnected", "", "accessor", "Lcom/jetbrains/python/console/PydevConsoleCommunication;", "createEmptyContent", "Lcom/intellij/openapi/ui/DialogPanel;", "addTab", "frameAccessor", "hasOnlyEmptyTab", "getVisibleTabs", "", "changeAutoResize", "autoResize", "getPanel", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel;", "component", "Ljavax/swing/JComponent;", "NewViewerAction", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyDataView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataView.kt\ncom/jetbrains/python/debugger/containerview/PyDataView\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,256:1\n23#2:257\n13805#3,2:258\n13805#3,2:260\n13805#3,2:262\n1869#4,2:264\n*S KotlinDebug\n*F\n+ 1 PyDataView.kt\ncom/jetbrains/python/debugger/containerview/PyDataView\n*L\n87#1:257\n104#1:258,2\n119#1:260,2\n222#1:262,2\n111#1:264,2\n*E\n"})
public final class PyDataView
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<ProcessHandler, Content> selectedInfos;
    private ContentManager contentManager;
    @NotNull
    private static final String DATA_VIEWER_ID = "SciView";
    @NotNull
    public static final String COLORED_BY_DEFAULT = "datagrid.heatmap.switchedByDefault";
    @NotNull
    public static final String AUTO_RESIZE = "python.debugger.dataView.autoresize";
    @NotNull
    private static final String HELP_ID = "reference.toolWindows.PyDataView";

    public PyDataView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.selectedInfos = new ConcurrentHashMap();
    }

    public final void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setHelpId(HELP_ID);
        toolWindow.setAvailable(true);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        this.contentManager = contentManager;
        this.addEmptyContent();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(toolWindow){
            final /* synthetic */ ToolWindow $toolWindow;
            {
                this.$toolWindow = $toolWindow;
            }

            public void stateChanged(ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                ToolWindow window = toolWindowManager.getToolWindow("SciView");
                if (window == null) {
                    return;
                }
                if (this.$toolWindow.isAvailable() && this.$toolWindow.getType() == ToolWindowType.FLOATING && !this.$toolWindow.isVisible()) {
                    this.$toolWindow.setShowStripeButton(false);
                    this.$toolWindow.getContentManager().removeAllContents(true);
                }
            }
        });
    }

    private final void addEmptyContent() {
        Content content = ContentFactory.getInstance().createContent((JComponent)this.createEmptyContent(), null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setCloseable(false);
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        contentManager.addContent(content2);
    }

    public final void show(@NotNull PyDebugValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (ToolWindowManager.Companion.getInstance(this.project).getToolWindow(DATA_VIEWER_ID) != null) {
            this.showInToolWindow(value);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> PyDataView.show$lambda$0(this, value));
        }
    }

    private final void showInToolWindow(PyDebugValue value) {
        ToolWindow window = ToolWindowManager.Companion.getInstance(this.project).getToolWindow(DATA_VIEWER_ID);
        if (window == null) {
            PyDataView $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PyDataView.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Tool window 'SciView' is not found");
            return;
        }
        window.getContentManager().getReady((Object)this).doWhenDone(() -> PyDataView.showInToolWindow$lambda$0(this, value, window));
    }

    public final void closeTabs(@NotNull Predicate<PyFrameAccessor> ifClose) {
        Intrinsics.checkNotNullParameter(ifClose, (String)"ifClose");
        List tabsToRemove = new ArrayList();
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        Content[] contentArray = contentManager.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Object[] $this$forEach$iv = contentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Content it = (Content)element$iv;
            boolean bl = false;
            JComponent jComponent = it.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            if (!ifClose.test(this.getPanel(jComponent).getComponent().getDataViewerModel().getFrameAccessor())) continue;
            Intrinsics.checkNotNull((Object)it);
            tabsToRemove.add(it);
        }
        ApplicationManager.getApplication().invokeLater(() -> PyDataView.closeTabs$lambda$1(tabsToRemove, this));
    }

    public final void updateTabs(@NotNull ProcessHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.saveSelectedInfo();
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        Content[] contentArray = contentManager.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Object[] $this$forEach$iv = contentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean shouldBeShown;
            Content content = (Content)element$iv;
            boolean bl = false;
            JComponent jComponent = content.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            PyDataViewerAbstractPanel panel2 = this.getPanel(jComponent).getComponent();
            PyFrameAccessor accessor = panel2.getDataViewerModel().getFrameAccessor();
            if (!(accessor instanceof PyDebugProcess) || (shouldBeShown = Comparing.equal((Object)handler, (Object)((PyDebugProcess)accessor).getProcessHandler()))) continue;
            ContentManager contentManager2 = this.contentManager;
            if (contentManager2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
                contentManager2 = null;
            }
            contentManager2.removeContent(content, true);
        }
        this.restoreSelectedInfo(handler);
    }

    private final void restoreSelectedInfo(ProcessHandler handler) {
        Content savedSelection = this.selectedInfos.get(handler);
        if (savedSelection != null) {
            ContentManager contentManager = this.contentManager;
            if (contentManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
                contentManager = null;
            }
            contentManager.setSelectedContent(savedSelection);
            this.selectedInfos.remove(handler);
        }
    }

    private final void saveSelectedInfo() {
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        Content selectedInfo = contentManager.getSelectedContent();
        if (!this.hasOnlyEmptyTab() && selectedInfo != null) {
            JComponent jComponent = selectedInfo.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            PyFrameAccessor accessor = this.getPanel(jComponent).getComponent().getDataViewerModel().getFrameAccessor();
            if (accessor instanceof PyDebugProcess) {
                this.selectedInfos.put(((PyDebugProcess)accessor).getProcessHandler(), selectedInfo);
            }
        }
    }

    public final void closeDisconnectedFromConsoleTabs() {
        this.closeTabs(arg_0 -> PyDataView.closeDisconnectedFromConsoleTabs$lambda$0(this, arg_0));
    }

    public final boolean isConnected(@NotNull PydevConsoleCommunication accessor) {
        Intrinsics.checkNotNullParameter((Object)((Object)accessor), (String)"accessor");
        return !accessor.isCommunicationClosed();
    }

    private final DialogPanel createEmptyContent() {
        return BuilderKt.panel(PyDataView::createEmptyContent$lambda$0);
    }

    @NotNull
    public final Content addTab(@NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        if (this.hasOnlyEmptyTab()) {
            ContentManager contentManager = this.contentManager;
            if (contentManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
                contentManager = null;
            }
            contentManager.removeAllContents(true);
        }
        PyDataViewerPanel panel2 = new PyDataViewerPanel(this.project, frameAccessor, false, 4, null);
        Content content = ContentFactory.getInstance().createContent((JComponent)panel2, null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setCloseable(true);
        content2.setDisplayName(PyBundle.message("debugger.data.view.empty.tab", new Object[0]));
        if (frameAccessor instanceof PydevConsoleCommunication) {
            content2.setIcon(PythonIcons.Python.PythonConsole);
            content2.setDescription(PyBundle.message("debugger.data.view.connected.to.python.console", new Object[0]));
        } else if (frameAccessor instanceof PyDebugProcess) {
            content2.setIcon(AllIcons.Toolwindows.ToolWindowDebugger);
            Object[] objectArray = new Object[]{((PyDebugProcess)frameAccessor).getSession().getSessionName()};
            content2.setDescription(PyBundle.message("debugger.data.view.connected.to.debug.session", objectArray));
        }
        ToolWindow window = ToolWindowManager.Companion.getInstance(this.project).getToolWindow(DATA_VIEWER_ID);
        if (window instanceof ToolWindowEx) {
            AnAction[] anActionArray = new AnAction[]{new NewViewerAction(frameAccessor)};
            ((ToolWindowEx)window).setTabActions(anActionArray);
        }
        panel2.addListener(arg_0 -> PyDataView.addTab$lambda$0(content2, arg_0));
        Disposer.register((Disposable)((Disposable)content2), (Disposable)panel2);
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        contentManager.addContent(content2);
        ContentManager contentManager2 = this.contentManager;
        if (contentManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager2 = null;
        }
        contentManager2.setSelectedContent(content2);
        return content2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasOnlyEmptyTab() {
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        if (contentManager.getContentCount() != 1) return false;
        ContentManager contentManager2 = this.contentManager;
        if (contentManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager2 = null;
        }
        Content[] contentArray = contentManager2.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        if (((Content)ArraysKt.first((Object[])contentArray)).getComponent() instanceof PyDataViewerPanel) return false;
        return true;
    }

    @NotNull
    public final List<Content> getVisibleTabs() {
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        Content[] contentArray = contentManager.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        return ArraysKt.toList((Object[])contentArray);
    }

    public final void changeAutoResize(boolean autoResize) {
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        Content[] contentArray = contentManager.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Object[] $this$forEach$iv = contentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Content it = (Content)element$iv;
            boolean bl = false;
            JComponent jComponent = it.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            PyDataViewerAbstractPanel pyDataViewerAbstractPanel = this.getPanel(jComponent).getComponent();
            Intrinsics.checkNotNull((Object)pyDataViewerAbstractPanel, (String)"null cannot be cast to non-null type com.jetbrains.python.debugger.containerview.PyDataViewerCommunityPanel");
            ((PyDataViewerCommunityPanel)pyDataViewerAbstractPanel).resize(autoResize);
        }
    }

    @NotNull
    public final PyDataViewerPanel getPanel(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return (PyDataViewerPanel)component;
    }

    private static final void show$lambda$0(PyDataView this$0, PyDebugValue $value) {
        new PyDataViewDialog(this$0.project, $value).show();
    }

    private static final void showInToolWindow$lambda$0(PyDataView this$0, PyDebugValue $value, ToolWindow $window) {
        PyFrameAccessor pyFrameAccessor = $value.getFrameAccessor();
        Intrinsics.checkNotNullExpressionValue((Object)pyFrameAccessor, (String)"getFrameAccessor(...)");
        Content selectedInfo = this$0.addTab(pyFrameAccessor);
        JComponent jComponent = selectedInfo.getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.jetbrains.python.debugger.containerview.PyDataViewerPanel");
        PyDataViewerPanel dataViewerPanel = (PyDataViewerPanel)jComponent;
        PyDataViewerAbstractPanel.apply$default(dataViewerPanel.getComponent(), $value, false, null, 4, null);
        $window.show(() -> PyDataView.showInToolWindow$lambda$0$0($window, dataViewerPanel));
    }

    private static final void showInToolWindow$lambda$0$0(ToolWindow $window, PyDataViewerPanel $dataViewerPanel) {
        $window.getComponent().requestFocusInWindow();
        $dataViewerPanel.requestFocusInWindow();
    }

    private static final void closeTabs$lambda$1(List $tabsToRemove, PyDataView this$0) {
        Iterable $this$forEach$iv = $tabsToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Content it = (Content)element$iv;
            boolean bl = false;
            ContentManager contentManager = this$0.contentManager;
            if (contentManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
                contentManager = null;
            }
            contentManager.removeContent(it, true);
        }
    }

    private static final boolean closeDisconnectedFromConsoleTabs$lambda$0(PyDataView this$0, PyFrameAccessor frameAccessor) {
        return frameAccessor instanceof PydevConsoleCommunication && !this$0.isConnected((PydevConsoleCommunication)frameAccessor);
    }

    private static final Unit createEmptyContent$lambda$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, PyDataView::createEmptyContent$lambda$0$0, (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createEmptyContent$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(PyDataView::createEmptyContent$lambda$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit createEmptyContent$lambda$0$0$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, PyDataView::createEmptyContent$lambda$0$0$0$0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createEmptyContent$lambda$0$0$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PyBundle.message("debugger.data.view.empty.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.text$default((Row)$this$row, (String)string, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final void addTab$lambda$0(Content $content, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $content.setDisplayName(it);
    }

    @JvmStatic
    public static final boolean isAutoResizeEnabled(@NotNull Project project) {
        return Companion.isAutoResizeEnabled(project);
    }

    @JvmStatic
    public static final boolean isColoringEnabled(@NotNull Project project) {
        return Companion.isColoringEnabled(project);
    }

    @JvmStatic
    public static final void setColoringEnabled(@NotNull Project project, boolean value) {
        Companion.setColoringEnabled(project, value);
    }

    @JvmStatic
    public static final void setAutoResizeEnabled(@NotNull Project project, boolean value) {
        Companion.setAutoResizeEnabled(project, value);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0007J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataView$Companion;", "", "<init>", "()V", "DATA_VIEWER_ID", "", "COLORED_BY_DEFAULT", "AUTO_RESIZE", "HELP_ID", "isAutoResizeEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "isColoringEnabled", "setColoringEnabled", "", "value", "setAutoResizeEnabled", "getInstance", "Lcom/jetbrains/python/debugger/containerview/PyDataView;", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPyDataView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataView.kt\ncom/jetbrains/python/debugger/containerview/PyDataView$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,256:1\n30#2,2:257\n*S KotlinDebug\n*F\n+ 1 PyDataView.kt\ncom/jetbrains/python/debugger/containerview/PyDataView$Companion\n*L\n254#1:257,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isAutoResizeEnabled(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return PropertiesComponent.getInstance((Project)project).getBoolean(PyDataView.AUTO_RESIZE, true);
        }

        @JvmStatic
        public final boolean isColoringEnabled(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return PropertiesComponent.getInstance((Project)project).getBoolean(PyDataView.COLORED_BY_DEFAULT, true);
        }

        @JvmStatic
        public final void setColoringEnabled(@NotNull Project project, boolean value) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PropertiesComponent.getInstance((Project)project).setValue(PyDataView.COLORED_BY_DEFAULT, value, true);
        }

        @JvmStatic
        public final void setAutoResizeEnabled(@NotNull Project project, boolean value) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PropertiesComponent.getInstance((Project)project).setValue(PyDataView.AUTO_RESIZE, value, true);
        }

        @NotNull
        public final PyDataView getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PyDataView> serviceClass$iv = PyDataView.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PyDataView)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataView$NewViewerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myFrameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "<init>", "(Lcom/jetbrains/python/debugger/containerview/PyDataView;Lcom/jetbrains/python/debugger/PyFrameAccessor;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.community.impl"})
    public final class NewViewerAction
    extends DumbAwareAction {
        @NotNull
        private final PyFrameAccessor myFrameAccessor;

        public NewViewerAction(PyFrameAccessor myFrameAccessor) {
            Intrinsics.checkNotNullParameter((Object)myFrameAccessor, (String)"myFrameAccessor");
            super(PyBundle.message("debugger.data.view.view.new.container", new Object[0]), PyBundle.message("debugger.data.view.open.new.container.viewer", new Object[0]), AllIcons.General.Add);
            this.myFrameAccessor = myFrameAccessor;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PyDataView.this.addTab(this.myFrameAccessor);
        }
    }
}

