# LeastCommonMultiple
<span class="source-link">[[Source]](src/math/least_common_multiple.md#L-0-1)</span>

Get the least common multiple of x and y where both x and y >= 1.

Providing 0 or numbers that overflow the integer width will result in an
error.

Example usage:

```pony
use "math"

actor Main
  new create(env: Env) =>
    try
      let lcm = LeastCommonMultiple[U64](10, 20)?
      env.out.print(lcm.string())
    else
      env.out.print("No LCM")
    end
```


```pony
primitive val LeastCommonMultiple
```

## Constructors

### create
<span class="source-link">[[Source]](src/math/least_common_multiple.md#L-0-1)</span>


```pony
new val create()
: LeastCommonMultiple val^
```

#### Returns

* [LeastCommonMultiple](math-LeastCommonMultiple.md) val^

---

## Public Functions

### apply\[A: ([Integer](builtin-Integer.md)\[A\] val & ([U8](builtin-U8.md) val | [U16](builtin-U16.md) val | [U32](builtin-U32.md) val | [U64](builtin-U64.md) val | [U128](builtin-U128.md) val | [ULong](builtin-ULong.md) val | [USize](builtin-USize.md) val))\]
<span class="source-link">[[Source]](src/math/least_common_multiple.md#L-0-23)</span>


```pony
fun box apply[A: (Integer[A] val & (U8 val | U16 val | U32 val | 
    U64 val | U128 val | ULong val | 
    USize val))](
  x: A,
  y: A)
: A ?
```
#### Parameters

*   x: A
*   y: A

#### Returns

* A ?

---

### eq
<span class="source-link">[[Source]](src/math/least_common_multiple.md#L-0-23)</span>


```pony
fun box eq(
  that: LeastCommonMultiple val)
: Bool val
```
#### Parameters

*   that: [LeastCommonMultiple](math-LeastCommonMultiple.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/math/least_common_multiple.md#L-0-23)</span>


```pony
fun box ne(
  that: LeastCommonMultiple val)
: Bool val
```
#### Parameters

*   that: [LeastCommonMultiple](math-LeastCommonMultiple.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

