/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.system;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.calcite.plan.AbstractOpenSearchTable;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.monitor.OpenSearchMemoryHealthy;
import org.opensearch.sql.opensearch.monitor.OpenSearchResourceMonitor;
import org.opensearch.sql.opensearch.request.system.OpenSearchCatIndicesRequest;
import org.opensearch.sql.opensearch.request.system.OpenSearchDescribeIndexRequest;
import org.opensearch.sql.opensearch.request.system.OpenSearchSystemRequest;
import org.opensearch.sql.opensearch.storage.system.CalciteLogicalSystemIndexScan;
import org.opensearch.sql.opensearch.storage.system.OpenSearchSystemIndexScan;
import org.opensearch.sql.opensearch.storage.system.OpenSearchSystemIndexSchema;
import org.opensearch.sql.planner.DefaultImplementor;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalPlanNodeVisitor;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.utils.SystemIndexUtils;

public class OpenSearchSystemIndex
extends AbstractOpenSearchTable {
    private final Pair<OpenSearchSystemIndexSchema, OpenSearchSystemRequest> systemIndexBundle;
    private final Settings settings;

    public OpenSearchSystemIndex(OpenSearchClient client, Settings settings, String indexName) {
        this.systemIndexBundle = this.buildIndexBundle(client, indexName);
        this.settings = settings;
    }

    public boolean exists() {
        return true;
    }

    public void create(Map<String, ExprType> schema) {
        throw new UnsupportedOperationException("OpenSearch system index is predefined and cannot be created");
    }

    public Map<String, ExprType> getFieldTypes() {
        return ((OpenSearchSystemIndexSchema)((Object)this.systemIndexBundle.getLeft())).getMapping();
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new CalciteLogicalSystemIndexScan(cluster, relOptTable, this);
    }

    public PhysicalPlan implement(LogicalPlan plan) {
        return (PhysicalPlan)plan.accept((LogicalPlanNodeVisitor)new OpenSearchSystemIndexDefaultImplementor(), null);
    }

    public OpenSearchResourceMonitor createOpenSearchResourceMonitor() {
        return new OpenSearchResourceMonitor(this.getSettings(), new OpenSearchMemoryHealthy(this.settings));
    }

    private Pair<OpenSearchSystemIndexSchema, OpenSearchSystemRequest> buildIndexBundle(OpenSearchClient client, String indexName) {
        SystemIndexUtils.SystemTable systemTable = SystemIndexUtils.systemTable((String)indexName);
        if (systemTable.isSystemInfoTable()) {
            return Pair.of((Object)((Object)OpenSearchSystemIndexSchema.SYS_TABLE_TABLES), (Object)new OpenSearchCatIndicesRequest(client));
        }
        return Pair.of((Object)((Object)OpenSearchSystemIndexSchema.SYS_TABLE_MAPPINGS), (Object)new OpenSearchDescribeIndexRequest(client, systemTable.getTableName(), systemTable.getLangSpec()));
    }

    @Generated
    public Pair<OpenSearchSystemIndexSchema, OpenSearchSystemRequest> getSystemIndexBundle() {
        return this.systemIndexBundle;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @VisibleForTesting
    public class OpenSearchSystemIndexDefaultImplementor
    extends DefaultImplementor<Object> {
        public PhysicalPlan visitRelation(LogicalRelation node, Object context) {
            return new OpenSearchSystemIndexScan((OpenSearchSystemRequest)OpenSearchSystemIndex.this.systemIndexBundle.getRight());
        }

        @Generated
        public OpenSearchSystemIndexDefaultImplementor() {
        }
    }
}

