/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.security.DefaultObjectMapper;

public final class SecurityJsonNode {
    private final JsonNode node;

    public SecurityJsonNode(JsonNode node) {
        this.node = node;
    }

    public SecurityJsonNode get(String name) {
        if (SecurityJsonNode.isNull(this.node)) {
            return new SecurityJsonNode(null);
        }
        JsonNode val = this.node.get(name);
        return new SecurityJsonNode(val);
    }

    public String asString() {
        if (SecurityJsonNode.isNull(this.node)) {
            return null;
        }
        return this.node.asText(null);
    }

    public Integer asInt(Integer defaultValue) {
        if (SecurityJsonNode.isNull(this.node)) {
            return defaultValue;
        }
        return this.node.asInt(0);
    }

    private static boolean isNull(JsonNode node) {
        return node == null || node.isNull();
    }

    public boolean isNull() {
        return SecurityJsonNode.isNull(this.node);
    }

    public SecurityJsonNode get(int i) {
        if (SecurityJsonNode.isNull(this.node) || this.node.getNodeType() != JsonNodeType.ARRAY || i > this.node.size() - 1) {
            return new SecurityJsonNode(null);
        }
        return new SecurityJsonNode(this.node.get(i));
    }

    public SecurityJsonNode getDotted(String string) {
        SecurityJsonNode tmp = this;
        for (String part : string.split("\\.")) {
            tmp = tmp.get(part);
        }
        return tmp;
    }

    public List<String> asList() {
        if (SecurityJsonNode.isNull(this.node) || this.node.getNodeType() != JsonNodeType.ARRAY) {
            return null;
        }
        ArrayList<String> retVal = new ArrayList<String>();
        for (int i = 0; i < this.node.size(); ++i) {
            retVal.add(this.node.get(i).asText());
        }
        return Collections.unmodifiableList(retVal);
    }

    public static SecurityJsonNode fromJson(String json) throws IOException {
        return new SecurityJsonNode(DefaultObjectMapper.readTree(json));
    }
}

