/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import inet.ipaddr.IPAddressString;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.security.support.HostResolverMode;
import org.opensearch.security.support.WildcardMatcher;

public class HostAndCidrMatcher {
    protected final Logger log = LogManager.getLogger(HostAndCidrMatcher.class);
    private final WildcardMatcher hostMatcher;
    private final List<IPAddressString> cidrMatchers;

    public HostAndCidrMatcher(List<String> hostPatterns) {
        if (hostPatterns == null) {
            throw new IllegalArgumentException("Host patterns cannot be null");
        }
        this.hostMatcher = WildcardMatcher.from(hostPatterns);
        this.cidrMatchers = hostPatterns.stream().map(IPAddressString::new).filter(IPAddressString::isIPAddress).toList();
    }

    public boolean matchesCidr(InetAddress address) {
        if (address == null || this.cidrMatchers == null) {
            return false;
        }
        IPAddressString addressString = new IPAddressString(address.getHostAddress());
        return this.cidrMatchers.stream().anyMatch(cidrAddress -> cidrAddress.contains(addressString));
    }

    public boolean matchesHostname(InetAddress address, String hostResolverMode) {
        if (address == null || this.hostMatcher == null) {
            return false;
        }
        ArrayList<String> valuesToCheck = new ArrayList<String>(List.of(address.getHostAddress()));
        if (hostResolverMode != null && (hostResolverMode.equalsIgnoreCase(HostResolverMode.IP_HOSTNAME.getValue()) || hostResolverMode.equalsIgnoreCase(HostResolverMode.IP_HOSTNAME_LOOKUP.getValue()))) {
            try {
                String hostName = address.getHostName();
                valuesToCheck.add(hostName);
            }
            catch (Exception e) {
                this.log.warn("Failed to resolve hostname for {}: {}", (Object)address.getHostAddress(), (Object)e.getMessage());
                return false;
            }
        }
        return valuesToCheck.stream().anyMatch(this.hostMatcher);
    }

    public boolean matches(InetAddress address, String hostResolverMode) {
        return this.matchesHostname(address, hostResolverMode) || this.matchesCidr(address);
    }
}

