/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TTestAggregate
extends AggregateBase
implements AggregateVariant,
ToCopyableBuilder<Builder, TTestAggregate> {
    @Nullable
    private final Double value;
    @Nullable
    private final String valueAsString;
    public static final JsonpDeserializer<TTestAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TTestAggregate::setupTTestAggregateDeserializer);

    private TTestAggregate(Builder builder) {
        super(builder);
        this.value = builder.value;
        this.valueAsString = builder.valueAsString;
    }

    public static TTestAggregate of(Function<Builder, ObjectBuilder<TTestAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.TTest;
    }

    @Nullable
    public final Double value() {
        return this.value;
    }

    @Nullable
    public final String valueAsString() {
        return this.valueAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.value != null) {
            generator.writeKey("value");
            generator.write(this.value.doubleValue());
        }
        if (this.valueAsString != null) {
            generator.writeKey("value_as_string");
            generator.write(this.valueAsString);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTTestAggregateDeserializer(ObjectDeserializer<Builder> op) {
        TTestAggregate.setupAggregateBaseDeserializer(op);
        op.add(Builder::value, JsonpDeserializer.doubleDeserializer(), "value");
        op.add(Builder::valueAsString, JsonpDeserializer.stringDeserializer(), "value_as_string");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.value);
        result = 31 * result + Objects.hashCode(this.valueAsString);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TTestAggregate other = (TTestAggregate)o;
        return Objects.equals(this.value, other.value) && Objects.equals(this.valueAsString, other.valueAsString);
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TTestAggregate> {
        @Nullable
        private Double value;
        @Nullable
        private String valueAsString;

        public Builder() {
        }

        private Builder(TTestAggregate o) {
            super(o);
            this.value = o.value;
            this.valueAsString = o.valueAsString;
        }

        private Builder(Builder o) {
            super(o);
            this.value = o.value;
            this.valueAsString = o.valueAsString;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder value(@Nullable Double value) {
            this.value = value;
            return this;
        }

        @Nonnull
        public final Builder valueAsString(@Nullable String value) {
            this.valueAsString = value;
            return this;
        }

        @Override
        @Nonnull
        public TTestAggregate build() {
            this._checkSingleUse();
            return new TTestAggregate(this);
        }
    }
}

