/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.analysis.ko.dict.CharacterDefinition;
import org.apache.lucene.analysis.ko.dict.TokenInfoFST;
import org.apache.lucene.analysis.ko.dict.UserMorphData;
import org.apache.lucene.analysis.morph.Dictionary;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.FSTReader;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;

public final class UserDictionary
implements Dictionary<UserMorphData> {
    private final TokenInfoFST fst;
    private static final short RIGHT_ID = 3533;
    private static final short RIGHT_ID_T = 3535;
    private static final short RIGHT_ID_F = 3534;
    private UserMorphData morphAtts;

    public static UserDictionary open(Reader reader) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(reader);
        ArrayList<String> entries = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            if ((line = line.replaceAll("#.*$", "")).trim().length() == 0) continue;
            entries.add(line);
        }
        if (entries.isEmpty()) {
            return null;
        }
        return new UserDictionary(entries);
    }

    private UserDictionary(List<String> entries) throws IOException {
        CharacterDefinition charDef = CharacterDefinition.getInstance();
        entries.sort(Comparator.comparing(e -> e.split("\\s+")[0]));
        PositiveIntOutputs fstOutput = PositiveIntOutputs.getSingleton();
        FSTCompiler fstCompiler = new FSTCompiler.Builder(FST.INPUT_TYPE.BYTE2, (Outputs)fstOutput).build();
        IntsRefBuilder scratch = new IntsRefBuilder();
        String lastToken = null;
        ArrayList<int[]> _segmentations = new ArrayList<int[]>(entries.size());
        short[] rightIds = new short[entries.size()];
        long ord = 0L;
        int entryIndex = 0;
        for (String entry : entries) {
            String[] splits = entry.split("\\s+");
            String token = splits[0];
            if (token.equals(lastToken)) continue;
            char lastChar = entry.charAt(entry.length() - 1);
            rightIds[entryIndex++] = charDef.isHangul(lastChar) ? (charDef.hasCoda(lastChar) ? 3535 : 3534) : 3533;
            if (splits.length == 1) {
                _segmentations.add(null);
            } else {
                int[] length = new int[splits.length - 1];
                int offset = 0;
                for (int i = 1; i < splits.length; ++i) {
                    length[i - 1] = splits[i].length();
                    offset += splits[i].length();
                }
                if (offset > token.length()) {
                    throw new IllegalArgumentException("Illegal user dictionary entry " + entry + " - the segmentation is bigger than the surface form (" + token + ")");
                }
                _segmentations.add(length);
            }
            scratch.growNoCopy(token.length());
            scratch.setLength(token.length());
            for (int i = 0; i < token.length(); ++i) {
                scratch.setIntAt(i, (int)token.charAt(i));
            }
            fstCompiler.add(scratch.get(), (Object)ord);
            lastToken = token;
            ++ord;
        }
        if (entryIndex < rightIds.length) {
            rightIds = ArrayUtil.copyOfSubArray((short[])rightIds, (int)0, (int)entryIndex);
        }
        this.fst = new TokenInfoFST((FST<Long>)FST.fromFSTReader((FST.FSTMetadata)fstCompiler.compile(), (FSTReader)fstCompiler.getFSTReader()));
        int[][] segmentations = (int[][])_segmentations.toArray((T[])new int[_segmentations.size()][]);
        this.morphAtts = new UserMorphData(segmentations, rightIds);
    }

    public TokenInfoFST getFST() {
        return this.fst;
    }

    public UserMorphData getMorphAttributes() {
        return this.morphAtts;
    }

    public List<Integer> lookup(char[] chars, int off, int len) throws IOException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        FST.BytesReader fstReader = this.fst.getBytesReader();
        FST.Arc arc = new FST.Arc();
        int end = off + len;
        for (int startOffset = off; startOffset < end; ++startOffset) {
            char ch;
            arc = this.fst.getFirstArc(arc);
            int output = 0;
            int remaining = end - startOffset;
            for (int i = 0; i < remaining && this.fst.findTargetArc(ch = chars[startOffset + i], arc, arc, i == 0, fstReader) != null; ++i) {
                output += ((Long)arc.output()).intValue();
                if (!arc.isFinal()) continue;
                int finalOutput = output + ((Long)arc.nextFinalOutput()).intValue();
                result.add(finalOutput);
            }
        }
        return result;
    }
}

